<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Local language pack from https://jeet.in.net
 *
 * @package    core
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['emailagain'] = 'Confirm email address';
$string['emailconfirmation'] = 'Hi {$a->firstname}, 

A new account has been requested at \'{$a->sitename}\' using your email address. 

To confirm your new account, please <a href="{$a->link}">click here</a> 

In most mail programs, this should appear as a blue link which you can just click on. If that doesn\'t work, then cut and paste the address into the address line at the top of your web browser window. 

If you need help, please <a href="https://jeet.in.net/user/contactsitesupport.php"><strong>contact site support</strong></a>, 

Thanks,<br/>Team Jeet';
$string['emailconfirmationsubject'] = '{$a} complete your registration';
$string['emailconfirmsent'] = '<p class="reg-thanks">Thank you for registering with Jeet</p>
<p>An email is sent to your address, <b>{$a}</b>, Check your spam mail if you haven\'t received it in your inbox and mark the email as "Not Spam."</p> <p>Once the email appears in your inbox, open it and follow the instructions for seamless access to the LMS.</p> <p>It contains easy instructions to complete your registration.</p> <p>If you continue to have difficulty, <a href="https://jeet.in.net/user/contactsitesupport.php" class="link-a"><strong>contact site support.</strong></a></p>';
$string['emailpasswordconfirmmaybesent'] = '<p>If you supplied a unique email address then an email should have been sent to you.</p> <p>It contains easy instructions to confirm and complete this password change. If you continue to have difficulty, please <a href="https://jeet.in.net/user/contactsitesupport.php"><strong>contact site support.</strong></a></p>';
$string['emailresetconfirmation'] = 'Hi {$a->firstname}, 

A password reset was requested for your account \'{$a->username}\' at {$a->sitename}. 

To confirm this request, and set a new password for your account, please <a href="{$a->link}">click here</a> 
(This link is valid for {$a->resetminutes} minutes from the time this reset was first requested.) 

If this password reset was not requested by you, no action is needed. 

If you need help, please <a href="https://jeet.in.net/user/contactsitesupport.php"><strong>contact site support</strong></a>, 

Thanks,<br/> Team Jeet';
$string['forgotaccount'] = 'Forgot Password?';
$string['invalidusername'] = 'The username can only contain alphanumeric lowercase characters (letters and numbers), underscore (_), hyphen (-), period (.) or at symbol (@), Spaces are not allowed.';
$string['newaccount'] = 'Sign up';
$string['passwordforgotteninstructions2'] = 'To reset your password, submit your email address below. If we can find you in the database, an email will be sent to your email address, with instructions how to get access again.';
$string['usernameexists'] = 'This username already exists, choose different username';
