<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'hi', version '4.5'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.calendar.calendarevents'] = 'कैलेंडर ईवेंट';
$string['addon.calendar.defaultnotificationtime'] = 'डिफ़ॉल्ट सूचना समय';
$string['addon.calendar.errorloadevent'] = 'कार्यक्रम लोड करने में त्रुटि हुई।';
$string['addon.calendar.errorloadevents'] = 'कार्यक्रमों को लोड करने में त्रुटि हुई।';
$string['addon.calendar.noevents'] = 'कोई घटना नहीं है';
$string['addon.competency.errornocompetenciesfound'] = 'कोई योग्यता नहीं मिली';
$string['addon.competency.nocompetencies'] = 'कोई योग्यता नहीं';
$string['addon.coursecompletion.complete'] = 'पूर्ण';
$string['addon.coursecompletion.couldnotloadreport'] = 'पाठ्यक्रम पूरा होने की रिपोर्ट लोड नहीं कर सका। बाद में पुन: प्रयास करें।';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'उपकरणों को कॉन्फ़िगर करें';
$string['addon.messages.contactlistempty'] = 'संपर्क सूची खाली है';
$string['addon.messages.contactname'] = 'संपर्क नाम';
$string['addon.messages.deletemessage'] = 'संदेश को हटाएं';
$string['addon.messages.deletemessageconfirmation'] = 'क्या आप निश्चित रूप से यह संदेश हटाना चाहते हैं? यह केवल आपके संदेश इतिहास से हटा दिया जाएगा और अभी भी उपयोगकर्ता द्वारा देखा जा सकता है जिसने संदेश भेजा या प्राप्त किया।';
$string['addon.messages.errordeletemessage'] = 'संदेश हटाते समय त्रुटि।';
$string['addon.messages.errorwhileretrievingcontacts'] = 'सर्वर से संपर्क पुनः प्राप्त करते समय त्रुटि।';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'सर्वर से चर्चाएँ प्राप्त करते समय त्रुटि।';
$string['addon.messages.errorwhileretrievingmessages'] = 'सर्वर से संदेश प्राप्त करते समय त्रुटि।';
$string['addon.messages.errorwhileretrievingusers'] = 'सर्वर से उपयोगकर्ताओं को पुनर्प्राप्त करते समय त्रुटि।';
$string['addon.messages.messagenotsent'] = 'संदेश नहीं भेजा गया था। बाद में पुन: प्रयास करें।';
$string['addon.messages.newmessages'] = 'नए संदेश';
$string['addon.messages.nousersfound'] = 'कोई उपयोग्कर्ता नहीं मिले';
$string['addon.messages.showdeletemessages'] = 'डिलीट मैसेज दिखाओ';
$string['addon.messages.type_blocked'] = 'अवरोधित';
$string['addon.messages.type_offline'] = 'ऑफलाइन';
$string['addon.messages.type_online'] = 'ऑनलाइन';
$string['addon.messages.type_search'] = 'खोज परिणाम';
$string['addon.messages.type_strangers'] = 'अन्य लोग';
$string['addon.messages.warningconversationmessagenotsent'] = 'बातचीत के लिए संदेश नहीं भेजा जा सका {{conversation}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'उपयोगकर्ता को संदेश (संदेश) नहीं भेज सका{{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'कृपया सबमिशन स्टेटमेंट स्वीकार करें।';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'आप एप्लिकेशन में कोई सबमिशन जोड़ या संपादित नहीं कर सकते क्योंकि सबमिशन स्टेटमेंट को साइट से पुनर्प्राप्त नहीं किया जा सकता था';
$string['addon.mod_assign.cannotgradefromapp'] = 'कुछ ग्रेडिंग विधियों को अभी तक ऐप द्वारा समर्थित नहीं किया गया है और उन्हें संशोधित नहीं किया जा सकता है।';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'आप एप्लिकेशन में एक सबमिशन नहीं कर सकते क्योंकि सबमिशन स्टेटमेंट को साइट से पुनर्प्राप्त नहीं किया जा सकता था।';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'आप एप्लिकेशन में कोई सबमिशन जोड़ या संपादित नहीं कर सकते क्योंकि कुछ प्लगइन्स अभी तक संपादन के लिए समर्थित नहीं हैं।';
$string['addon.mod_assign.errorshowinginformation'] = 'सबमिशन की जानकारी प्रदर्शित नहीं की जा सकती।';
$string['addon.mod_assign.feedbacknotsupported'] = 'यह फ़ीडबैक ऐप द्वारा समर्थित नहीं है और इसमें सभी जानकारी नहीं हो सकती है।';
$string['addon.mod_assign.gradenotsynced'] = 'ग्रेड सिंक नहीं किया गया';
$string['addon.mod_assign.notallparticipantsareshown'] = 'जिन प्रतिभागियों ने प्रस्तुत नहीं किया है, उन्हें नहीं दिखाया गया है।';
$string['addon.mod_assign.submissionnotsupported'] = 'यह सबमिशन ऐप द्वारा समर्थित नहीं है और इसमें सभी जानकारी नहीं हो सकती है।';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'प्रस्तुत ग्रेड को साइट पर संशोधित किया गया था।';
$string['addon.mod_assign.warningsubmissionmodified'] = 'उपयोगकर्ता प्रस्तुत साइट पर संशोधित किया गया था।';
$string['addon.mod_chat.errorwhileconnecting'] = 'चैट से कनेक्ट करते समय त्रुटि।';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'चैट डेटा प्राप्त करते समय त्रुटि।';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'चैट उपयोगकर्ताओं को प्राप्त करते समय त्रुटि।';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'सर्वर से संदेश प्राप्त करते समय त्रुटि।';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'संदेश भेजते समय त्रुटि।';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'आपको संदेश भेजने के लिए ऑनलाइन होना चाहिए।';
$string['addon.mod_choice.errorgetchoice'] = 'विकल्प डेटा प्राप्त करने में त्रुटि।';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% उपयोगकर्ताओं ने विकल्प चुना: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'परिणामों में शामिल करने से पहले आपकी अंतिम प्रतिक्रिया को सिंक्रनाइज़ किया जाना चाहिए।';
$string['addon.mod_data.errorapproving'] = 'प्रविष्टि को अस्वीकार या अस्वीकार करने में त्रुटि।';
$string['addon.mod_data.errordeleting'] = 'प्रविष्टि हटाने में त्रुटि।';
$string['addon.mod_feedback.captchaofflinewarning'] = 'कैप्चा के साथ प्रतिक्रिया ऑफ़लाइन पूरी नहीं हो सकती है, या यदि कॉन्फ़िगर नहीं है, या यदि सर्वर डाउन है।';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'इस फ़ीडबैक को बाद में सबमिट करने के लिए सहेजा गया है।';
$string['addon.mod_folder.emptyfilelist'] = 'दिखाने के लिए फाइलें नहीं हैं।';
$string['addon.mod_forum.errorgetforum'] = 'फ़ोरम डेटा प्राप्त करने में त्रुटि।';
$string['addon.mod_forum.errorgetgroups'] = 'समूह सेटिंग्स प्राप्त करने में त्रुटि।';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'इस फोरम में अभी कोई चर्चा नहीं हुई है।';
$string['addon.mod_forum.group'] = 'समूह';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} चर्चाएँ';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} उत्तर';
$string['addon.mod_forum.refreshposts'] = 'पदों को ताज़ा करें';
$string['addon.mod_glossary.browsemode'] = 'प्रविष्टियां ब्राउज़ करें';
$string['addon.mod_glossary.byalphabet'] = 'वर्णक्रम';
$string['addon.mod_glossary.byauthor'] = 'लेखक द्वारा समूह';
$string['addon.mod_glossary.bycategory'] = 'श्रेणी के अनुसार समूह';
$string['addon.mod_glossary.bynewestfirst'] = 'नवीनतम पहले';
$string['addon.mod_glossary.byrecentlyupdated'] = 'हाल ही में अद्यतित';
$string['addon.mod_glossary.bysearch'] = 'खोज';
$string['addon.mod_glossary.cannoteditentry'] = 'प्रविष्टि संपादित नहीं की जा सकती';
$string['addon.mod_glossary.entriestobesynced'] = 'प्रविष्ट किए जाने की प्रविष्टियाँ';
$string['addon.mod_glossary.entrypendingapproval'] = 'यह प्रविष्टि लंबित अनुमोदन है।';
$string['addon.mod_glossary.errorloadingentries'] = 'प्रविष्टियाँ लोड करते समय एक त्रुटि हुई।';
$string['addon.mod_glossary.errorloadingentry'] = 'प्रविष्टि लोड करते समय एक त्रुटि हुई।';
$string['addon.mod_glossary.errorloadingglossary'] = 'शब्दकोष लोड करते समय एक त्रुटि हुई।';
$string['addon.mod_glossary.noentriesfound'] = 'कोई प्रविष्टि नहीं मिली।';
$string['addon.mod_glossary.searchquery'] = 'पूछताछ कीजिए';
$string['addon.mod_imscp.showmoduledescription'] = 'विवरण दिखाएं';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'इस पाठ में एक रैंडम कंटेंट पेज पर जंप होता है। जब तक इसे वेब ब्राउज़र में शुरू नहीं किया गया है, तब तक इसे ऐप में डालने का प्रयास नहीं किया जा सकता है।';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'इस प्रयास की अब समीक्षा नहीं की जा सकती है क्योंकि एक और प्रयास समाप्त हो चुका है।';
$string['addon.mod_lesson.finishretakeoffline'] = 'यह प्रयास ऑफ़लाइन समाप्त हो गया था।';
$string['addon.mod_lesson.retakefinishedinsync'] = 'एक ऑफ़लाइन प्रयास सिंक्रनाइज़ किया गया था। क्या आप इसकी समीक्षा करना चाहते हैं?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'साइट पर प्रयास समाप्त हो गया था।';
$string['addon.mod_lti.errorgetlti'] = 'मॉड्यूल डेटा प्राप्त करने में त्रुटि।';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'लॉन्च URL मान्य नहीं है।';
$string['addon.mod_lti.launchactivity'] = 'गतिविधि का शुभारंभ करें';
$string['addon.mod_page.errorwhileloadingthepage'] = 'पृष्ठ सामग्री लोड करते समय त्रुटि।';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'यह प्रश्नोत्तरी प्रयास निम्नलिखित कारणों से प्रस्तुत नहीं किया जा सकता है:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'यह प्रयास {{$a}} के बाद से सिंक्रनाइज़ नहीं किया गया है। यदि आपने इस प्रयास को किसी अन्य डिवाइस में जारी रखा है, तो आप डेटा खो सकते हैं।';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'उत्तर सहेजते समय एक त्रुटि हुई। क्या आप वाकई क्विज़ छोड़ना चाहते हैं?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'इस क्विज़ को ऐप में डालने का प्रयास नहीं किया जा सकता क्योंकि प्रश्न व्यवहार ऐप द्वारा समर्थित नहीं है:';
$string['addon.mod_quiz.errordownloading'] = 'आवश्यक डेटा डाउनलोड करने में त्रुटि।';
$string['addon.mod_quiz.errorgetattempt'] = 'प्रयास डेटा प्राप्त करने में त्रुटि।';
$string['addon.mod_quiz.errorgetquestions'] = 'प्रश्न प्राप्त करने में त्रुटि।';
$string['addon.mod_quiz.errorgetquiz'] = 'प्रश्नोत्तरी डेटा प्राप्त करने में त्रुटि';
$string['addon.mod_quiz.errorparsequestions'] = 'प्रश्न पढ़ते समय एक त्रुटि हुई। कृपया वेब ब्राउज़र में इस क्विज़ का प्रयास करें।';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'इस क्विज़ को ऐप में लेने का प्रयास नहीं किया जा सकता है क्योंकि इसमें ऐप द्वारा समर्थित प्रश्न नहीं हैं:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'इस क्विज़ को ऐप में लेने का प्रयास नहीं किया जा सकता क्योंकि इसमें ऐप द्वारा समर्थित नियम नहीं हैं:';
$string['addon.mod_quiz.errorsaveattempt'] = 'प्रयास डेटा सहेजते समय एक त्रुटि हुई।';
$string['addon.mod_quiz.finishnotsynced'] = 'समाप्त हो गया, लेकिन सिंक्रनाइज़ नहीं किया गया';
$string['addon.mod_quiz.opentoc'] = 'नेविगेशन पॉपओवर खोलें';
$string['addon.mod_quiz.warningattemptfinished'] = 'ऑफ़लाइन प्रयास खारिज कर दिया गया क्योंकि यह साइट पर समाप्त हो गया था या नहीं मिला।';
$string['addon.mod_quiz.warningdatadiscarded'] = 'कुछ ऑफ़लाइन उत्तरों को छोड़ दिया गया क्योंकि प्रश्न ऑनलाइन संशोधित किए गए थे।';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'कुछ अधूरे उत्तर छोड़ दिए जाने के कारण अधूरा रह गया। कृपया अपने उत्तरों की समीक्षा करें और फिर प्रयास को फिर से शुरू करें।';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'सामग्री लोड करते समय त्रुटि।';
$string['addon.mod_resource.openthefile'] = 'फ़ाइल खोलें';
$string['addon.mod_scorm.cannotcalculategrade'] = 'ग्रेड की गणना नहीं की जा सकी।';
$string['addon.mod_scorm.dataattemptshown'] = 'यह डेटा प्रयास नंबर {{number}} का है।';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'नया ऑफ़लाइन प्रयास करते समय एक त्रुटि हुई। कृपया पुन: प्रयास करें';
$string['addon.mod_scorm.errordownloadscorm'] = 'SCORM डाउनलोड करने में त्रुटि:"{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'SCORM डेटा प्राप्त करने में त्रुटि।';
$string['addon.mod_scorm.errorinvalidversion'] = 'क्षमा करें, एप्लिकेशन केवल SCORM 1.2 का समर्थन करता है।';
$string['addon.mod_scorm.errornotdownloadable'] = 'SCORM पैकेज का डाउनलोड अक्षम है। कृपया अपने साइट व्यवस्थापक से संपर्क करें।';
$string['addon.mod_scorm.errornovalidsco'] = 'इस SCORM पैकेज में लोड करने के लिए एक दृश्य SCO नहीं है।';
$string['addon.mod_scorm.errorpackagefile'] = 'क्षमा करें, एप्लिकेशन केवल ज़िप पैकेज का समर्थन करता है।';
$string['addon.mod_scorm.errorsyncscorm'] = 'सिंक्रनाइज़ करते समय एक त्रुटि हुई। कृपया पुन: प्रयास करें।';
$string['addon.mod_scorm.offlineattemptnote'] = 'इस प्रयास में ऐसा डेटा है जिसे सिंक्रनाइज़ नहीं किया गया है।';
$string['addon.mod_scorm.offlineattemptovermax'] = 'यह प्रयास नहीं भेजा जा सकता है क्योंकि आप अधिकतम प्रयासों को पार कर चुके हैं।';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'यह SCORM पैकेज डाउनलोड नहीं किया गया है। इसे खोलते ही यह अपने आप डाउनलोड हो जाएगा।';
$string['addon.mod_scorm.scormstatusoutdated'] = 'इस SCORM पैकेज को अंतिम डाउनलोड के बाद संशोधित किया गया है। इसे खोलते ही यह अपने आप डाउनलोड हो जाएगा।';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'प्रयास {{number}} से कुछ ऑफ़लाइन डेटा को छोड़ दिया गया है क्योंकि इसे नए प्रयास के रूप में नहीं गिना जा सकता।';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'कुछ प्रयास साइट के साथ सिंक्रनाइज़ नहीं किए जा सके क्योंकि अंतिम ऑनलाइन प्रयास अभी तक समाप्त नहीं हुआ है। कृपया पहले ऑनलाइन प्रयास समाप्त करें।';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'क्षमा करें, आपके सर्वेक्षण को सबमिट करने में एक समस्या थी। कृपया पुन: प्रयास करें।';
$string['addon.mod_survey.errorgetsurvey'] = 'सर्वेक्षण डेटा प्राप्त करने में त्रुटि।';
$string['addon.mod_survey.results'] = 'परिणाम';
$string['addon.mod_url.accessurl'] = 'URL तक पहुँचें';
$string['addon.mod_url.pointingtourl'] = 'URL जो संसाधन को इंगित करता है।';
$string['addon.mod_wiki.errorloadingpage'] = 'पृष्ठ लोड करते समय एक त्रुटि हुई।';
$string['addon.mod_wiki.errornowikiavailable'] = 'इस विकी के पास अभी तक कोई सामग्री नहीं है।';
$string['addon.mod_wiki.gowikihome'] = 'इस विकी के पास अभी तक कोई सामग्री नहीं है।';
$string['addon.mod_wiki.subwiki'] = 'उप-विकि';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'शीर्षक खाली नहीं होना चाहिए';
$string['addon.mod_wiki.viewpage'] = 'पृष्ठ देखें';
$string['addon.mod_wiki.wikipage'] = 'विकी पृष्ठ';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'मूल्यांकन रणनीति {{$a}} समर्थित नहीं है';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'शीर्षक डालना अनिवार्य है।';
$string['addon.mod_workshop.warningassessmentmodified'] = 'साइट पर सबमिशन संशोधित किया गया था।';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'मूल्यांकन साइट पर संशोधित किया गया था।';
$string['addon.notes.warningnotenotsent'] = 'नोट (ओं) को निश्चित रूप से नहीं जोड़ा जा सका {{course}}. {{error}}';
$string['addon.notifications.errorgetnotifications'] = 'सूचनाएं प्राप्त करने में त्रुटि हुई।';
$string['addon.notifications.notifications'] = 'सूचनाएं';
$string['addon.notifications.playsound'] = 'ध्वनि चलाएं';
$string['addon.notifications.therearentnotificationsyet'] = 'कोई सूचना नहीं है।';
$string['appstoredescription'] = 'नोट: यह आधिकारिक Moodle मोबाइल ऐप केवल Moodle साइटों के साथ काम करेगा जो इसे अनुमति देने के लिए स्थापित किए गए हैं। यदि आपको कोई समस्या है तो कृपया अपने Moodle व्यवस्थापक से बात करें।

यदि आपकी Moodle साइट को सही तरीके से कॉन्फ़िगर किया गया है, तो आप इस एप्लिकेशन का उपयोग यहां कर सकते हैं:

- ऑफ़लाइन होने पर भी अपने पाठ्यक्रमों की सामग्री ब्राउज़ करें
- संदेशों और अन्य घटनाओं की तत्काल सूचनाएं प्राप्त करें
- जल्दी से अपने पाठ्यक्रमों में अन्य लोगों को ढूंढें और उनसे संपर्क करें
- अपने मोबाइल डिवाइस से चित्र, ऑडियो, वीडियो और अन्य फाइलें अपलोड करें
- अपने पाठ्यक्रम ग्रेड देखें
- और अधिक!

सभी नवीनतम जानकारी के लिए कृपया http://docs.moodle.org/en/Mobile_app देखें।

हम वास्तव में अब तक की कार्यक्षमता के बारे में किसी भी अच्छी समीक्षा की सराहना करते हैं, और आपके सुझाव इस ऐप को और क्या करना चाहते हैं!
एप्लिकेशन को निम्नलिखित अनुमतियों की आवश्यकता है:
रिकॉर्ड ऑडियो - मडल पर अपलोड करने के लिए ऑडियो रिकॉर्ड करने के लिए
अपने एसडी कार्ड की सामग्री को पढ़ें और संशोधित करें - सामग्री एसडी कार्ड में डाउनलोड की जाती है ताकि आप उन्हें ऑफ़लाइन देख सकें
नेटवर्क एक्सेस - अपनी Moodle साइट से कनेक्ट करने में सक्षम होने के लिए और जांचें कि क्या आप ऑफ़लाइन मोड पर स्विच करने के लिए कनेक्ट हैं या नहीं
स्टार्टअप पर चलाएं - इसलिए जब ऐप बैकग्राउंड में चल रहा हो तब भी आपको लोकल नोटिफिकेशन मिले
फ़ोन को सोने से रोकें - तो आप कभी भी पुश सूचनाएँ प्राप्त कर सकते हैं';
$string['core.browser'] = 'ब्राउज़र';
$string['core.cannotconnect'] = 'कनेक्ट नहीं हो सकता: सत्यापित करें कि आपने URL सही टाइप किया है।';
$string['core.cannotdownloadfiles'] = 'फ़ाइल डाउनलोडिंग अक्षम है। कृपया अपने साइट व्यवस्थापक से संपर्क करें।';
$string['core.captureaudio'] = 'ध्वनि रिकॉर्ड करें';
$string['core.capturedimage'] = 'चित्र लिया।';
$string['core.captureimage'] = 'तस्वीर ले लो';
$string['core.capturevideo'] = 'वीडियो रिकॉर्ड करो';
$string['core.clearsearch'] = 'स्पष्ट खोज';
$string['core.clicktoseefull'] = 'पूर्ण सामग्री देखने के लिए क्लिक करें।';
$string['core.confirmcanceledit'] = 'क्या आप वाकई इस पृष्ठ को छोड़ना चाहते हैं? सभी परिवर्तन खो जाएंगे।';
$string['core.confirmloss'] = 'क्या आपको यकीन है? सभी परिवर्तन खो जाएंगे।';
$string['core.confirmopeninbrowser'] = 'क्या आप इसे वेब ब्राउज़र में खोलना चाहते हैं?';
$string['core.contenteditingsynced'] = 'आपके द्वारा संपादित की जा रही सामग्री सिंक हो गई है।';
$string['core.contentlinks.chooseaccount'] = 'खाता चुनें';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'लिंक खोलने के लिए एक खाता चुनें।';
$string['core.contentlinks.confirmurlothersite'] = 'यह लिंक दूसरी साइट का है। क्या आप इसे खोलना चाहते हैं?';
$string['core.contentlinks.errornoactions'] = 'इस लिंक के साथ प्रदर्शन करने के लिए कोई क्रिया नहीं मिली।';
$string['core.contentlinks.errornosites'] = 'इस लिंक को संभालने के लिए कोई साइट नहीं मिली।';
$string['core.copiedtoclipboard'] = 'क्लिपबोर्ड पर पाठ कॉपी किया गया';
$string['core.course.activitydisabled'] = 'आपके संगठन ने इस गतिविधि को मोबाइल ऐप में अक्षम कर दिया है।';
$string['core.course.activitynotyetviewableremoteaddon'] = 'आपके संगठन ने एक प्लगइन स्थापित किया है जो अभी तक समर्थित नहीं है।';
$string['core.course.allsections'] = 'सभी अनुभाग';
$string['core.course.confirmdownload'] = 'आप {{size}} डाउनलोड करने वाले हैं। क्या तुम वाकई जारी रखना चाहते हो?';
$string['core.course.confirmdownloadunknownsize'] = 'डाउनलोड के आकार की गणना करना संभव नहीं था। क्या तुम वाकई जारी रखना चाहते हो?';
$string['core.course.confirmpartialdownloadsize'] = 'आप <strong> कम से कम </ strong> {{size}} डाउनलोड करने वाले हैं। क्या तुम वाकई जारी रखना चाहते हो?';
$string['core.course.couldnotloadsectioncontent'] = 'अनुभाग सामग्री लोड नहीं की जा सकी। बाद में पुन: प्रयास करें।';
$string['core.course.couldnotloadsections'] = 'अनुभागों को लोड नहीं किया जा सका। बाद में पुन: प्रयास करें।';
$string['core.course.errordownloadingcourse'] = 'पाठ्यक्रम डाउनलोड करने में त्रुटि।';
$string['core.course.errordownloadingsection'] = 'अनुभाग डाउनलोड करने में त्रुटि हुई।';
$string['core.course.errorgetmodule'] = 'गतिविधि डेटा प्राप्त करने में त्रुटि।';
$string['core.course.manualcompletionnotsynced'] = 'मैनुअल पूरा नहीं सिंक्रनाइज़ किया गया';
$string['core.course.nocontentavailable'] = 'फिलहाल कोई सामग्री उपलब्ध नहीं है।';
$string['core.course.refreshcourse'] = 'रिफ्रेश कोर्स';
$string['core.course.useactivityonbrowser'] = 'आप अभी भी अपने डिवाइस के वेब ब्राउज़र का उपयोग करके इसका उपयोग कर सकते हैं।';
$string['core.course.warningmanualcompletionmodified'] = 'एक गतिविधि के मैनुअल पूरा होने को साइट पर संशोधित किया गया था।';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'निश्चित रूप से \'{{name}}\' के कुछ ऑफ़लाइन मैनुअल को हटा दिया गया है। {{error}}';
$string['core.courses.cannotretrievemorecategories'] = 'स्तर {{$ a}} से अधिक गहरी श्रेणियों को पुनर्प्राप्त नहीं किया जा सकता है।';
$string['core.courses.confirmselfenrol'] = 'क्या आप वाकई इस पाठ्यक्रम में स्वयं को नामांकित करना चाहते हैं?';
$string['core.courses.downloadcourses'] = 'पाठ्यक्रम डाउनलोड करें';
$string['core.courses.enrolme'] = 'मेरे दाखिला लिया';
$string['core.courses.errorloadcategories'] = 'श्रेणियां लोड करते समय एक त्रुटि हुई।';
$string['core.courses.errorloadcourses'] = 'पाठ्यक्रम लोड करते समय एक त्रुटि हुई';
$string['core.courses.errorsearching'] = 'खोज करते समय एक त्रुटि हुई।';
$string['core.courses.errorselfenrol'] = 'स्वयं नामांकन करते समय एक त्रुटि हुई।';
$string['core.courses.filtermycourses'] = 'मेरे पाठ्यक्रमों को छानें';
$string['core.courses.notenrollable'] = 'आप इस पाठ्यक्रम में अपना नामांकन नहीं कर सकते।';
$string['core.courses.password'] = 'नामांकन की कुंजी';
$string['core.courses.searchcoursesadvice'] = 'आप अतिथि के रूप में उपयोग करने के लिए पाठ्यक्रम खोजने के लिए खोज पाठ्यक्रम बटन का उपयोग कर सकते हैं या उन पाठ्यक्रमों में खुद को नामांकित कर सकते हैं जो इसे अनुमति देते हैं।';
$string['core.courses.selfenrolment'] = 'स्व नामांकन करना';
$string['core.courses.totalcoursesearchresults'] = 'कुल पाठ्यक्रम: {{$a}}';
$string['core.currentdevice'] = 'वर्तमान डिवाइस';
$string['core.datastoredoffline'] = 'डिवाइस में डेटा संग्रहीत है क्योंकि इसे भेजा नहीं जा सका है। इसे बाद में स्वचालित रूप से भेजा जाएगा।';
$string['core.deletedoffline'] = 'ऑफ़लाइन हटा दिया गया';
$string['core.deleting'] = 'हटाया जा रहा है';
$string['core.dfdaymonthyear'] = 'MM-DD-YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'छोड़ना';
$string['core.dismiss'] = 'खारिज';
$string['core.downloading'] = 'डाउनलोड कर रहा है';
$string['core.emptysplit'] = 'यदि बाएं पैनल खाली है या लोड हो रहा है तो यह पृष्ठ रिक्त दिखाई देगा';
$string['core.errorchangecompletion'] = 'पूर्ण स्थिति बदलते समय एक त्रुटि हुई। कृपया पुन: प्रयास करें।';
$string['core.errordeletefile'] = 'फ़ाइल को हटाने में त्रुटि। कृपया पुन: प्रयास करें।';
$string['core.errordownloading'] = 'फ़ाइल डाउनलोड करने में त्रुटि हुई।';
$string['core.errordownloadingsomefiles'] = 'फ़ाइलों को डाउनलोड करने में त्रुटि। कुछ फाइलें गायब हो सकती हैं।';
$string['core.errorfileexistssamename'] = 'इस नाम की एक फ़ाइल पहले से मौजूद है।';
$string['core.errorinvalidform'] = 'फॉर्म में अमान्य डेटा है। कृपया जांचें कि सभी आवश्यक फ़ील्ड भरे हुए हैं और डेटा मान्य है।';
$string['core.errorinvalidresponse'] = 'अमान्य प्रतिसाद प्राप्त हुआ। यदि त्रुटि बनी रहती है, तो कृपया अपने साइट व्यवस्थापक से संपर्क करें।';
$string['core.errorloadingcontent'] = 'सामग्री लोड करने में त्रुटि हुई।';
$string['core.errorofflinedisabled'] = 'ऑफ़लाइन ब्राउज़िंग आपकी साइट पर अक्षम है। ऐप का उपयोग करने के लिए आपको इंटरनेट से जुड़ा होना चाहिए।';
$string['core.erroropenfilenoapp'] = 'फ़ाइल खोलने में त्रुटि: इस प्रकार की फ़ाइल को खोलने के लिए कोई ऐप नहीं मिला।';
$string['core.erroropenfilenoextension'] = 'फ़ाइल खोलने में त्रुटि: फ़ाइल में एक्सटेंशन नहीं है।';
$string['core.erroropenpopup'] = 'यह गतिविधि पॉपअप खोलने का प्रयास कर रही है। यह एप्लिकेशन में समर्थित नहीं है।';
$string['core.errorrenamefile'] = 'फ़ाइल का नाम बदलने में त्रुटि। कृपया पुन: प्रयास करें।';
$string['core.errorsync'] = 'सिंक्रनाइज़ करते समय एक त्रुटि हुई। कृपया पुन: प्रयास करें।';
$string['core.errorsyncblocked'] = 'यह {{$a}} अभी चल रही प्रक्रिया के कारण सिंक्रनाइज़ नहीं किया जा सकता है। बाद में पुन: प्रयास करें। यदि समस्या बनी रहती है, तो एप्लिकेशन को पुनरारंभ करने का प्रयास करें।';
$string['core.filenameexist'] = 'फ़ाइल नाम पहले से मौजूद है: {{$a}}';
$string['core.fileuploader.audio'] = 'ऑडियो';
$string['core.fileuploader.camera'] = 'कैमरा';
$string['core.fileuploader.confirmuploadfile'] = 'आप {{size}} अपलोड करने वाले हैं। क्या तुम वाकई जारी रखना चाहते हो?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'अपलोड के आकार की गणना करना संभव नहीं था। क्या तुम वाकई जारी रखना चाहते हो?';
$string['core.fileuploader.errorcapturingaudio'] = 'ऑडियो कैप्चर करने में त्रुटि।';
$string['core.fileuploader.errorcapturingimage'] = 'छवि कैप्चर करने में त्रुटि';
$string['core.fileuploader.errorcapturingvideo'] = 'वीडियो कैप्चर करने में त्रुटि।';
$string['core.fileuploader.errorgettingimagealbum'] = 'एल्बम से छवि प्राप्त करने में त्रुटि।';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'फाइल अपलोड करने के लिए आपको ऑनलाइन रहना होगा।';
$string['core.fileuploader.errornoapp'] = 'इस क्रिया को करने के लिए आपके पास कोई ऐप इंस्टॉल नहीं है।';
$string['core.fileuploader.errorreadingfile'] = 'फ़ाइल पढ़ने में त्रुटि।';
$string['core.fileuploader.errorwhileuploading'] = 'फ़ाइल अपलोड के दौरान एक त्रुटि हुई।';
$string['core.fileuploader.file'] = 'फ़ाइल';
$string['core.fileuploader.fileuploaded'] = 'फ़ाइल सफलतापूर्वक अपलोड कर दी गई थी।';
$string['core.fileuploader.maxbytesfile'] = 'फ़ाइल {{$a.file}} बहुत बड़ी है। आपके द्वारा अपलोड किया जाने वाला अधिकतम आकार {{$a.size}} है।';
$string['core.fileuploader.photoalbums'] = 'तस्वीर चित्राधार';
$string['core.fileuploader.readingfile'] = 'फाइल पढ़ना';
$string['core.fileuploader.readingfileperc'] = 'फ़ाइल पढ़ना: {{$a}}%';
$string['core.fileuploader.selectafile'] = 'किसी फाइल का चयन करें';
$string['core.fileuploader.uploadafile'] = 'एक फाइल अपलोड करें';
$string['core.fileuploader.uploading'] = 'अपलोड हो रहा है';
$string['core.fileuploader.uploadingperc'] = 'अपलोड करना: {{$a}}%';
$string['core.fileuploader.video'] = 'वीडियो';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.hasdatatosync'] = 'इस {{$a}} समकालित होने के लिए ऑफ़लाइन डेटा है।';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.image'] = 'छवि';
$string['core.imageviewer'] = 'छवि दर्शक';
$string['core.lastdownloaded'] = 'अंतिम बार डाउनलोड किया गया';
$string['core.lastsync'] = 'अंतिम तुल्यकालन';
$string['core.loadmore'] = 'और लोड करें';
$string['core.login.authenticating'] = 'प्रमाणित कर रहा है';
$string['core.login.confirmdeletesite'] = 'क्या आप वाकई {{sitename}} साइट को हटाना चाहते हैं?';
$string['core.login.connect'] = 'जुडिये!';
$string['core.login.connecttomoodle'] = 'मूडल से कनेक्ट करें';
$string['core.login.contactyouradministrator'] = 'आगे की मदद के लिए अपनी साइट के व्यवस्थापक से संपर्क करें।';
$string['core.login.contactyouradministratorissue'] = 'कृपया निम्न समस्या की जाँच करने के लिए अपने साइट व्यवस्थापक से पूछें: {{$a}}';
$string['core.login.credentialsdescription'] = 'कृपया लॉग इन करने के लिए अपना उपयोगकर्ता नाम और पासवर्ड प्रदान करें।';
$string['core.login.emailconfirmsentnoemail'] = '<p> आपके पते पर एक ईमेल भेजा जाना चाहिए। </ p> <p> इसमें आपका पंजीकरण पूरा करने के लिए आसान निर्देश शामिल हैं। </ p> <p> यदि आपको कठिनाई जारी है, तो साइट व्यवस्थापक से संपर्क करें। </ p>';
$string['core.login.emailnotmatch'] = 'ईमेल एक - दूसरे से मेल नहीं खाते';
$string['core.login.erroraccesscontrolalloworigin'] = 'जिस क्रॉस-ऑरिजिन कॉल को आप करने की कोशिश कर रहे हैं, उसे अस्वीकार कर दिया गया है। कृपया https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_hhhium पर जाएं';
$string['core.login.errordeletesite'] = 'इस साइट को हटाते समय एक त्रुटि हुई। कृपया पुन: प्रयास करें।';
$string['core.login.errorupdatesite'] = 'साइट के टोकन को अपडेट करते समय एक त्रुटि हुई।';
$string['core.login.findyoursite'] = 'अपनी साइट खोजें';
$string['core.login.helpmelogin'] = '<p> दुनिया भर में कई हजारों Moodle साइट्स हैं। यह ऐप केवल उन Moodle साइटों से कनेक्ट हो सकता है जिन्होंने विशेष रूप से मोबाइल ऐप एक्सेस सक्षम किया है। </ p> <p> यदि आप अपनी Moodle साइट से कनेक्ट नहीं कर सकते हैं, तो आपको अपने साइट व्यवस्थापक से संपर्क करने और उन्हें पढ़ने के लिए कहने की आवश्यकता है "http://docs.moodle.org/en/Mobile_app" लक्ष्य = "_blank"> http://docs.moodle.org/en/Mobile_app </a> </ p> <p> में एप्लिकेशन का परीक्षण करने के लिए Moodle डेमो साइट प्रकार <i> शिक्षक </ i> या <i> छात्र </ i> <i> साइट पते </ i> फ़ील्ड में और <b> कनेक्ट बटन </ b> </ p पर क्लिक करें। >';
$string['core.login.invalidaccount'] = 'कृपया अपना लॉगिन विवरण जांचें या साइट के विन्यास की जांच करने के लिए अपने साइट व्यवस्थापक से पूछें।';
$string['core.login.invalidmoodleversion'] = 'अमान्य Moodle संस्करण। आवश्यक न्यूनतम संस्करण {{$a}} है।';
$string['core.login.invalidsite'] = 'साइट URL अमान्य है।';
$string['core.login.invalidtime'] = 'अमान्य समय';
$string['core.login.invalidvaluemax'] = 'अधिकतम मूल्य {{$ a}} है';
$string['core.login.invalidvaluemin'] = 'न्यूनतम मान {{$ a}} है';
$string['core.login.loggedoutssodescription'] = 'आपको फिर से प्रमाणित करना होगा। आपको ब्राउज़र विंडो में साइट पर लॉग इन करना होगा';
$string['core.login.loginbutton'] = 'लॉग इन करें';
$string['core.login.logininsiterequired'] = 'आपको ब्राउज़र विंडो में साइट पर लॉग इन करना होगा।';
$string['core.login.mobileservicesnotenabled'] = 'आपकी साइट पर मोबाइल पहुंच सक्षम नहीं है। कृपया अपने साइट व्यवस्थापक से संपर्क करें यदि आपको लगता है कि इसे सक्षम किया जाना चाहिए।';
$string['core.login.notloggedin'] = 'आपको लॉग इन करने की जरूरत है।';
$string['core.login.passwordrequired'] = 'पासवर्ड आवश्यक';
$string['core.login.recaptchachallengeimage'] = 'reCAPTCHA चुनौती छवि';
$string['core.login.recaptchaexpired'] = 'सत्यापन समाप्त हो गया। सुरक्षा प्रश्न का उत्तर फिर से दें।';
$string['core.login.recaptchaincorrect'] = 'सुरक्षा प्रश्न उत्तर गलत है।';
$string['core.login.reconnect'] = 'फिर से कनेक्ट करें';
$string['core.login.reconnectssodescription'] = 'आपका प्रमाणीकरण टोकन अमान्य है या समाप्त हो चुका है। आपको साइट को फिर से कनेक्ट करना होगा। आपको ब्राउज़र विंडो में साइट पर लॉग इन करना होगा।';
$string['core.login.searchby'] = 'खोज से:';
$string['core.login.selectsite'] = 'Please select your site:';
$string['core.login.signupplugindisabled'] = '{{$ a}} सक्षम नहीं है।';
$string['core.login.siteaddress'] = 'साइट का पता';
$string['core.login.sitehasredirect'] = 'आपकी साइट में कम से कम एक HTTP पुनर्निर्देशित है। ऐप पुनर्निर्देशित नहीं कर सकता है, यह समस्या हो सकती है जो ऐप को आपकी साइट से कनेक्ट करने से रोक रही है।';
$string['core.login.siteinmaintenance'] = 'आपकी साइट रखरखाव मोड में है';
$string['core.login.sitepolicynotagreederror'] = 'साइट नीति सहमत नहीं है।';
$string['core.login.siteurl'] = 'साईट यूआरएल';
$string['core.login.siteurlrequired'] = 'साइट URL की आवश्यकता है i.e <i> http://www.yourmoodlesite.org </ i>';
$string['core.login.stillcantconnect'] = 'अभी भी नहीं जुड़ सकता है?';
$string['core.login.usernamerequired'] = 'उपयोगकर्ता का नाम (आवश्यक';
$string['core.login.visitchangepassword'] = 'क्या आप पासवर्ड बदलने के लिए साइट पर जाना चाहते हैं?';
$string['core.login.webservicesnotenabled'] = 'आपकी साइट में वेब सेवाएँ सक्षम नहीं हैं। कृपया अपने साइट व्यवस्थापक से संपर्क करें यदि आपको लगता है कि उन्हें सक्षम होना चाहिए।';
$string['core.lostconnection'] = 'आपका प्रमाणीकरण टोकन अमान्य है या समाप्त हो चुका है। आपको साइट को फिर से कनेक्ट करना होगा।';
$string['core.networkerroriframemsg'] = 'यह सामग्री ऑफ़लाइन उपलब्ध नहीं है। कृपया इंटरनेट से कनेक्ट करें और पुनः प्रयास करें।';
$string['core.networkerrormsg'] = 'साइट से कनेक्ट करने में समस्या थी। कृपया अपने संपर्क की जांच करे और फिर से प्रयास करें।';
$string['core.nopasswordchangeforced'] = 'आप अपना पासवर्ड बदले बिना आगे नहीं बढ़ सकते।';
$string['core.nopermissionerror'] = 'क्षमा करें, लेकिन आपके पास वर्तमान में ऐसा करने की अनुमति नहीं है';
$string['core.notapplicable'] = 'n/a';
$string['core.notsent'] = 'नहीं भेजा गया';
$string['core.openfullimage'] = 'पूर्ण आकार की छवि प्रदर्शित करने के लिए यहां क्लिक करें';
$string['core.openinbrowser'] = 'ब्राउज़र में खोलें';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.pulltorefresh'] = 'रीफ़्रेश करने के लिए खींचें';
$string['core.question.cannotdeterminestatus'] = 'स्थिति का निर्धारण नहीं किया जा सकता';
$string['core.question.errorquestionnotsupported'] = 'यह प्रश्न प्रकार ऐप द्वारा समर्थित नहीं है: {{$a}}';
$string['core.question.howtodraganddrop'] = 'चुनने के लिए टैप करें फिर ड्रॉप करने के लिए टैप करें।';
$string['core.question.questionmessage'] = 'प्रश्न {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'आपको साइट पर पुनः निर्देशित किया जाएगा।';
$string['core.requireduserdatamissing'] = 'इस उपयोगकर्ता के पास कुछ आवश्यक प्रोफ़ाइल डेटा का अभाव है। कृपया अपनी साइट में डेटा दर्ज करें और पुनः प्रयास करें। <br> {{$a}}';
$string['core.retry'] = 'पुन: प्रयास करें';
$string['core.searching'] = 'खोज कर';
$string['core.settings.about'] = 'के बारे में';
$string['core.settings.cannotsyncoffline'] = 'ऑफ़लाइन सिंक्रनाइज़ नहीं किया जा सकता।';
$string['core.settings.cannotsyncwithoutwifi'] = 'समन्‍वयित नहीं किया जा सकता है क्‍योंकि वर्तमान सेटिंग केवल वाई-फाई से कनेक्‍ट होने पर समन्‍वयित करने की अनुमति देती है। कृपया वाई-फाई नेटवर्क से कनेक्ट करें।';
$string['core.settings.compilationinfo'] = 'संकलन की जानकारी';
$string['core.settings.cordovadevicemodel'] = 'कॉर्डोवा डिवाइस मॉडल';
$string['core.settings.cordovadeviceosversion'] = 'कॉर्डोवा डिवाइस ओएस संस्करण';
$string['core.settings.cordovadeviceplatform'] = 'कॉर्डोवा डिवाइस प्लेटफॉर्म';
$string['core.settings.cordovadeviceuuid'] = 'Cordova device UUID';
$string['core.settings.cordovaversion'] = 'कॉर्डोवा संस्करण';
$string['core.settings.debugdisplaydescription'] = 'यदि सक्षम किया गया है, तो त्रुटि मोडल्यूस संभव हो तो त्रुटि के बारे में अधिक डेटा प्रदर्शित करेगा।';
$string['core.settings.deviceinfo'] = 'यंत्र की जानकारी';
$string['core.settings.deviceos'] = 'डिवाइस ओएस';
$string['core.settings.displayformat'] = 'प्रारूप को प्रदर्शित करें';
$string['core.settings.enabledownloadsection'] = 'अनुभागों को डाउनलोड करना सक्षम करें';
$string['core.settings.enablerichtexteditor'] = 'पाठ संपादक सक्षम करें';
$string['core.settings.enablerichtexteditordescription'] = 'यदि सक्षम है, तो सामग्री दर्ज करते समय एक पाठ संपादक उपलब्ध होगा।';
$string['core.settings.enablesyncwifi'] = 'वाई-फाई पर केवल तब ही सिंक करने की अनुमति दें';
$string['core.settings.errorsyncsite'] = 'साइट डेटा सिंक्रनाइज़ करने में त्रुटि। अपने इंटरनेट कनेक्शन की जाँच करें और पुन: प्रयास करें।';
$string['core.settings.estimatedfreespace'] = 'अनुमानित खाली स्थान';
$string['core.settings.filesystemroot'] = 'फ़ाइल सिस्टम रूट';
$string['core.settings.localnotifavailable'] = 'स्थानीय सूचनाएं उपलब्ध हैं';
$string['core.settings.locationhref'] = 'वेब व्यू URL';
$string['core.settings.navigatorlanguage'] = 'नेविगेटर भाषा';
$string['core.settings.navigatoruseragent'] = 'नेविगेटर userAgent';
$string['core.settings.networkstatus'] = 'Internet connection status';
$string['core.settings.privacypolicy'] = 'गोपनीयता नीति';
$string['core.settings.reportinbackground'] = 'त्रुटियों की रिपोर्ट स्वचालित रूप से करें';
$string['core.settings.showdownloadoptions'] = 'डाउनलोड विकल्प दिखाएं';
$string['core.settings.spaceusage'] = 'अंतरिक्ष उपयोग';
$string['core.settings.synchronization'] = 'तुल्यकालन';
$string['core.settings.synchronizenow'] = 'अब सिंक्रनाइज़ करें';
$string['core.settings.syncsettings'] = 'सिंक्रनाइज़ेशन सेटिंग्स';
$string['core.settings.wificonnection'] = 'वाईफाई कनेक्शन';
$string['core.sharedfiles.chooseaccountstorefile'] = 'फ़ाइल को स्टोर करने के लिए एक खाता चुनें।';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'इस नाम की एक फ़ाइल पहले से मौजूद है। क्या आप मौजूदा फ़ाइल को बदलना चाहते हैं या इसे "{{$a}}" नाम देना चाहते हैं?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'There are no sites stored. Please add a site before sharing a file with the app.';
$string['core.sharedfiles.nosharedfiles'] = 'इस साइट पर कोई साझा फ़ाइलें संग्रहीत नहीं हैं।';
$string['core.sharedfiles.nosharedfilestoupload'] = 'आपके पास यहां अपलोड करने के लिए कोई फाइल नहीं है। यदि आप किसी अन्य ऐप से फ़ाइल अपलोड करना चाहते हैं, तो फ़ाइल का पता लगाएं और \'ओपन\' बटन पर क्लिक करें।';
$string['core.sharedfiles.rename'] = 'नाम बदलें';
$string['core.sharedfiles.replace'] = 'बदलने के';
$string['core.sharedfiles.sharedfiles'] = 'फ़ाइलें साझा की हैं';
$string['core.sharedfiles.successstorefile'] = 'फ़ाइल सफलतापूर्वक संग्रहीत की गई। अपनी निजी फ़ाइलों को अपलोड करने के लिए फ़ाइल का चयन करें या किसी गतिविधि में उपयोग करें।';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'माफ़ कीजिये...';
$string['core.tablet'] = 'Tablet';
$string['core.thereisdatatosync'] = 'सिंक्रनाइज़ होने के लिए ऑफ़लाइन {{$a}} हैं।';
$string['core.tryagain'] = 'पुनः प्रयास करें';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'उह ओह!';
$string['core.unexpectederror'] = 'अप्रत्याशित त्रुटि। कृपया आवेदन को बंद करें और फिर से खोलें।';
$string['core.unicodenotsupported'] = 'इस साइट पर कुछ इमोजीस समर्थित नहीं हैं। संदेश भेजे जाने पर ऐसे वर्ण हटा दिए जाएंगे।';
$string['core.unicodenotsupportedcleanerror'] = 'यूनिकोड वर्णों की सफाई करते समय खाली पाठ पाया गया।';
$string['core.unknown'] = 'अनजान';
$string['core.unzipping'] = 'अनज़िप';
$string['core.user.contact'] = 'संपर्क करें';
$string['core.user.detailsnotavailable'] = 'इस उपयोगकर्ता का विवरण आपके लिए उपलब्ध नहीं है।';
$string['core.user.errorloaduser'] = 'उपयोगकर्ता लोड करने में त्रुटि हुई।';
$string['core.user.sendemail'] = 'ईमेल';
$string['core.viewcode'] = 'कोड देखें';
$string['core.vieweditor'] = 'संपादक देखें';
$string['core.viewembeddedcontent'] = 'एम्बेडेड सामग्री देखें';
$string['core.warningofflinedatadeleted'] = '{{componenet}} \'{{name}}\' से ऑफ़लाइन डेटा हटा दिया गया है। {{error}}';
$string['core.whyisthishappening'] = 'ये क्यों हो रहा है?';
$string['core.wsfunctionnotavailable'] = 'वेब सेवा फ़ंक्शन उपलब्ध नहीं है।';
$string['pluginname'] = 'moodle मोबाइल  भाषा की strings';
