<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'hi', version '4.5'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'इनस्टॉल होने वाला है';
$string['accept'] = 'स्वीकारें';
$string['action'] = 'कार्य';
$string['actionchoice'] = 'आप \'{$a}\' फाइल  के साथ क्या करना चाहते हैं?';
$string['actions'] = 'कार्य';
$string['actionsfor'] = '{$a} के लिए कार्य';
$string['actionsmenu'] = 'कार्रवाई मेनू';
$string['active'] = 'सक्रिय';
$string['activeusers'] = 'सक्रिय उपयोगकर्ता';
$string['activities'] = 'गतिविधियाँ';
$string['activities_help'] = 'फोरम, क्विज़ और विकी जैसी गतिविधियां इंटेरेक्टिव सामग्री को कोर्से में डालने में मदद करती हैं';
$string['activity'] = 'गतिविधि';
$string['activityclipboard'] = 'इस गतिविधि को स्थानांतरित  किया जा रहा है: <strong>{$a}</strong>';
$string['activityheader'] = 'गतिविधि मेनू';
$string['activityicon'] = '{$a} प्रतिक';
$string['activityiscurrentlyhidden'] = 'क्षमा करें, यह गतिविधि फिलहाल छिपी है';
$string['activitymodule'] = 'गतिविधि मॉड्यूल';
$string['activitymodules'] = 'गतिविधि मॉड्यूल';
$string['activitynotready'] = 'गतिविधि अभी तक तैयार नहीं है';
$string['activityreport'] = 'गतिविधि रिपोर्ट';
$string['activityreports'] = 'गतिविधि रिपोर्ट्स';
$string['activityselect'] = 'इस गतिविधि को दूसरी जगह स्थानांतरित करने के लिए चुनिए';
$string['activitysince'] = '{$a} उसके बाद हुईं गतिविधियां';
$string['activitytypetitle'] = '{$a->गतिविधि} - {$a-> प्रकार}';
$string['activityweighted'] = 'प्रति उपयोगकर्ता गतिविधि';
$string['add'] = 'जोड़ें';
$string['addactivity'] = 'गतिविधि जोड़ें...';
$string['addactivitytosection'] = 'अनुभाग \'{$a}\' के लिए एक गतिविधि जोड़ें';
$string['addadmin'] = 'व्यवस्थापक को जोड़ें';
$string['addblock'] = 'एक खंड जोड़ें';
$string['addcomment'] = 'टिप्पणी करे...';
$string['addcondition'] = 'स्थि‍ति जोड़ें';
$string['addcountertousername'] = 'उपयोगकर्ता नाम में अंक जोड़कर नया उपयोगकर्ता बनाये';
$string['addcreator'] = 'कोर्स-निर्माता को जोड़ें';
$string['adddots'] = 'जोड़ें ...';
$string['added'] = '{$a} जोड़ा गया';
$string['addedtogroup'] = 'समूह "{$a}" में शामिल किया गया';
$string['addedtogroupnot'] = 'समूह "{$a}" में शामिल नहीं किया गया';
$string['addedtogroupnotenrolled'] = 'कोर्स में नामांकित नहीं होने के कारण समूह "{$a}" में नहीं जोड़ा गया';
$string['addfilehere'] = 'फ़ाइलों को इस अनुभाग के निचले भाग में जोड़ने के लिए उन्हें यहाँ ड्रॉप करें';
$string['addinganew'] = 'एक नया {$a} जोड़ा जा रहा है';
$string['addinganewto'] = '{$a->to} में एक नया {$a->what} जोड़ा जा रहा है';
$string['addingdatatoexisting'] = 'मौजूदा में जानकारी जोड़ी जा रही है';
$string['additionalcustomnav'] = 'अतिरिक्त कस्टम नेविगेशन';
$string['additionalnames'] = 'अतिरिक्त नाम';
$string['addlinkhere'] = 'लिंक यहां जोड़ें';
$string['addnew'] = 'एक नया {$a} जोड़ें';
$string['addnewcategory'] = 'नया वर्ग जोड़िए';
$string['addnewcourse'] = 'एक नया कोर्स  बनाएं';
$string['addnewuser'] = 'नए उपयोगकर्ता को जोड़ें';
$string['addnousersrecip'] = 'इस सूची को उपागमन न किये हुए उपयोगकर्ताो को जोड़';
$string['addpagehere'] = 'पाठ यहां जोड़ें';
$string['addresource'] = 'संसाधन जोड़िए...';
$string['addresourceoractivity'] = 'एक नयी गतिविधि या संसाधन जोड़ें';
$string['addresourcetosection'] = 'अनुभाग \'{$a}\'  में एक संसाधन जोड़ें';
$string['address'] = 'पता';
$string['addsections'] = 'भाग जोड़ें';
$string['addstudent'] = 'विद्यार्थी को जोड़िए';
$string['addsubcategory'] = 'एक उपश्रेणी जोड़े';
$string['addteacher'] = 'अध्यापक को जोड़ें';
$string['admin'] = 'व्यवस्थापक';
$string['adminhelpaddnewuser'] = 'मैन्युअल रूप से एक नया उपयोगकर्ता खाता बनाने के लिए';
$string['adminhelpassignadmins'] = 'व्यवस्थापक साइट पर कही भी, कुछ भी कर सकते हैं';
$string['adminhelpassigncreators'] = 'पाठ्यक्रम  निर्माता नया पाठ्यक्रम बना सकते हैं';
$string['adminhelpassignsiteroles'] = 'विशिष्ट उपयोगकर्ताओं को परिभाषित साइट भूमिकाये लागू करें';
$string['adminhelpassignstudents'] = 'एक पाठ्यक्रम में जाओ और व्यवस्थापक सूची से नया छात्र जोड़ो';
$string['adminhelpauthentication'] = 'आप आंतरिक उपयोगकर्ता खातों या बाहरी डेटाबेस का उपयोग कर सकते हैं';
$string['adminhelpbackup'] = 'स्वचालित बैकअप और उसका कार्यक्रम विन्यस्त करें';
$string['adminhelpconfiguration'] = 'साइट का प्रारूप और कार्य विन्यस्त करें';
$string['adminhelpconfigvariables'] = 'साइट के सामान्य सन्चालन को प्रभावित करने वाले variables को विन्यस्त करें';
$string['adminhelpcourses'] = 'पाठ्यक्रम और श्रेणियों को परिभाषित करे व उनके लिए लोग नियुक्त कीजिए, लंबित पाठ्यक्रमों को संपादित करें';
$string['adminhelpeditorsettings'] = 'पाठ्यक्रम और श्रेणियों को परिभाषित करे व उनके लिए लोग नियुक्त कीजिए, लंबित पाठ्यक्रमों को संपादित करें';
$string['adminhelpedituser'] = 'यूज़र ऍकाउन्ट सूची देखें व सम्पादन करें';
$string['adminhelpenvironment'] = 'आपका सर्वर वर्तमान और भविष्यत संस्थापन अपेक्षाएँ को मिल सकता है यह परीक्षण किजीये';
$string['adminhelpfailurelogs'] = 'असफल लॉगिन्स के लॉग्स देखिए';
$string['adminhelplanguage'] = 'वर्तमान भाषा पैक का निरीक्षण व सम्पादन कीजिए';
$string['adminhelplogs'] = 'इस साइट पर हुई सभी गतिविधियों के लॉग्स देखिए';
$string['adminhelpmanageblocks'] = 'इन्स्टॉल किए गए ब्लॉक्स व उन्की सॅटिन्ग्स का सन्चालन कीजिए';
$string['adminhelpmanagedatabase'] = 'डेटाबेस को सीधे ऍक्सॅस करें (सावधान रहें!)';
$string['adminhelpmanagefilters'] = 'टेक्स्ट फ़िल्टर्स और सम्बन्धित सॅटिन्ग्स चुनिए';
$string['adminhelpmanagemodules'] = 'इन्स्टॉल किए गए मॉड्यूल्स और उनकी सॅटिन्ग्स का सन्चालन
कीजिए';
$string['adminhelpmanageroles'] = 'उपयोगकर्ता को लगाए जाने वाले भूमिका बनाए और परिभाषित करे';
$string['adminhelpmymoodle'] = 'उपयोगकर्ता के लिए मूडल ब्लॉक को रूप दे';
$string['adminhelpreports'] = 'साईट स्तर रिपोर्ट';
$string['adminhelpsitefiles'] = 'सार्वजनिक फ़ाइल्स पब्लिश करने या बाहरी बैकप्स अप्लोड करने
के लिए';
$string['adminhelpsitesettings'] = 'साइट के मुख्य पेज की रूपरेखा को परिभाषित कीजिए';
$string['adminhelpstickyblocks'] = 'पूरे मूडल के स्टिकी ब्लॉक्स को रूप दे';
$string['adminhelpthemes'] = 'साइट के रंगरूप का चयन कीजिये (रंग, फोन्ट इत्यादि)';
$string['adminhelpuploadusers'] = 'टॅक्स्ट फ़ाइल से नए यूज़र ऍकाउन्ट आयात कीजिये';
$string['adminhelpusers'] = 'अपने उपयोगकर्ताओं को परिभाषित कीजिए और प्रमाणीकरण सेटअप कीजिए';
$string['adminhelpxmldbeditor'] = 'XMLDB फाय्लेस को संपादन करने के लीये अंतरानीक. सिर्फ विकासक के लीय.';
$string['administration'] = 'प्रबंधन';
$string['administrationsite'] = 'साईट प्रबंधन';
$string['administrator'] = 'व्यवस्थापक';
$string['administratordescription'] = 'व्यवस्थापक आमतौर पर साइट पर कुछ भी कर सकते हैं, सभी पाठ्यक्रमों में.';
$string['administrators'] = 'व्यवस्थापक';
$string['administratorsall'] = 'सभी व्यवस्थापक';
$string['administratorsandteachers'] = 'व्यवस्थापक और अध्यापक';
$string['advanced'] = 'उन्नत';
$string['advancedfilter'] = 'उन्नत खोज';
$string['advancedsettings'] = 'उन्नत सॅटिन्ग्स';
$string['afterresource'] = 'संसाधन "{$a}" के बाद';
$string['aftersection'] = 'अनुभाग "{$a}" के बाद';
$string['again'] = 'फिर से';
$string['agelocationverification'] = 'आयु और स्थान सत्यापन';
$string['ajaxuse'] = 'AJAX और Javascript';
$string['all'] = 'सभी';
$string['allactions'] = 'सारी कार्यवाहियां';
$string['allactivities'] = 'सारी गतिविधियां';
$string['allcategories'] = 'सारी श्रेणियाँ';
$string['allchanges'] = 'सारे बदलाव';
$string['alldays'] = 'सभी दिन';
$string['allfiles'] = 'सारे दस्तावेज';
$string['allgroups'] = 'सभी समूह';
$string['alllogs'] = 'सभी सूचियाँ';
$string['allmods'] = 'सभी {$a}';
$string['allow'] = 'अनुमति दीजिए';
$string['allowinternal'] = 'आन्तरिक तरीके प्रयोग करने की अनुमति भी दीजिए';
$string['allownone'] = 'किसी को भी अनुमति नहीं';
$string['allownot'] = 'अनुमति मत दीजिए';
$string['allowstealthmodules'] = 'गुप्त गतिविधियों को अनुमति दें';
$string['allowstealthmodules_help'] = 'यदि सक्रिय किया गया तो गतिविधियां उपलब्ध तो कराई जा सकती हैं, परन्तु कोर्स पेज के प्रत्यक्ष भाग में नहीं दिखेगा। यदि हाँ तो गुप्त गतिविधयों का लिंक कहीं और जैसे कि पेज संसाधन से उपलब्ध कराया जाना चाहिए। गुप्त गतिविधियां अभी भी ग्रेडबुक एवं अन्य रिपोर्टों में सूचीबद्ध होंगी।';
$string['allparticipants'] = 'सभी प्रतिभागी';
$string['allteachers'] = 'सभी अध्यापक';
$string['alphanumerical'] = 'केवल अक्षर, अंक, (-) या (.) ही प्रयोग में लाए जा सकते हैं';
$string['alreadyconfirmed'] = 'पंजीकरण की पहले ही पुष्टि हो चुकी है';
$string['alternatename'] = 'वैकल्पिक नाम';
$string['always'] = 'हमेशा';
$string['and'] = '{$a->one} और {$a->two}';
$string['answer'] = 'उत्तर';
$string['any'] = 'कोई';
$string['appearance'] = 'दिखावट';
$string['apply'] = 'लागु करे';
$string['applyfilters'] = 'फ़िल्टर लागू करें';
$string['approve'] = 'स्वीकार';
$string['areyousure'] = 'आप को यकीन हैं ?';
$string['areyousuretorestorethis'] = 'क्या आप जारी रखना चाहते हैं?';
$string['areyousuretorestorethisinfo'] = 'बाद में आपके पास इस बैकप को किसी कोर्स में जोड़ने या फिर एक नया कोर्स बनाने का विकल्प होगा।';
$string['asc'] = 'आरोही';
$string['assessment'] = 'मूल्यांकन';
$string['assignadmins'] = 'व्यवस्थापक निर्धारित कीजिए';
$string['assigncreators'] = 'निर्माता निर्धारित कीजिए';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'पूरी साइट के लिए भूमिकाये नियुक्त कीजिये';
$string['authenticateduser'] = 'प्रमाणीकृत उपयोगकर्ता';
$string['authenticateduserdescription'] = 'सभी प्रमाणिक उपयोगकर्ता';
$string['authentication'] = 'प्रमाणीकरण';
$string['authenticationplugins'] = 'प्रमाणीकरण प्लग-इन';
$string['autosubscribe'] = 'चर्चा मंच स्वत:-सदस्यता';
$string['autosubscribeno'] = 'नहीं: मुझे चर्चा मंच की स्वत:-सदस्यता मत दीजिये';
$string['autosubscribeyes'] = 'जी हाँ: जब मैं टिप्पणी करूँ, तो मुझे उस चर्चा-मंच की सदस्यता प्रदान करिए';
$string['availability'] = 'उपलब्धता';
$string['availablecourses'] = 'उपलब्ध पाठ्यक्रम';
$string['back'] = 'वापस';
$string['backto'] = '{$a} पर वापस जायें';
$string['backtocourselisting'] = 'पाठ्यक्रम तालिका पर वापस जायें';
$string['backtohome'] = 'होम पेज पर वापस';
$string['backtopageyouwereon'] = 'वापस उस पृष्ठ पर जायें जहाँ आप थे';
$string['backup'] = 'बैकअप';
$string['backupactivehelp'] = 'स्वाचालित बैकअप करना हैं या नही यह चुनिए';
$string['backupadhocpending'] = 'पाठ्यक्रम बैकअप तदर्थ कार्य लंबित है';
$string['backupcancelled'] = 'बैकअप निरस्त कर दिया गया';
$string['backupcoursefileshelp'] = 'अगर चुना गया, तो कोर्स फ़ाइल्स को स्वचालित बैकप्स में शामिल किया जाएगा';
$string['backupdate'] = 'बैकप की तारीख';
$string['backupdatenew'] = '&nbsp; {$a->TAG} अब हैं {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} था {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'बैकअप विवरण';
$string['backuperrorinvaliddestination'] = 'बैकअप फ़ोल्डर मौजूद नही है या उस पर लिखने की अनुमति नहीं है|';
$string['backupexecuteathelp'] = 'किस समय पर स्वाचालित बैकअप करना हैं यह चुनिए';
$string['backupfailed'] = 'आपके कुछ कोर्स सेव नहीं किये गए थे!';
$string['backupfilename'] = 'बैकअप';
$string['backupfinished'] = 'बैकअप सफलतापूर्वक पूरा हुआ';
$string['backupfromthissite'] = 'क्या इस साइट पर बैकअप बनाया गया था?';
$string['backupgradebookhistoryhelp'] = 'अगर सक्रिय किया गया तो ग्रदेबूक का इतिहास स्वचालित बैकअप में शामिल किया जाएगा|ध्यान मे रहे कि यह काम करने के लिए ग्रेड इतिहास सर्वर सेटिंग में निष्क्रिय नहीं किया जाना चाहिए';
$string['backupincludemoduleshelp'] = 'स्वचालित बैकअप में आप कोर्स मॉड्यूल्स के साथ यूज़र डेटा को शामिल करना चाहेंगे या नहीं?';
$string['backupincludemoduleuserdatahelp'] = 'स्वचालित बैकअप में मॉड्यूल उपयोगकर्ता आंकड़े मिलना हैं या नही यह चुनिए';
$string['backuplogdetailed'] = 'विस्तृत कार्यान्वयन लोग';
$string['backuploglaststatus'] = 'पिछला कार्यान्वयन लोग';
$string['backupmissinguserinfoperms'] = 'टिप्पणी: इस बैकअप मे किसी उपयोगकर्ता का डेटा नहीं है| अभ्यास एवं कार्यशाला संबन्धित जानकारियाँ इस बैकअप  मे सम्मिलित / शामिल नहीं होंगी क्योंकि यह मॉड्यूल इस प्रकार के बैकअप के अनुकूल नहीं हैं |';
$string['backupnext'] = 'अगला बैकअप';
$string['backupnonisowarning'] = 'चेतावनी: यह बैकअप Moodle (पूर्व 1.6) के एक गैर-यूनिकोड संस्करण से है। यदि इस बैकअप में कोई भी गैर-आईएसओ-8859-1 पाठ शामिल हैं, तो यदि आप उन्हें मूड के इस यूनिकोड संस्करण में पुनर्स्थापित करने का प्रयास करते हैं, तो उन्हें सुधार दिया जा सकता है। इस बैकअप को सही तरीके से पुनर्प्राप्त करने के बारे में अधिक जानकारी के लिए <a href="https://docs.moodle.org/en/Backup_FAQ"> बैकअप FAQ </a> देखें।';
$string['backupnotyetrun'] = 'स्वचालित बैकअप लंबित';
$string['backuporiginalname'] = 'बैकअप का नाम';
$string['backuproleassignments'] = 'इन भूमिकाओ के लीके नियतन बैकअप भूमिका';
$string['backupsavetohelp'] = 'उस डायरेक्टरी का पूरा पत्ता जहां आप इन बैकअप फ़ाइलें को  रखना चाहते हैं |';
$string['backupsitefileshelp'] = 'अगर सक्षम है तो साइट पाठ्यक्रमों में प्रयुक्त फ़ाइलों स्वचालित बैकअप में शामिल किया जाएगा';
$string['backuptakealook'] = 'अपनी बैकअप लॉग्स पर नज़र डालें: {$a}';
$string['backupuserfileshelp'] = 'क्या यूज़र की फ़ाइलों (जैसे प्रोफ़ाइल तस्वीरों) को स्वचालित बैकअप में शामिल किया जाये?';
$string['backupversion'] = 'बैकअप का सन्सकरण';
$string['badges'] = 'पदक';
$string['block'] = 'ब्लॉक';
$string['blockconfiga'] = '{$a} ब्लॉक को कन्फ़िगर';
$string['blockconfigbad'] = 'सही तरीके से तैयार न किए जाने के कारण इस ब्लॉक का कन्फ़िगरशन इन्टर्फ़ेस उपलब्ध नहीं है।';
$string['blocks'] = 'ब्लॉक';
$string['blocksaddedit'] = 'ब्लॉक्स जोड़िए/सम्पादित कीजिए';
$string['blockseditoff'] = 'ब्लॉक्स सम्पादन ऑफ़';
$string['blocksediton'] = 'ब्लॉक्स सम्पादन ऑन';
$string['blocksetup'] = 'ब्लॉक टेबल्स सॅट किए जा रहें हैं';
$string['blocksuccess'] = '{$a} टेबल्स सही तरीके से सॅट कर दिए गए हैं';
$string['brief'] = 'संछिप्त ';
$string['bulkactions'] = 'थोक कार्रवाई';
$string['bulkactionselect'] = '{$a} थोक कार्रवाई चयन';
$string['bulkcancel'] = 'सामूहिक संपादन बंद करें';
$string['bulkmovecoursessuccess'] = 'सफलतापूर्वक {$a->courses} पाठ्यक्रम {$a->category} श्रेणी में स्थानांतरित किये गए';
$string['bulkselection'] = '{$a} चयनित';
$string['bycourseorder'] = 'कोर्स क्रम के अनुसार';
$string['byname'] = '{$a} के अनुसार';
$string['bypassed'] = 'दूसरा रास्ता दिया';
$string['cachecontrols'] = 'केश कंट्रोल्स';
$string['calltofeedback'] = 'इस सॉफ़्टवेयर के निर्माता आपकी प्रतिक्रिया चाहेंगे।';
$string['calltofeedback_give'] = 'इस सॉफ्टवेयर के बारे में प्रतिक्रिया दें';
$string['calltofeedback_remind'] = 'मुझे बाद में याद दिलाना';
$string['cancel'] = 'रद्द करें';
$string['cancelled'] = 'रद्द हुए';
$string['categories'] = 'पाठ्यक्रम वर्ग';
$string['categoriesandcourses'] = 'पाठ्यक्रम श्रेणियां और पाठ्यक्रम';
$string['category'] = 'समूह';
$string['categoryadded'] = '{$a} वर्ग जोड़ा गया';
$string['categorybulkaction'] = 'चयनित श्रेणियों के लिए थोक कार्रवाई';
$string['categorycontents'] = 'उपश्रेणियाँ एवं पाठ्यक्रम ';
$string['categorycurrentcontents'] = '{$a} की विषय वस्तु';
$string['categorydeleted'] = '{$a} वर्ग डिलीट किया गया';
$string['categoryduplicate'] = '{$a} नाम का वर्ग पहले से मौजूद है';
$string['categoryheader'] = 'मेनू श्रेणी';
$string['categoryhidden'] = '(छुपा)';
$string['categorymodifiedcancel'] = 'श्रेणी संशोधित किया गया था! रद्द करें और फिर कोशिश करें.';
$string['categoryname'] = 'वर्ग का नाम';
$string['categorypath'] = 'श्रेणी पथ';
$string['categorysubcategoryof'] = '{$a->category} - उपश्रेणी है {$a->parentcategory} की';
$string['categoryupdated'] = '\'{$a}\' समूह को अपडेट किया गया है।';
$string['changedpassword'] = 'बदला गया पासवर्ड';
$string['changepassword'] = 'पासवर्ड बदलिए';
$string['changesmade'] = 'परिवर्तन किए';
$string['changesmadereallygoaway'] = 'आपने परिवर्तन किया है. सुनिश्चित करें कि आप नेविगेट करना चाहते हैं? आप अपने परिवर्तन खो देंगे।';
$string['changessaved'] = 'परिवर्तन सेव हो गए हैं';
$string['check'] = 'जांचें';
$string['checkactual'] = 'वास्तविक';
$string['checkall'] = 'सभी को जांचे';
$string['checkerror'] = 'जाँच \'{$a}\' के परिणाम प्राप्त करने में त्रुटि। अधिक जानकारी के लिए ब्राउज़र कंसोल देखें।';
$string['checkexpected'] = 'अपेक्षित';
$string['checkingbackup'] = 'बैकप की जाँच की जा रही है';
$string['checkingcourse'] = 'कोर्स की जाँच की जा रही है';
$string['checkingforbbexport'] = 'BlackBoard एक्स्पोर्ट की जाँच की जा रही है';
$string['checkinginstances'] = 'instances की जाँच की जा रही है';
$string['checkingsections'] = 'सॅक्शन्स की जाँच की जा रही है';
$string['checklanguage'] = 'भाषा की जाँच की जा रही है';
$string['checkloading'] = 'जांच \'{$a}\' का परिणाम प्राप्त किया जा रहा है';
$string['checknone'] = 'कुछ भी न जाँच';
$string['checks'] = 'जाँच';
$string['checksok'] = 'सभी \'{$a}\' जाँचें ठीक है';
$string['childcoursenotfound'] = 'आश्रित पाठ्यक्रम नहीं पाया गया!';
$string['childcourses'] = 'आश्रित पाठ्यक्रम नहीं पाया गया ';
$string['choose'] = 'चुनिए';
$string['choosecourse'] = 'कोर्स चुनिए';
$string['choosedots'] = 'चुनें ...';
$string['chooselivelogs'] = 'या वर्तमान गतिविधि देखिए';
$string['chooselogs'] = 'चुनाव करें कि आप कौन-सी लॉग्स देखना चाहते हैं';
$string['choosereportfilter'] = 'रिपोर्ट के लिए एक फ़िल्टर का चुनाव करें';
$string['choosetheme'] = 'थीम चुनिए';
$string['chooseuser'] = 'यूज़र चुनिए';
$string['city'] = 'शहर/गाँव';
$string['cleaningtempdata'] = 'अस्थायी डेट साफ़ किया जा रहा है।';
$string['clear'] = 'स्पष्ट';
$string['clearfilterrow'] = 'फ़िल्टर पंक्ति हटाएं';
$string['clearfilters'] = 'फ़िल्टर साफ़ करें';
$string['clearsearch'] = 'खोज इनपुट हटाए';
$string['clickhelpiconformoreinfo'] = '... जारी है ... पूरा लेख पढ़ने के लिए मदद आइकन पर क्लिक करें ';
$string['clickhere'] = 'यहाँ क्लिक करें ...';
$string['clicktochangeinbrackets'] = '{$a} (बदलने के लिए क्लिक करें)';
$string['clicktohideshow'] = 'विस्तार या पतन के लिए क्लिक करें';
$string['closeblockdrawer'] = 'ब्लॉक दराज बंद करें';
$string['closebuttontitle'] = 'बंद करे';
$string['closecourseindex'] = 'कोर्स इंडेक्स बंद करें';
$string['closedrawer'] = 'दराज बंद करें';
$string['closewindow'] = 'इस विन्डो को बन्द कीजिए';
$string['collapse'] = 'संक्षिप्त करें';
$string['collapseall'] = 'सभी को संक्षिप्त करें';
$string['collapsecategory'] = 'संक्षिप्त करें {$a}';
$string['comebacklater'] = 'कृपया बाद में आइये।';
$string['commentincontext'] = 'इस संदर्भ में टिप्पणी का पता लगाएं';
$string['comments'] = 'टिप्पणियां';
$string['commentscount'] = 'टिप्पणियाँ ({$a})';
$string['commentsnotenabled'] = 'टिप्पणियां सुविधा सक्षम नहीं है';
$string['commentsrequirelogin'] = 'टिप्पणियों को देखने के लिए आपको लॉगिन की आवश्यकता है';
$string['comparelanguage'] = 'वर्तमान भाषा की तुलना व सम्पादन कीजिए';
$string['complete'] = 'पूर्ण';
$string['completed'] = 'पुरा होना';
$string['completereport'] = 'पूर्ण रिपोर्ट';
$string['configuration'] = 'कन्फ़िगरेशन';
$string['confirm'] = 'पुष्टि कीजिए';
$string['confirmaccount'] = 'खाते की पुष्टि करें';
$string['confirmcheckfull'] = 'क्या आपको बिल्कुल यकीन है कि आप {$} की पुष्टि करना चाहते हैं?';
$string['confirmcoursemove'] = 'आपको यकीन है कि आप इस पाठ्यक्रम  ({$a->course}) को ({$a->category}) श्रेणी में  स्थानांतरित करना चाहते हैं?';
$string['confirmdeletesection'] = 'आपको बिल्कुल यकीन है कि आप "{$a}" को और इसकी सभी गतिविधियों को पूरी तरह से हटाना चाहते हैं?';
$string['confirmed'] = 'आपके पंजीकरण की पुष्टि हो गई है';
$string['confirmednot'] = 'आपके पंजीकरण की पुष्टि अभी तक नहीं हुई है। कृपया पुष्टिकरण ईमेल के लिए अपने मेलबॉक्स की जाँच करें।';
$string['considereddigitalminor'] = 'इस साइट पर खाता बनाने के लिए आप बहुत छोटे हैं।';
$string['content'] = 'सामग्री';
$string['contentbank'] = 'सामग्री बैंक';
$string['contentexport_aboutthiscourse'] = 'कोर्स का सारांश';
$string['contentexport_coursesummary'] = 'यह फ़ाइल <a href="{$a->पाठ्यक्रमलिंक}">{$a->पाठ्यक्रमनाम}</a> से डाउनलोड की गई सामग्री का हिस्सा है।';
$string['contentexport_footersummary'] = 'यह फ़ाइल {$a->तारीख} को {$a->userfullname} द्वारा <a href="{$a->पाठ्यक्रमलिंक}">{$a->पाठ्यक्रमनाम}</a> से डाउनलोड की गई सामग्री का हिस्सा है .';
$string['contentexport_modulesummary'] = 'यह पेज <a href="{$a->modulelink}">{$a->modulename}</a> से {$a->date} को डाउनलोड की गई सामग्री का हिस्सा है। ध्यान दें कि कुछ सामग्री और {$a->maxfilesize} से बड़ी फ़ाइलें डाउनलोड नहीं की जाती हैं।';
$string['contentexport_viewfilename'] = 'फ़ाइल देखें {$a}';
$string['context'] = 'संदर्भ';
$string['contextlevel'] = 'संदर्भ स्तर';
$string['contextname'] = 'संदर्भ नाम';
$string['contextparent'] = 'मूल';
$string['contexturl'] = 'संदर्भ URL';
$string['continue'] = 'जारी रखें';
$string['continuetocourse'] = 'अपने कोर्स में प्रवेश पाने के लिए यहाँ क्लिक कीजिए';
$string['convertingwikitomarkdown'] = 'विकी को मार्कडाउन में परिवर्तित किया जा रहा है';
$string['cookiesenabled'] = 'आपके ब्राउज़र में कुकीज़ ऍनेबल्ड होनी चाहिए';
$string['cookiesenabled_help'] = 'इस साइट के द्वारा दो प्रकार की cookies प्रयोग की जाती है:

session cookie आवश्यक है, जिसे आमतौर पर MoodleSession कहा जाता है। आपको अपने ब्राउज़र में इस कुकी को अनुमति देनी चाहिए ताकि यह पृष्ठ से पृष्ठ निरंतरता प्रदान करे और आपका और प्रवेश बनाए रखे। जब आप लॉगआउट करते है या ब्राउज़र को बंद करते है यह कुकी स्वतः ही नष्ट हो जाती है (आपके ब्राउज़र पर भी तथा सर्वर पर भी)।

अन्य cookie मात्र आपकी सुविधा के लिए है, आम तौर पर ise MOODLEID कहा जाता है। यह सिर्फ ब्राउज़र के भीतर उपयोगकर्ता का नाम याद रखता है। इसका मतलब यह है कि जब आप इस साइट के लॉगिन पृष्ठ पर आते है तो उपयोगकर्ता नाम पहले से ही आप के लिए भरा जाएगा। इस कुकी को मना करना सुरक्षित है - बस उपयोगकर्ता को हर बार अपना username लिखना पड़ेगा।';
$string['cookiesenabled_help_html'] = 'इस साइट पर दो कुकीज़ का उपयोग किया जाता है:<br/><br/>

आवश्यक एक सत्र कुकी है, जिसे आमतौर पर मूडलसेशन कहा जाता है। आपको इस कुकी को अपने ब्राउज़र में निरंतरता प्रदान करने और साइट ब्राउज़ करते समय लॉग इन रहने की अनुमति देनी चाहिए। जब आप लॉग आउट या ब्राउज़र बंद करते हैं, तो यह कुकी नष्ट हो जाती है (आपके ब्राउज़र में और सर्वर पर)।<br/><br/>

अन्य कुकी विशुद्ध रूप से सुविधा के लिए होती है, जिसे आमतौर पर मूडलेड या समान कहा जाता है। यह ब्राउज़र में आपके उपयोगकर्ता नाम को याद रखता है। इसका अर्थ है कि जब आप इस साइट पर वापस आते हैं, तो लॉगिन पृष्ठ पर उपयोगकर्ता नाम फ़ील्ड आपके लिए पहले ही भर चुका होता है। इस कुकी को मना करना सुरक्षित है - जब भी आप लॉग इन करते हैं तो आपको बस अपना उपयोगकर्ता नाम फिर से टाइप करना होगा।';
$string['cookiesenabledonlysession'] = 'आपके ब्राउज़र में कुकीज़ ऍनेबल्ड होनी चाहिए';
$string['cookiesenabledonlysession_help'] = 'यह साइट एक सत्र कुकी का उपयोग करती है, जिसे आमतौर पर MoodleSession कहा जाता है। साइट को ब्राउज़ करते समय निरंतरता प्रदान करने और लॉग इन रहने के लिए आपको अपने ब्राउज़र में इस कुकी को अनुमति देनी चाहिए। जब आप ब्राउज़र को लॉग आउट या बंद करते हैं, तो यह कुकी नष्ट हो जाती है (आपके ब्राउज़र में और सर्वर पर)।';
$string['cookiesnotenabled'] = 'आपके ब्राउज़र में कुकीज़ ऍनेबल्ड नहीं हैं';
$string['cookiesnotice'] = 'कुकीज़ नोटिस';
$string['copy'] = 'कॉपी';
$string['copyasnoun'] = 'प्रतिलिपि बनाये';
$string['copycourse'] = 'पाठ्यक्रम की प्रतिलिपि बनाये';
$string['copyingcoursefiles'] = 'कोर्स फ़ाइल्स कॉपी की जा रहीं हैं';
$string['copyingsitefiles'] = 'साइट के पाठ्यक्रम में इस्तेमाल फ़ाइलों की प्रतिलिपि बनाई जा रही';
$string['copyinguserfiles'] = 'यूज़र फ़ाइल्स कॉपी की जा रहीं हैं';
$string['copyingzipfile'] = 'ज़िप फ़ाइल कॉपी की जा रही है';
$string['copyrightnotice'] = 'कॉपीराइट सूचना';
$string['copytoclipboard'] = 'क्लिपबोर्ड पर कॉपी करें';
$string['coresystem'] = 'प्रणाली';
$string['cost'] = 'खर्च';
$string['costdefault'] = 'डिफ़ॉल्ट खर्च';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'देश';
$string['course'] = 'कोर्स';
$string['courseadministration'] = 'कोर्स प्रशासन';
$string['courseapprovedemail'] = 'आपके द्वारा अनुरोधित पाठ्यक्रम {$a ->name}, अनुमोदित किया गया गया है और आपको एक {$a->teacher} बनाया गया है. अपने नए पाठ्यक्रम का उपयोग करने के लिए, कृपया यहाँ जाए  {$a->url}';
$string['courseapprovedemail2'] = 'आपके द्वारा अनुरोधित पाठ्यक्रम {$a ->name}, अनुमोदित किया गया गया है. अपने नए पाठ्यक्रम का उपयोग करने के लिए, कृपया यहाँ जाए  {$a->url}';
$string['courseapprovedfailed'] = 'अनुमोदित पाठ्यक्रम सहेजने में विफल!';
$string['courseapprovedsubject'] = 'आपके पाठ्यक्रम को मंजूरी दे दी गई है!';
$string['courseavailable'] = 'यह कोर्स विद्यार्थियों के लिए उपलब्ध है';
$string['courseavailablenot'] = 'यह कोर्स विद्यार्थियों के लिए उपलब्ध नहीं है';
$string['coursebackup'] = 'कोर्स बैकप';
$string['coursebulkaction'] = 'चयनित पाठ्यक्रम के लिए थोक कार्रवाई';
$string['coursecategories'] = 'कोर्स वर्ग';
$string['coursecategory'] = 'कोर्स वर्ग';
$string['coursecategory_help'] = 'यह सेटिंग निर्धारित करता है कि यह पाठ्यक्रम, पाठ्यक्रमो की  सूचि के किस श्रेणि में दिखाई देगा  ';
$string['coursecategorydeleted'] = '{$a} कोर्स श्रेणी हटाए';
$string['coursecatmanagement'] = 'पाठ्यक्रम और श्रेणी प्रबंधन';
$string['coursecompletion'] = 'पाठ्यक्रम पूर्णता';
$string['coursecompletions'] = 'पाठ्यक्रम पूर्णता';
$string['coursecreators'] = 'पाठ्यक्रम निर्माता';
$string['coursecreatorsdescription'] = 'कोर्स निर्माता नए पाठ्यक्रम बना सकते हैं.';
$string['coursedeleted'] = '{$a} पाठ्यक्रम हटाए';
$string['coursedetails'] = 'पाठ्यक्रम विवरण';
$string['coursedisplay'] = 'कोर्स लेआउट';
$string['coursedisplay_help'] = 'यह सेटिंग निर्धारित करती है को पूरे पाठ्यकम को एक ही पृष्ठ पर प्रदर्शित करे या कई पृष्ठों पर विभाजित किया जाये।';
$string['coursedisplay_multi'] = 'प्रति पृष्ठ एक अनुभाग दिखाएँ';
$string['coursedisplay_single'] = 'एक पृष्ठ पर सभी वर्गों को दिखाएं';
$string['courseduration'] = 'पाठ्यक्रम की अवधि';
$string['courseduration_desc'] = 'पाठ्यक्रम की अवधि पाठ्यक्रम की अंतिम तिथि की गणना करने के लिए प्रयोग कि जाती है। पाठ्यक्रम की अंतिम तिथि आमतौर पर रिपोर्ट के लिए प्रयोग कि जाती है। उपयोगकर्ता पाठ्यक्रम की अवधि की समाप्ति के पश्चात भी पाठ्यक्रम में प्रवेश कर सकते हैं।';
$string['courseenddateenabled'] = 'कोर्स समाप्ति कि तिथि स्वयं ही सक्रिय है';
$string['courseenddateenabled_desc'] = 'यह सेटिंग निर्धारित करती है कि कोर्स समाप्ति तिथि नए कोर्सों के लिए स्वयं ही सक्रिय हो जाएगी और कोर्स की अवधि के अनुसार निर्धारित हो जाएगी';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'पुरानी  कोर्स फ़ाइलें';
$string['coursefilesedit'] = 'विरासत पाठ्यक्रम दस्तावेजो को संपादित करे';
$string['coursefileswarning'] = 'पाठ्यक्रम फाइल्स को पदावनत किया गया है';
$string['coursefileswarning_help'] = 'कोर्स फ़ाइलों को Moodle 2.0 के बाद से पदावनत कर रहे हैं, जितना संभव हो बाहरी संग्रह का इस्तेमाल करें।';
$string['courseformatdata'] = 'कोर्स के प्रारूप की जानकारी';
$string['courseformatoptions'] = '{$a} के लिए स्वरूपण विकल्प';
$string['courseformats'] = 'कोर्स फ़ॉर्मेट्स';
$string['courseformatudpate'] = 'अद्यतन प्रारूप';
$string['coursegrades'] = 'कोर्स ग्रेड्स';
$string['courseheader'] = 'पाठ्यक्रम मेनू';
$string['coursehelpcategory'] = 'कोर्स को कोर्स सूची में अंकित करें और इसे छात्रों के खोजने के लिए आसान बनाएं';
$string['coursehelpforce'] = 'कोर्स की प्रत्येक गतिविधि पर कोर्स समूह प्रणाली लागू करें';
$string['coursehelpformat'] = 'कोर्स मुख्य पेज इस प्रारूप में प्रदर्शित किया जाएगा';
$string['coursehelphiddensections'] = 'कोर्स में छिपे हुए भागों को छात्रों को कैसे दिखाया जाता है';
$string['coursehelpmaximumupload'] = 'साइट द्वारा सीमित, अपलोड की जा सकने वाली कोर्स में सबसे बड़ी फाइल के साइज को परिभाषित करें';
$string['coursehelpnewsitemsnumber'] = 'कोर्स पृष्ठ पर हाल ही में हुए घोषणाओ की संख्या जो ब्लॉक में दिखेगी। अगर शून्य सेट है तो घोषणाएं मंच नहीं बनाया जाएगा';
$string['coursehelpnumberweeks'] = 'पाठ्यक्रम में वर्गों की संख्या (केवल कुछ पाठ्यक्रम प्रारूपों पर लागू होता है)।';
$string['coursehelpshowgrades'] = 'ग्रेडबुक के प्रदर्शन को सक्रिय करें। यह ग्रेड को व्यक्तिगत गतिविधियों में प्रदर्शित होने से नहीं रोकता है।';
$string['coursehidden'] = 'इस समय यह कोर्स विद्यार्थियों के लिए उपलब्ध नहीं है';
$string['courseinfo'] = 'कोर्स जानकारी';
$string['courselegacyfiles'] = 'अप्रचलित/पैतृक पाठ्यक्रम फ़ाइलें';
$string['courselegacyfiles_help'] = 'पाठ्यक्रम फ़ाइलों का क्षेत्र Moodle 1.9 और पहले के साथ कुछ पिछड़े संगतता प्रदान करता है। इस क्षेत्र की सभी फाइलें पाठ्यक्रम में सभी प्रतिभागियों के लिए हमेशा सुलभ होती हैं (आप उन्हें लिंक करते हैं या नहीं) और यह जानने का कोई तरीका नहीं है कि इनमें से किसी भी फाइल का उपयोग मूडल में कहां किया जा रहा है।

यदि आप पाठ्यक्रम फ़ाइलों को संग्रहीत करने के लिए इस क्षेत्र का उपयोग करते हैं, तो आप अपने आप को कई गोपनीयता और सुरक्षा मुद्दों के साथ-साथ बैकअप, पाठ्यक्रम आयात और किसी भी समय सामग्री साझा करने या फिर से उपयोग किए जाने में लापता फ़ाइलों का अनुभव कर सकते हैं। इसलिए यह अनुशंसा की जाती है कि आप इस क्षेत्र का उपयोग न करें जब तक कि आप वास्तव में नहीं जानते कि आप क्या कर रहे हैं।';
$string['courselegacyfiles_link'] = 'coursefiles2';
$string['courselegacyfilesofcourse'] = 'अप्रचलित/पैतृक पाठ्यक्रम फ़ाइलें : {$a}';
$string['coursenotaccessible'] = 'यह पाठ्यक्रम सार्वजनिक उपयोग की अनुमति नहीं देता';
$string['courseoverview'] = 'कोर्स अवलोकन';
$string['courseoverviewfiles'] = 'कोर्स की छवि';
$string['courseoverviewfiles_help'] = 'कोर्स की छवि डैशबोर्ड पर पाठ्यक्रम के अवलोकन में प्रदर्शित होती है। साइट व्यवस्थापक द्वारा अतिरिक्त स्वीकृत फ़ाइल प्रकार और एक से अधिक फ़ाइल सक्षम की जा सकती हैं। यदि हां, तो इन फ़ाइलों को पाठ्यक्रम पृष्ठ की सूची में पाठ्यक्रम सारांश के बगल में प्रदर्शित किया जाएगा।';
$string['courseoverviewfilesext'] = 'कोर्स छवि फ़ाइल एक्सटेंशन';
$string['courseoverviewfileslimit'] = 'कोर्स छवि फाइलों की सीमा';
$string['courseoverviewgraph'] = 'कोर्स अवलोकन ग्राफ';
$string['courseprofiles'] = 'कोर्स रेखा-चित्र';
$string['coursereasonforrejecting'] = 'इस निवेदन को खारिज करने के लिए आपके कारण';
$string['coursereasonforrejectingemail'] = 'यह निवेदक को ईमेल कर दिया जाएगा';
$string['coursereject'] = 'एक कोर्स निवेदन को अस्वीकृत करें';
$string['courserejected'] = 'कोर्स को अस्वीकृत कर दिया गया है एवं निवेदक को सूचित कर दिया गया है';
$string['courserejectemail'] = 'क्षमा करें, लेकिन आपके द्वारा अनुरोधित पाठ्यक्रम को अस्वीकार कर दिया गया है। कारण यहां दिए गए हैं:

{$a}';
$string['courserejectreason'] = 'इस पाठ्यक्रम को खारिज करने के लिए अपने कारणों की लिखे <br /> (यह कारण अनुरोधकर्ता को ईमेल किया जाएगा)';
$string['courserejectsubject'] = 'आपका कोर्स अस्वीकृत कर दिया गया है';
$string['coursereport'] = 'पाठ्यक्रम विवरण';
$string['coursereports'] = 'पाठ्यक्रम विवरण';
$string['courserequest'] = 'कोर्स निवेदन';
$string['courserequestdetails'] = 'जिस पाठ्यक्रम का आप अनुरोध कर रहे हैं उसका विवरण';
$string['courserequestfailed'] = 'किसी कारण से, आपका कोर्स अनुरोध सहेजा नहीं जा सका';
$string['courserequestintro'] = 'अपने लिए बनाये जाने वाले पाठ्यक्रम का अनुरोध करने के लिए करें इस फ़ॉर्म का उपयोग करे । <br /> प्रशाशक को समझने के लिए अधिक से अधिक जानकारी भरें, ताकि यह पाठ्यक्रम आपको प्राप्त हो सके.';
$string['courserequestreason'] = 'इस पाठ्यक्रम के इच्छुक होने के कारण';
$string['courserequestsuccess'] = 'आपका कोर्स अनुरोध सफलतापूर्वक सहेजा गया है. आपको यह सूचित करने के लिए एक ईमेल भेजा जाएगा कि आपका अनुरोध मंजूर है या नहीं।';
$string['courserequestsupport'] = 'व्यवस्थापक द्वारा इस अनुरोध का मूल्यांकन करने में मदद करने के लिए सहायक सूचना';
$string['courserequestwarning'] = 'इस कोर्स का अनुरोध करने वाले उपयोगकर्ता को स्वचालित रूप से नामांकित किया जाएगा और {$a} की भूमिका निर्धारित की जाएगी।';
$string['courserestore'] = 'पाठ्यक्रम पुनःस्थापना';
$string['coursereuse'] = 'कोर्स का पुन: उपयोग';
$string['courses'] = 'पाठ्यक्रम';
$string['coursesearch'] = 'पाठ्यक्रम खोजे';
$string['coursesearch_help'] = '<p> आप एक साथ कई शब्दों को खोज सकते हैं और अपनी खोज को इस प्रकार परिष्कृत कर सकते हैं: </p>
<ul>
<li> शब्द - पाठ के भीतर इस शब्द का कोई भी मिलान खोजें। </li>
<li> + शब्द - केवल सटीक मिलान वाले शब्द मिलेंगे। </li>
<li> -word - इस शब्द वाले परिणामों को शामिल न करें। </li>
</ul>';
$string['coursesectionsummaries'] = 'पाठ्यक्रम अनुभाग सारांश';
$string['coursesectiontitle'] = 'पाठ्यक्रम: {$a->course}, {$a->sectionname}: {$a->sectiontitle}';
$string['coursesettings'] = 'पाठ्यक्रम न्यूनतम सेटिंग्स';
$string['coursesmovedout'] = 'पाठ्यक्रम {$a} से निकाले';
$string['coursespending'] = 'अनुमोदन लंबित पाठ्यक्रम';
$string['coursestart'] = 'पाठ्यक्रम शुरू';
$string['coursesummary'] = 'पाठ्यक्रम सारांश';
$string['coursesummary_help'] = 'पाठ्यक्रम सारांश पाठ्यक्रमों की सूची में प्रदर्शित किया जाता है। पाठ्यक्रम खोज के दौरान पाठ्यक्रम के नाम के अलावा पाठ्यक्रम सारांश को भी खोजा जाता है ।';
$string['coursetitle'] = 'पाठ्यक्रम: {$a->course}';
$string['courseupdates'] = 'पाठ्यक्रम अप्डेट्स';
$string['coursevisibility'] = 'पाठ्यक्रम दृश्यता';
$string['coursevisibility_help'] = 'यह सेटिंग यह निर्धारित करती है कि कोर्स पाठ्यक्रमों की सूची में दिखाई देता है या नहीं और क्या छात्र इसे एक्सेस कर सकते हैं। यदि छुपाया जाता है, तो छुपी पाठ्यक्रम (जैसे शिक्षक) देखने की क्षमता वाले उपयोगकर्ताओं के लिए एक्सेस प्रतिबंधित है।';
$string['create'] = 'बनाइए';
$string['createaccount'] = 'मेरा नया खाता बनाइए';
$string['createcategory'] = 'श्रेणी बनाएँ';
$string['createfolder'] = '{$a} में एक फ़ोल्डर बनाइए';
$string['createnew'] = 'नया बनाये';
$string['createnewcategory'] = 'नई श्रेणी बनाएं';
$string['createnewcourse'] = 'नया पाठ्यक्रम बनाएं';
$string['createnewsubcategory'] = 'नयी उपश्रेणी बनाएँ';
$string['createsubcategoryof'] = '{$a} की नयी उपश्रेणी बनाएँ';
$string['createuser'] = 'उपयोगकर्ता बनाएँ';
$string['createziparchive'] = 'ज़िप फ़ाइल बनाइए';
$string['creatingblocks'] = 'ब्लॉक्स बनाए जा रहें हैं';
$string['creatingblocksroles'] = 'ब्लॉक स्तर भूमिका बनायीं जा रही है';
$string['creatingblogsinfo'] = 'ब्लॉग जानकारी बनायीं जा रही है';
$string['creatingcategoriesandquestions'] = 'वर्ग व प्रश्न बनाए जा रहें हैं';
$string['creatingcoursemodules'] = 'कोर्स मॉड्यूल्स बनाए जा रहें हैं';
$string['creatingcourseroles'] = 'पाठ्यक्रम स्तर भूमिका बनायीं जा रही है';
$string['creatingevents'] = 'ईवॅन्ट्स बनाए जा रहें हैं';
$string['creatinggradebook'] = 'ग्रेड्बुक बनाई जा रही है';
$string['creatinggroupings'] = 'समूहों का समूह बनाया जा रहा है';
$string['creatinggroupingsgroups'] = 'समूहों को समूह में जोड़ रहे है';
$string['creatinggroups'] = 'ग्रुप बनाए जा रहें हैं';
$string['creatinglogentries'] = 'लॉग तैयार की जा रही है';
$string['creatingmessagesinfo'] = 'सन्देश जानकारी तैयार की जा रही है';
$string['creatingmodroles'] = 'उपयोगकर्ता स्तर की भूमिका असाइनमेंट और ओवरराइड बना रहे है';
$string['creatingnewcourse'] = 'नया कोर्स बनाया जा रहा है';
$string['creatingrolesdefinitions'] = 'भूमिका की परिभाषाएं बना रहे है';
$string['creatingscales'] = 'स्केल्स बनाए जा रहें हैं';
$string['creatingsections'] = 'सॅक्शन्स बनाए जा रहें हैं';
$string['creatingtemporarystructures'] = 'अस्थायी संरचनाएँ तैयार की जा रही हैं';
$string['creatinguserroles'] = 'उपयोगकर्ता स्तर की भूमिका असाइनमेंट और ओवरराइड बना रहे है';
$string['creatingusers'] = 'यूज़र्स बनाए जा रहें हैं';
$string['creatingxmlfile'] = 'XML फ़ाइल बनाई जा रही है';
$string['currency'] = 'मुद्रा';
$string['currentcourse'] = 'वर्तमान पाठ्यक्रम';
$string['currentcourseadding'] = 'वर्तमान कोर्स में डेटा जोड़ा जा रहा है';
$string['currentcoursedeleting'] = 'पहले वर्तमान कोर्स को डिलीट किया जा रहा है';
$string['currentlanguage'] = 'वर्तमान भाषा';
$string['currentlocaltime'] = 'आपका वर्तमान स्थानीय समय';
$string['currentpicture'] = 'वर्तमान चित्र';
$string['currentrelease'] = 'वर्तमान रिलीज़ जानकारी';
$string['currentversion'] = 'वर्तमान version';
$string['databasechecking'] = 'मूडल डेटाबेस को version {$a->oldversion} से
{$a->newversion} तक अपग्रेड किया जा रहा है';
$string['databaseperformance'] = 'डेटाबेस प्रदर्शन';
$string['databasesetup'] = 'डेटाबेस सॅट अप किया जा रहा है';
$string['databasesuccess'] = 'डेटाबेस सफलतापूर्वक अपग्रेड किया गया';
$string['databaseupgradebackups'] = 'बैकप version इस समय {$a} है';
$string['databaseupgradeblocks'] = 'ब्लॉक्स version इस समय {$a} है';
$string['databaseupgradegroups'] = 'समूह संस्करण अब {$a} है';
$string['databaseupgradelocal'] = 'स्थानीय डेटाबेस अनुकूलन संस्करण अब {$a} है';
$string['databaseupgrades'] = 'डेटाबेस अपग्रेड किया जा रहा है';
$string['dataformats'] = 'डेटा प्रारूप';
$string['date'] = 'तारीख';
$string['datechanged'] = 'तिथि बदल दी';
$string['datemostrecentfirst'] = 'तारीख - हाल की तरीख पहले';
$string['datemostrecentlast'] = 'तारीख - हाल की तरीख अन्त में';
$string['day'] = 'दिन';
$string['days'] = 'दिन';
$string['decodinginternallinks'] = 'आन्तरिक लिंक्स को डिकोड किया जा रहा है';
$string['default'] = 'डिफ़ॉल्ट';
$string['defaultcategoryname'] = 'श्रेणी 1';
$string['defaultcompetencescale'] = 'डिफ़ॉल्ट क्षमता पैमाना';
$string['defaultcompetencescaledesc'] = 'एक बाइनरी रेटिंग स्केल जो इससे ज्यादा जानकारी प्रदान नहीं करता की किसी ने प्रवीणता का प्रदर्शन किया है या नहीं।';
$string['defaultcompetencescalenotproficient'] = 'अभी तक सक्षम नहीं है';
$string['defaultcompetencescaleproficient'] = 'सक्षम';
$string['defaultcoursestudent'] = 'विद्यार्थी';
$string['defaultcoursestudentdescription'] = 'छात्रों के पाठ्यक्रम में आमतौर पर कम विशेषाधिकार होते हैं।';
$string['defaultcoursestudents'] = 'विद्यार्थी';
$string['defaultcoursesummary'] = 'कुछ सन्क्षिप्त व दिलचस्प वाक्यों में इस कोर्स का वर्णन कीजिए';
$string['defaultcourseteacher'] = 'टीचर';
$string['defaultcourseteacherdescription'] = 'शिक्षकों को गतिविधियों और ग्रेडिंग छात्रों को बदलने सहित, पाठ्यक्रम के भीतर कुछ भी कर सकते हैं।';
$string['defaultcourseteachers'] = 'टीचर्स';
$string['defaulteditor'] = 'डिफ़ॉल्ट संपादक';
$string['defaulthomepageuser'] = 'मुख पृष्ठ';
$string['defaulthomepageuser_help'] = 'आपका मुख पृष्ठ नेविगेशन में पहला लिंक है।';
$string['delete'] = 'डिलीट';
$string['deleteablock'] = 'एक ब्लॉक हटाएं';
$string['deleteall'] = 'सभी को डिलीट कीजिए';
$string['deleteallcannotundo'] = 'सभी हटाएं - पूर्ववत नहीं किया जा सकता है';
$string['deleteallcomments'] = 'सभी चर्चा को डिलीट कीजिए';
$string['deleteallratings'] = 'सभी रेटिंग को डिलीट कीजिए';
$string['deletecategory'] = 'श्रेणी हटाएं: {$a}';
$string['deletecategorycheck'] = 'क्या आप वास्तव में <strong>\'{$a}\'</strong> वर्ग को पूरी
तरह से डिलीट करना चाहते हैं>?<br />ऐसा करने से सभी कोर्स इस वर्ग के मातृ-वर्ग (अगर है तो) या विविध वर्ग में डाल दिए जाएंगे।';
$string['deletecategorycheck2'] = 'यदि आप इस श्रेणी को हटाते हैं, तो आपको यह चुनने की ज़रूरत है कि इसमें शामिल पाठ्यक्रमों और उपश्रेणियों के साथ क्या करना है।';
$string['deletecategoryempty'] = 'यह श्रेणी खाली है';
$string['deletecheck'] = '{$a} को डिलीट कर दिया जाये?';
$string['deletecheckfiles'] = 'क्या आप वास्तव में इन फ़ाइलों को डिलीट करना चाहते हैं?';
$string['deletecheckfull'] = 'क्या आप वास्तव में {$a} उपयोगकर्ता को उनके नामांकन, गतिविधि और अन्य विवरण सहित पूरी तरह से हटाना चाहते हैं?';
$string['deletechecktype'] = 'क्या आप वाकई इस {$a->type} को मिटाना चाहते हैं?';
$string['deletechecktypename'] = 'क्या आप वाकई {$a->type} "{$a->name}" को मिटाना चाहते हैं?';
$string['deletecheckwarning'] = 'आप इन फ़ाइलों को डिलीट करने जा रहें हैं';
$string['deletecommentbyon'] = '{$a->time} पर {$a->user} द्वारा पोस्ट की गई टिप्पणी हटाएं';
$string['deletecompletely'] = 'पूरी तरह से डिलीट कर दीजिए';
$string['deletecourse'] = 'कोर्स डिलीट कीजिए';
$string['deletecoursecheck'] = 'क्या आप वास्तव में इस कोर्स और इसके सारे डेटा को डिलीट
करना चाहते हैं?';
$string['deleted'] = 'डिलीट कर दिया गया';
$string['deletedactivity'] = '{$a} डिलीट कर दिया गया';
$string['deletedcourse'] = '{$a} डिलीट पूरी तरह से डिलीट कर दिया गया';
$string['deletednot'] = '{$a} को डिलीट नहीं किया जा सका';
$string['deletepicture'] = 'डिलीट';
$string['deletesection'] = 'खंड हटाएं';
$string['deleteselected'] = 'चुने हुए को डिलीट कीजिए';
$string['deleteselectedkey'] = 'चयनित कुंजी हटाएं';
$string['deletingcourse'] = '{$a} को डिलीट किया जा रहा है';
$string['deletingexistingcoursedata'] = 'मौजूद कोर्स डेटा को डिलीट किया जा रहा है';
$string['deletingolddata'] = 'पुराने डेटा को डिलीट किया जा रहा है';
$string['department'] = 'विभाग';
$string['deprecatedeventname'] = '{$a} (अब उपयोग में नहीं है)';
$string['desc'] = 'अवरोही';
$string['description'] = 'विवरण';
$string['deselectall'] = 'सभ को न-चुने';
$string['deselectnos'] = 'सभी \'नहीं\' का चयन रद्द करें';
$string['detailedless'] = 'कम विवरण';
$string['detailedmore'] = 'ज्यादा विवरण';
$string['details'] = 'विवरण';
$string['digitalminor'] = 'डिजिटल नाबालिग';
$string['digitalminor_desc'] = 'इस साइट पर खाता बनाने के लिए कृपया अपने माता-पिता / अभिभावक को निम्नलिखित व्यक्ति से संपर्क करें।';
$string['directory'] = 'निर्देशिका';
$string['disable'] = 'अक्षम करें';
$string['disabledcomments'] = 'टिप्पणियाँ अक्षम हैं';
$string['dismissnotification'] = 'इस सूचना को खारिज करें';
$string['displayingfirst'] = 'केवल पहले {$a->count} {$a->things} को दिखाया जा
रहा है';
$string['displayingrecords'] = '{$a} रिकॉर्ड दिखाए जा रहे हैं';
$string['displayingusers'] = '{$a->start} से {$a->end} के यूज़र्स दिखाए जा रहे हैं';
$string['displayonpage'] = 'पेज पर प्रदर्श करें';
$string['dndcourse'] = 'आप इस सॉर्टिंग को बदलने या इसे किसी अन्य श्रेणी में ले जाने के लिए इस कोर्स को खींच और छोड़ सकते हैं।';
$string['dndenabled_inbox'] = 'आप यहां फ़ाइलों को जोड़ने के लिए खींच और छोड़ सकते हैं।';
$string['dndnotsupported'] = 'खींचें और छोड़ें सुविधा उपलब्ध नहीं है';
$string['dndnotsupported_help'] = 'आपका ब्राउज़र ड्रैग और ड्रॉप अपलोड का समर्थन नहीं करता है। <br /> यह सुविधा क्रोम, फ़ायरफ़ॉक्स और सफारी के सभी हाल के संस्करणों के साथ-साथ इंटरनेट एक्सप्लोरर v10 और ऊपर के संस्करणों में भी उपलब्ध है।';
$string['dndnotsupported_insentence'] = 'ड्रैग और ड्रॉप समर्थित नहीं है';
$string['dnduploadwithoutcontent'] = 'इस अपलोड में कोई सामग्री नहीं है';
$string['dndworkingfile'] = 'उन्हें अपलोड करने के लिए फ़ाइलों को पाठ्यक्रम अनुभागों पर खींचें और छोड़ें';
$string['dndworkingfilelink'] = 'उन्हें अपलोड करने के लिए पाठ्यक्रम अनुभागों पर फ़ाइलों या लिंक खींचें और छोड़ें';
$string['dndworkingfiletext'] = 'उन्हें अपलोड करने के लिए पाठ्यक्रम अनुभागों पर फ़ाइलों या टेक्स्ट को खींचें और छोड़ें';
$string['dndworkingfiletextlink'] = 'उन्हें अपलोड करने के लिए पाठ्यक्रम अनुभागों पर फ़ाइलों, टेक्स्ट या लिंक खींचें और छोड़ें';
$string['dndworkinglink'] = 'उन्हें अपलोड करने के लिए पाठ्यक्रम अनुभागों पर लिंक खींचें और छोड़ें';
$string['dndworkingtext'] = 'इसे अपलोड करने के लिए पाठ्यक्रम अनुभागों पर टेक्स्ट खींचें और छोड़ें';
$string['dndworkingtextlink'] = 'उन्हें अपलोड करने के लिए पाठ्यक्रम अनुभागों पर टेक्स्ट या लिंक खींचें और छोड़ें';
$string['documentation'] = 'MOODLE प्रलेखन';
$string['dontsortcategories'] = 'श्रेणियों को सॉर्ट न करें';
$string['dontsortcourses'] = 'पाठ्यक्रमों को सॉर्ट न करें';
$string['down'] = 'नीचे';
$string['download'] = 'डाउनलोड';
$string['downloadall'] = 'सभी डाउनलोड';
$string['downloadexcel'] = 'ऍक्सॅल फ़ॉर्मैट में डाउन्लोड कीजिए';
$string['downloadfile'] = 'डाउनलोड फाइल';
$string['downloadods'] = 'ODS फॉर्मॅट में डाउनलोड करें';
$string['downloadtext'] = 'टेक्स्ट फ़ॉर्मैट में डाउन्लोड कीजिए';
$string['doyouagree'] = 'क्या आपने इन शर्तों को पढ़कर समझ लिया है?';
$string['droptoupload'] = 'अपलोड करने के लिए फ़ाइलें यहाँ डालें';
$string['duplicate'] = 'अनुलिपि';
$string['duplicatedmodule'] = '{$a} प्रति';
$string['duplicatedsection'] = '{$a} (की प्रतिलिपि)';
$string['edhelpaspellpath'] = 'ऍडिटर में स्पॅल-चॅकिंग (वर्तनी की जाँच) के लिए आपके सर्वर पर <strong>aspell 0.50</strong> या अधिक इन्स्टॉल
होना चाहिए। आपको aspell का सही पाथ देना पड़ेगा। यूनिक्स/लिनिक्स (Unix/Linux) में यह पाथ सामन्यत: <strong>/usr/bin/aspell</strong> होता है, परन्तु
कुछ और भी हो सकता है।';
$string['edhelpbgcolor'] = 'ऍडिटर का बैक्ग्राउन्ड कलर सॅट कीजिए। उदाहरण के लिए: #FFFFFF or white';
$string['edhelpcleanword'] = 'यह सॅटिन्ग वर्ड फ़ॉर्मट फ़िल्टरिंग को ऍनेबल या डिसेबल करती है।';
$string['edhelpenablespelling'] = 'स्पॅल-चॅकिंग (वर्तनी की जाँच) को ऍनेबल या डिसेबल करिए। ऍनेबल करने पर आपके सर्वर पर <strong>aspell .50</strong> या अधिक इन्स्टॉल होना चाहिए। दूसरी वैल्यू है: <strong>डिफ़ॉल्ट डिक्शनरी (शब्दकोश)</strong>। इसका प्रयोग तब होगा जब aspell के पास यूज़र की भाषा के लिए शब्दकोश नहीं होगा।';
$string['edhelpfontfamily'] = 'font-family प्रॉपर्टी फ़ॉन्ट फ़ैमिली नामों और/या सामान्य
फ़ैमिली नामों की सूची है। फ़ैमिली नामों के बीच
में अल्पविराम (",") होना चाहिए।';
$string['edhelpfontlist'] = 'ऍडिटर के ड्रॉपडाउन मेन्यू में प्रयुक्त फ़ॉन्ट्स परिभाषित कीजिए।';
$string['edhelpfontsize'] = 'डिफ़ॉल्ट फ़ॉन्ट-साइज़ फ़ॉन्ट का आकार सॅट करता है।<br/> उदहारण के लिए: medium, large, smaller, larger, 10pt, 11px।';
$string['edit'] = ' का सम्पादन कीजिए';
$string['edita'] = '{$a} का सम्पादन कीजिए';
$string['editcategorysettings'] = 'प्रवर्ग सेट्टिंग्स को संपादन करें';
$string['editcategorythis'] = 'इस प्रवर्ग को संपादन करें';
$string['editcoursesettings'] = 'कोर्स सॅटिन्ग सम्पादन';
$string['editfiles'] = 'फ़ाइलों का सम्पादन कीजिए';
$string['editgroupprofile'] = 'ग्रुप प्रोफ़ाइल का सम्पादन कीजिए';
$string['editinga'] = '{$a} का सम्पादन किया जा रहा
है';
$string['editingteachershort'] = 'ऍडिटर';
$string['editlock'] = 'इस वैल्यू का सम्पादन नहीं किया जा सकता है';
$string['editmode'] = 'संपादन मोड';
$string['editmyprofile'] = 'विवरण सम्पादन';
$string['editorbgcolor'] = 'बैक्ग्राउन्ड-कलर';
$string['editorcleanonpaste'] = 'पेस्ट करने पर वर्ड HTML को साफ़ कर दीजिए';
$string['editorcommonsettings'] = 'सर्वसामान्य सॅटिंग्स';
$string['editordefaultfont'] = 'डिफ़ॉल्ट फ़ॉन्ट';
$string['editorenablespelling'] = 'स्पॅल-चॅकिंग को ऍनेबल कीजिए';
$string['editorfontlist'] = 'फ़ॉन्ट सूची';
$string['editorfontsize'] = 'डिफ़ॉल्ट फ़ॉन्ट-साइज़ (आकार)';
$string['editorpreferences'] = 'संपादक प्राथमिकताएं';
$string['editorresettodefaults'] = 'डिफ़ॉल्ट वैल्यूज़ पर रीसॅट कीजिए';
$string['editorsettings'] = 'ऍडिटर सॅटिंग्स';
$string['editorshortcutkeys'] = 'संपादक शॉर्टकट कुंजी';
$string['editsection'] = 'अनुभाग का संपादन';
$string['editsectionname'] = 'अनुभाग का नाम संपादित करें';
$string['editsettings'] = 'सेटिंग्स बदलें';
$string['editsummary'] = 'सम्पादन सारान्श';
$string['editthisactivity'] = 'इस गतिविधि का सम्पादन कीजिए';
$string['editthiscategory'] = 'इस वर्ग का सम्पादन कीजिए';
$string['edittitle'] = 'शीर्षक संपादित करें';
$string['edittitleinstructions'] = 'रद्द करने के लिए बहार निकले, समाप्त होने पर प्रवेश करें';
$string['edituser'] = 'यूज़र ऍकाउन्ट सम्पादन';
$string['edulevel'] = 'सभी कार्यक्रम';
$string['edulevel_help'] = '* शिक्षण - एक शिक्षक द्वारा किए गए कार्यों, उदा। संसाधन अपडेट करना
* भाग लेना - एक छात्र द्वारा किए गए कार्यों, उदा। एक मंच में पोस्टिंग
* अन्य - शिक्षक या छात्र के अलावा किसी अन्य भूमिका के साथ उपयोगकर्ता द्वारा किए गए कार्यों';
$string['edulevelother'] = 'अन्य';
$string['edulevelparticipating'] = 'इसमें भाग लेने वाले';
$string['edulevelteacher'] = 'शिक्षण';
$string['email'] = 'ई-मेल पता';
$string['emailactive'] = 'ई-मेल सक्रिय कर दिया';
$string['emailagain'] = 'ई-मेल (दोबारा)';
$string['emailalreadysent'] = 'पासवर्ड रीसेट ईमेल पहले से ही भेज दिया गया है। कृपया अपनी ईमेल देखें।';
$string['emailcharset'] = 'ईमेल वर्णमाला';
$string['emailconfirm'] = 'अपने ऍकाउन्ट की पुष्टि करें';
$string['emailconfirmation'] = 'नमस्ते,

हमारी साइट  \'{$a->sitename}\'  पर आपके ई-मेल का प्रयोग कर
के एक नए ऍकाउन्ट क अनुरोध किया गया है।

अपने ऍकाउन्ट की पुष्टि करने के लिये यहाँ जायें:

{$a->link}

अधिकान्श मेल प्रोग्राम इसे एक नीली लिंक के रूप में दिखाएंगे, जिस
पर आप क्लिक कर सकते हैं। अगर यह काम नहीं करता है, तो इस लिंक को कट करके अपने ब्राउज़र की ऎड्रॅस बार में पेस्ट कीजिए।

अगर आपको सहायता की आवश्यकता है, तो कृपया ऍड्मिन से सम्पर्क
कीजिए,
{$a->admin}';
$string['emailconfirmationresend'] = 'पुष्टिकरण ईमेल पुन: भेजें';
$string['emailconfirmationsubject'] = '{$a}: ऐकाउन्ट की पुष्टि';
$string['emailconfirmsent'] = '<p> आपके पते <b> {$a} </ b> </p> पर एक ईमेल भेजा जाना चाहिए था
<p> इसमें आपके पंजीकरण को पूरा करने के लिए आसान निर्देश हैं। </ p>
<p> यदि आपको कुछ कठिनाई हो रही है, तो साइट व्यवस्थापक से संपर्क करें। </ p>';
$string['emailconfirmsentfailure'] = 'पुष्टिकरण ईमेल भेजने में विफल';
$string['emailconfirmsentsuccess'] = 'पुष्टिकरण ईमेल सफलतापूर्वक भेजा गया';
$string['emaildigest'] = 'ई-मेल डाइजेस्ट का प्रकार';
$string['emaildigest_help'] = 'यह दैनिक डाइजेस्ट सेटिंग है कि फ़ोरम डिफ़ॉल्ट रूप से उपयोग करेंगे।

* कोई पाचन नहीं - आपको प्रति फोरम पोस्ट पर एक ई-मेल प्राप्त होगा;
* डाइजेस्ट - पूर्ण पोस्ट - आपको प्रति दिन एक पाचन ई-मेल प्राप्त होगा जिसमें प्रत्येक फोरम पोस्ट की पूरी सामग्री होगी;
* डाइजेस्ट - केवल विषय - आपको प्रति दिन एक पाचन ई-मेल प्राप्त होगा जिसमें प्रत्येक फोरम पोस्ट का विषय होगा।

यदि आप चाहें तो प्रत्येक फोरम के लिए आप एक अलग सेटिंग भी चुन सकते हैं।';
$string['emaildigestcomplete'] = 'पूर्ण (पूर्ण पदों के साथ दैनिक ईमेल)';
$string['emaildigestoff'] = 'कोई पाचन नहीं (फोरम पोस्ट प्रति एकल ईमेल)';
$string['emaildigestsubjects'] = 'विषय (केवल विषयों के साथ दैनिक ईमेल)';
$string['emaildisable'] = 'इस ई-मेल पते को डिसेबल किया गया है';
$string['emaildisableclick'] = 'इस पते पर भेजे जाने से सभी ईमेल अक्षम करने के लिए यहां क्लिक करें';
$string['emaildisplay'] = 'ईमेल प्रदर्शन';
$string['emaildisplay_help'] = 'विशेषाधिकृत उपयोगकर्ता (जैसे शिक्षक और प्रबंधक) हमेशा आपका ईमेल पता देख पाएंगे।';
$string['emaildisplaycourse'] = 'केवल अन्य पाठ्यक्रम सदस्यों को अपना ईमेल पता देखने की अनुमति दें';
$string['emaildisplaycoursemembersonly'] = '(अन्य पाठ्यक्रम प्रतिभागियों के लिए दृश्यमान)';
$string['emaildisplayeveryone'] = '(सभी के लिए दृश्यमान)';
$string['emaildisplayhide'] = '(सभी गैर-विशेषाधिकार प्राप्त उपयोगकर्ताओं से छिपा हुआ)';
$string['emaildisplayno'] = 'गैर-विशेषाधिकार प्राप्त उपयोगकर्ताओं से मेरा ईमेल छुपाएं';
$string['emaildisplayyes'] = 'सभी को अपना ईमेल देखने की अनुमति दें';
$string['emailenable'] = 'यह ईमेल सक्षम है';
$string['emailenableclick'] = 'इस पते पर भेजे जा रहे सभी ईमेल को फिर से सक्षम करने के लिए यहां क्लिक करें';
$string['emailexists'] = 'यह ईमेल पता पहले से पंजीकृत है।';
$string['emailexistshintlink'] = 'भूल गए उपयोगकर्ता नाम या पासवर्ड को पुनर्प्राप्त करें';
$string['emailexistssignuphint'] = 'शायद आपने अतीत में एक खाता बनाया है? {$a}';
$string['emailformat'] = 'ई-मेल फ़ॉर्मेट';
$string['emailmustbereal'] = 'नोट: आपका ईमेल वास्तविक होना चाहिए';
$string['emailnotallowed'] = 'इन डोमेन में ईमेल की अनुमति नहीं है ({$a})';
$string['emailnotfound'] = 'ईमेल डेटाबेस में नहीं मिला था';
$string['emailonlyallowed'] = 'यह ईमेल उन लोगों में से एक नहीं है जिन्हें अनुमति है ({$a})';
$string['emailpasswordchangeinfo'] = 'नमस्कार {$a->firstname},

किसी ने (शायद आप) ने आपके खाते \'{$a->username}\' के लिए एक नया पासवर्ड अनुरोध किया है
\'{$a->sitename}\' पर ।

अपना पासवर्ड बदलने के लिए, कृपया निम्नलिखित वेब पते पर जाएं:

{$a->link}

अधिकांश मेल प्रोग्राम में, यह एक नीले लिंक के रूप में दिखाई देना चाहिए
जिसे आप बस क्लिक कर सकते हैं। अगर यह काम नहीं करता है तो
फिर पते को कॉपी कर अपनी वेब ब्राउज़र विंडो के शीर्ष लाइन पर पेस्ट करे ।

अगर आपको मदद की ज़रूरत है, तो कृपया साइट व्यवस्थापक से संपर्क करें,
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'नमस्कार {$a->firstname},

किसी ने (शायद आपने) \'{$a->sitename}\' पर अपने खाते के लिए एक नया पासवर्ड अनुरोध किया है।

दुर्भाग्य से इस साइट पर आपका खाता अक्षम कर दिया गया है, इसलिए पासवर्ड रीसेट नहीं किया जा सकता है।

कृपया साइट व्यवस्थापक {$a->admin} से संपर्क करें।';
$string['emailpasswordchangeinfofail'] = 'नमस्कार {$a->firstname},

किसी ने (शायद आपने) \'{$a->sitename}\' पर अपने खाते के लिए एक नया पासवर्ड अनुरोध किया है।

दुर्भाग्य से पासवर्ड इस साइट पर रीसेट नहीं किया जा सकता है।

कृपया साइट व्यवस्थापक {$a->admin} से संपर्क करें।';
$string['emailpasswordchangeinfosubject'] = '{$a}: पासवर्ड की जानकारी बदलें';
$string['emailpasswordconfirmation'] = 'नमस्ते {$a->firstname}!,

किसी ने (शायद आपने स्वयं) \'{$a->sitename}\' पर आपके एकाउन्ट के लिये नये पास्वर्ड की मांग की है।

इसकी पुष्टि करने के लिये और ई-मेल द्वारा एक नया पास्वर्ड प्राप्त करने के लिए यहां जायें

{$a->link}


अधिकांश मेल प्रोग्राम में, यह नीले लिंक के रूप में दिखाई देना चाहिए जिस पर आप क्लिक कर सकते हैं। अगर वह काम नहीं करता है, तो यहाँ से वेब एड्रेस को कट करके अपने वेब ब्राउज़र के शीर्ष पर एड्रेस बॉक्स में पेस्ट करें।

यदि आपको सहायता चाहिए, तो कृपया साइट व्यवस्थापक से संपर्क करें,
{$a->व्यवस्थापक}';
$string['emailpasswordconfirmationsubject'] = '{$a}: पासवर्ड पुष्टिकरण बदलें';
$string['emailpasswordconfirmmaybesent'] = '<p> यदि आपने सही उपयोगकर्ता नाम या ईमेल पता प्रदान किया है तो एक ईमेल आपको भेजा जाना चाहिए था। </p>
<p> इसमें इस पासवर्ड परिवर्तन की पुष्टि करने और पूरा करने के लिए आसान निर्देश शामिल हैं।
यदि आपको कठिनाई जारी है, तो कृपया साइट व्यवस्थापक से संपर्क करें। </p>';
$string['emailpasswordconfirmnoemail'] = '<p>आपके द्वारा निर्दिष्ट उपयोगकर्ता खाते में एक दर्ज ईमेल पता नहीं है। </p>
<p>कृपया साइट व्यवस्थापक से संपर्क करें। </p>';
$string['emailpasswordconfirmnotsent'] = '<p> आपके द्वारा दिया गया उपयोगकर्ता विवरण किसी मौजूदा उपयोगकर्ता खाते की पहचान नहीं करता है। </p>
   <p> कृपया आपके द्वारा दर्ज की गई जानकारी की जाँच करें, फिर पुनः प्रयास करें।
यदि आपको कठिनाई हो रही है, तो कृपया साइट व्यवस्थापक से संपर्क करें। </p>';
$string['emailpasswordconfirmsent'] = 'आपके <b>{$a}</b> पते पर एक ईमेल भेजा गया हैं।
<br /> इसमें पासवर्ड परिवर्तन की पुष्टि करने और उसे पूरा करने के लिए आसान निर्देश हैं।
यदि आपको कठिनाई हो रही है, तो साइट व्यवस्थापक से संपर्क करें।';
$string['emailpasswordsent'] = 'पासवर्ड बदलने की पुष्टि करने के लिए धन्यवाद।
आपको नया पासवर्ड आपके ईमेल <b>{$a->email}</b> पर भेज दिया गया है।<br /><br />
नया पासवर्ड स्वचालित रूप से जेनरेट किया गया था - आप इसे कुछ आसान करने के लिए <a href="{$a->link}">यहाँ जाये </a>।';
$string['emailresetconfirmation'] = 'हाय {$a-> firstname},

आपके खाते के {{$a-> उपयोगकर्ता नाम} के लिए {$a->sitename} पर पासवर्ड रीसेट का अनुरोध किया गया था।

इस अनुरोध की पुष्टि करने के लिए, और कृपया अपने खाते के लिए एक नया पासवर्ड सेट करें
निम्नलिखित वेब पते पर जाएं:

{$a->link}
(यह लिंक उस समय से {$a-> resetminutes} मिनटों के लिए वैध है, जब यह रीसेट पहली बार अनुरोध किया गया था)

यदि यह पासवर्ड रीसेट आपके द्वारा अनुरोध नहीं किया गया था, तो कोई कार्रवाई की आवश्यकता नहीं है।

यदि आपको सहायता चाहिए, तो कृपया साइट व्यवस्थापक से संपर्क करें,
{$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: पासवर्ड रीसेट अनुरोध';
$string['emailresetconfirmsent'] = 'आपके <b>{$a}</b> पते पर एक ईमेल भेजा गया हैं।
<br /> इसमें पासवर्ड परिवर्तन की पुष्टि करने और उसे पूरा करने के लिए आसान निर्देश हैं।
यदि आपको कठिनाई हो रही है, तो साइट व्यवस्थापक से संपर्क करें।';
$string['emailstop'] = 'नोटीफिकेशन निष्क्रिय करे';
$string['emailtoprivatefiles'] = 'आप सीधे अपनी निजी फाइलों के स्थान पर संलग्नक के रूप में फ़ाइलों को ई-मेल भी कर सकते हैं। बस अपनी फाइलें ई-मेल से संलग्न करें और इसे {$a} पर भेजें';
$string['emailtoprivatefilesdenied'] = 'आपके व्यवस्थापक ने आपकी निजी फाइलें अपलोड करने का विकल्प अक्षम कर दिया है।';
$string['emailvia'] = '{$a->name} ({$a->siteshortname} के माध्यम से)';
$string['emojicategoryactivities'] = 'गतिविधिया';
$string['emojicategoryanimalsnature'] = 'पशु और प्रकृति';
$string['emojicategoryflags'] = 'झंडे';
$string['emojicategoryfooddrink'] = 'खाद्य एवं पेय';
$string['emojicategoryobjects'] = 'वस्तुये';
$string['emojicategorypeoplebody'] = 'लोग और शरीर';
$string['emojicategoryrecent'] = 'ताज़ा';
$string['emojicategorysmileysemotion'] = 'स्माइलीज और इमोशन';
$string['emojicategorysymbols'] = 'प्रतीक';
$string['emojicategorytravelplaces'] = 'यात्रा और स्थान';
$string['emptycmids'] = 'खाली पाठ्यक्रम मॉड्यूल आईडी';
$string['emptydragdropregion'] = 'खाली क्षेत्र';
$string['emptysectionids'] = 'खाली अनुभाग आईडी';
$string['enable'] = 'समर्थ करें';
$string['encryptedcode'] = 'एनसयरपटेड कोड';
$string['enddate'] = 'पाठ्यक्रम की समाप्ति तिथि';
$string['enddate_help'] = 'पाठ्यक्रम की समाप्ति तिथि का उपयोग यह निर्धारित करने के लिए किया जाता है कि पाठ्यक्रम की किसी उपयोगकर्ता की पाठ्यक्रम में पाठ्यक्रम शामिल किया जाना चाहिए या नहीं। जब समाप्ति तिथि अतीत हो जाती है, तो पाठ्यक्रम अब नेविगेशन में सूचीबद्ध नहीं है और पाठ्यक्रम के अवलोकन में अतीत के रूप में सूचीबद्ध है। पाठ्यक्रम की समाप्ति तिथि का उपयोग कस्टम रिपोर्ट द्वारा भी किया जा सकता है। उपयोगकर्ता अभी भी अंतिम तिथि के बाद पाठ्यक्रम में प्रवेश कर सकते हैं; दूसरे शब्दों में दिनांक पहुंच प्रतिबंधित नहीं करता है।';
$string['english'] = 'अंग्रेज़ी';
$string['enrolmentmethods'] = 'नामांकन विधियां';
$string['entercourse'] = 'इस कोर्स में प्रवेश करने के लिए क्लिक करें';
$string['enteremail'] = 'अपना ईमेल दर्ज करें';
$string['enteremailaddress'] = 'अपना पासवर्ड रीसेट करने के लिए अपना ईमेल दर्ज करें
और ईमेल के माध्यम से आपको नया पासवर्ड भेजा गया है।';
$string['enterusername'] = 'अपना username दर्ज करें';
$string['entries'] = 'प्रवेशे';
$string['error'] = 'गलती';
$string['errorcreatingactivity'] = 'गतिविधि \'{$a}\' का उदाहरण बनाने में असमर्थ';
$string['errorfiletoobig'] = 'फ़ाइल {$a} बाइट्स की सीमा से बड़ी थी';
$string['errornouploadrepo'] = 'इस साइट के लिए कोई अपलोड रिपॉजिटरी सक्षम नहीं है';
$string['errorwhenconfirming'] = 'आप अभी तक पुष्टि नहीं कर रहे हैं क्योंकि एक त्रुटि हुई। यदि आपने यहां आने के लिए किसी ईमेल में किसी लिंक पर क्लिक किया है, तो सुनिश्चित करें कि आपके ईमेल की रेखा टूटी या लपेटी नहीं गई थी। आपको लिंक को सही तरीके से पुनर्निर्माण के लिए कट और पेस्ट का उपयोग करना पड़ सकता है।';
$string['eventcommentcreated'] = 'टिप्पणी बनाई गई';
$string['eventcommentdeleted'] = 'टिप्पणी हटा दी गई';
$string['eventcommentsviewed'] = 'टिप्पणियां देखी गईं';
$string['eventconfiglogcreated'] = 'कॉन्फ़िगर लॉग बनाया गया';
$string['eventcontentviewed'] = 'सामग्री देखी गई';
$string['eventcoursebackupcreated'] = 'कोर्स बैकअप बनाया गया';
$string['eventcoursecategorycreated'] = 'श्रेणी बनाई गई';
$string['eventcoursecategorydeleted'] = 'श्रेणी हटा दी गई';
$string['eventcoursecategoryupdated'] = 'श्रेणी अद्यतन';
$string['eventcoursecategoryviewed'] = 'श्रेणी देखी गई';
$string['eventcoursecontentdeleted'] = 'कोर्स सामग्री हटा दी गई';
$string['eventcoursecreated'] = 'पाठ्यक्रम बनाया गया';
$string['eventcoursedeleted'] = 'पाठ्यक्रम हटा दिया गया';
$string['eventcourseinformationviewed'] = 'कोर्स सारांश देखा गया';
$string['eventcoursemodulecreated'] = 'कोर्स मॉड्यूल बनाया गया';
$string['eventcoursemoduledeleted'] = 'कोर्स मॉड्यूल हटा दिया गया';
$string['eventcoursemoduleinstancelistviewed'] = 'कोर्स मॉड्यूल इंस्टेंस सूची देखी गई';
$string['eventcoursemoduleupdated'] = 'पाठ्यक्रम मॉड्यूल अद्यतन';
$string['eventcoursemoduleviewed'] = 'पाठ्यक्रम मॉड्यूल देखा';
$string['eventcourseresetended'] = 'पाठ्यक्रम रीसेट प्रक्रिया समाप्त हो गयी';
$string['eventcourseresetstarted'] = 'पाठ्यक्रम रीसेट प्रक्रिया शुरू हो गयी';
$string['eventcourserestored'] = 'पाठ्यक्रम बहाल';
$string['eventcoursesectioncreated'] = 'पाठ्यक्रम खंड बनाया गया';
$string['eventcoursesectiondeleted'] = 'कोर्स अनुभाग हटा दिया गया';
$string['eventcoursesectionupdated'] = 'पाठ्यक्रम खंड अद्यतन';
$string['eventcoursessearched'] = 'पाठ्यक्रम खोजे गए';
$string['eventcourseupdated'] = 'कोर्स अपडेट किया गया';
$string['eventcourseuserreportviewed'] = 'कोर्स उपयोगकर्ता रिपोर्ट देखी गई';
$string['eventcourseviewed'] = 'पाठ्यक्रम देखा गया';
$string['eventdashboardreset'] = 'डैशबोर्ड रीसेट';
$string['eventdashboardsreset'] = 'डैशबोर्ड रीसेट';
$string['eventdashboardviewed'] = 'डैशबोर्ड देखा गया';
$string['eventdatabasetextfieldcontentreplaced'] = 'डेटाबेस वैश्विक खोज और प्रतिस्थापित';
$string['eventemailfailed'] = 'ईमेल भेजने में विफल रहा';
$string['eventmycoursesviewed'] = 'मेरे पाठ्यक्रम देखे गए';
$string['eventname'] = 'कार्यक्रम नाम';
$string['eventrecentactivityviewed'] = 'हाल की गतिविधि देखी गई';
$string['eventsearchindexed'] = 'खोजे हुए डेटा को अनुक्रमित किया';
$string['eventsearchresultsviewed'] = 'खोजे हुए डेटा को देखा';
$string['eventunknownlogged'] = 'अज्ञात घटना';
$string['eventusercreated'] = 'उपयोगकर्ता बनाया गया';
$string['eventuserdeleted'] = 'उपयोगकर्ता हटा दिया गया';
$string['eventuserfeedbackgiven'] = 'प्रतिक्रिया लिंक पर क्लिक किया';
$string['eventuserfeedbackremind'] = 'बाद में प्रतिक्रिया लिंक पर क्लिक करके मुझे याद दिलाएं';
$string['eventuserinfocategorycreated'] = 'उपयोगकर्ता प्रोफाइल फ़ील्ड श्रेणी बनाई गई';
$string['eventuserinfocategorydeleted'] = 'उपयोगकर्ता प्रोफ़ाइल फ़ील्ड श्रेणी हटा दी गई';
$string['eventuserinfocategoryupdated'] = 'उपयोगकर्ता प्रोफ़ाइल फ़ील्ड श्रेणी अद्यतन';
$string['eventuserinfofieldcreated'] = 'उपयोगकर्ता प्रोफाइल फ़ील्ड बनाया गया';
$string['eventuserinfofielddeleted'] = 'उपयोगकर्ता प्रोफ़ाइल फ़ील्ड हटा दिया गया';
$string['eventuserinfofieldupdated'] = 'उपयोगकर्ता प्रोफाइल फ़ील्ड अपडेट किया गया';
$string['eventuserlistviewed'] = 'उपयोगकर्ता सूची देखी गई';
$string['eventuserloggedout'] = 'उपयोगकर्ता लॉग आउट हो गए';
$string['eventuserpasswordpolicyfailed'] = 'उपयोगकर्ता का पासवर्ड विफल पासवर्ड नीति';
$string['eventuserpasswordupdated'] = 'उपयोगकर्ता पासवर्ड अपडेट किया गया';
$string['eventuserprofileviewed'] = 'उपयोगकर्ता प्रोफ़ाइल देखा गया';
$string['eventuserupdated'] = 'उपयोगकर्ता अद्यतन';
$string['everybody'] = 'सभी';
$string['executeat'] = 'को हस्ताक्षर करें';
$string['existing'] = 'विद्यमान';
$string['existingadmins'] = 'विद्यमान ऍड्मिन्स';
$string['existingcourse'] = 'विद्यमान कोर्स';
$string['existingcourseadding'] = 'विद्यमान कोर्स, दाता मिलाया जा रहा हैं';
$string['existingcoursedeleting'] = 'विद्यमान कोर्स, उसे पहले निकाला जा रहा हैं';
$string['existingcreators'] = 'विद्यमान कोर्स क्रियेटर';
$string['existingstudents'] = 'विद्यार्थी जीने प्रवेश मिला हैं';
$string['existingteachers'] = 'विद्यमान अध्यापक';
$string['expand'] = 'विस्तार';
$string['expandall'] = 'सभी का विस्तार करें';
$string['expandcategory'] = '{$a} विस्तृत करें';
$string['explanation'] = 'अर्थ';
$string['explanationdigitalminor'] = 'यह जानकारी यह निर्धारित करने के लिए आवश्यक है कि आपकी उम्र सहमति की डिजिटल आयु से अधिक है या नहीं। यह वह उम्र है जब कोई व्यक्ति नियम और शर्तों और उनके डेटा को कानूनी रूप से संग्रहीत और संसाधित करने के लिए सहमति दे सकता है।';
$string['extendperiod'] = 'विस्तारित अवधि';
$string['extendsession'] = 'सत्र का विस्तार करें';
$string['failedloginattempts'] = 'आपके अंतिम लॉगिन के बाद {$a_attempts} विफल लॉगिन';
$string['favourites'] = 'तारांकित';
$string['feedback'] = 'प्रतिपुष्टि';
$string['file'] = 'फ़ाइल';
$string['fileexists'] = '{$a} नामक एक फ़ाइल पहले से ही है';
$string['filemissing'] = '{$a} गायब हैं';
$string['filereaderror'] = 'फ़ाइल \'{$a}\' पढ़ने में असमर्थ। कृपया जांचें कि यह वास्तव में एक फ़ाइल है, न कि फ़ोल्डर।';
$string['files'] = 'फ़ाइलें';
$string['filesanduploads'] = 'फ़ाइलें और अपलोड';
$string['filesfolders'] = 'फ़ाइलें/फ़ोल्डर्स';
$string['fileuploadwithcontent'] = 'फ़ाइल अपलोड में सामग्री पैरामीटर शामिल नहीं होना चाहिए';
$string['filloutallfields'] = 'कृपया इस फॉर्म में सभी फ़ील्ड भरें';
$string['filter'] = 'फ़िल्टर';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filterrowlegend'] = 'फ़िल्टर {$a}';
$string['filters'] = 'फिल्टर';
$string['filtersetmatchdescription'] = 'कैसे विभिन्न फ़िल्टर संजोयित होने चाहिए';
$string['filtertype'] = 'फ़िल्टर के प्रकार';
$string['findmorecourses'] = 'और पाठ्यक्रम खोजें ...';
$string['first'] = 'प्रथम';
$string['firstaccess'] = 'प्रथम पहुंच';
$string['firstname'] = 'प्रथम नाम';
$string['firstnamephonetic'] = 'पहला नाम - फोनेटिक';
$string['firstpage'] = 'प्रथम पृष्ठ';
$string['firstsiteaccess'] = 'साइट पर पहली बार पहुंच';
$string['firsttime'] = 'क्या आप यहाँ पहली बार आयें हैं?';
$string['folder'] = 'फोल्डर';
$string['folderclosed'] = 'बंद फोल्डर';
$string['folderopened'] = 'खुला फोल्डर';
$string['followingoptional'] = 'निम्नलिखित आइटम वैकल्पिक हैं';
$string['followingrequired'] = 'निम्नलिखित मदों की आवश्यकता है';
$string['for'] = 'के लिये';
$string['force'] = 'जोर करें';
$string['forcelanguage'] = 'भाषा प्रबंध करें';
$string['forceno'] = 'जोर न करें';
$string['forcepasswordchange'] = 'जबरदस्ती पासवर्ड बदलें';
$string['forcepasswordchange_help'] = 'यदि यह चेकबॉक्स टिक किया जाता है, तो उपयोगकर्ता को अपने अगले लॉगिन पर अपना पासवर्ड बदलने के लिए प्रेरित किया जाएगा';
$string['forcepasswordchangecheckfull'] = 'क्या आप पूरी तरह से सुनिश्चित हैं कि आप {$a} को पासवर्ड परिवर्तन को मजबूर करना चाहते हैं?';
$string['forcepasswordchangenot'] = 'पासवर्ड परिवर्तन को {$ a} के लिए बाध्य नहीं किया जा सकता';
$string['forcepasswordchangenotice'] = 'आगे बढ़ने के लिए आपको अपना पासवर्ड बदलना होगा।';
$string['forcepasswordresetfailurenotice'] = 'आपका वर्तमान पासवर्ड अब सेट पासवर्ड नीति को पारित नहीं करता है। कृपया सहायता के लिए अपने Moodle व्यवस्थापक से संपर्क करें।
   {$a}';
$string['forcepasswordresetnotice'] = 'आपका वर्तमान पासवर्ड अब सेट पासवर्ड नीति को पारित नहीं करता है, आपको लॉगिन करने के लिए अपना पासवर्ड रीसेट करना होगा।
   {$a}';
$string['forcetheme'] = 'Force theme';
$string['forgotaccount'] = 'पासवर्ड खो गया?';
$string['forgotten'] = 'क्या आप अपना यूज़रनेम या पासवर्ड भूल गये हैं?';
$string['forgottenduplicate'] = 'ईमेल पता कई खातों द्वारा साझा किया गया है, कृपया इसके बजाय उपयोगकर्ता नाम दर्ज करें';
$string['forgotteninvalidurl'] = 'अमान्य पासवर्ड रीसेट URL';
$string['format'] = 'फ़ॉर्मैट';
$string['format_help'] = 'पाठ्यक्रम प्रारूप पाठ्यक्रम पृष्ठ के लेआउट को निर्धारित करता है।

* एकल गतिविधि प्रारूप - पाठ्यक्रम पृष्ठ पर एकल गतिविधि या संसाधन (जैसे क्विज़ या SCORM पैकेज) को प्रदर्शित करने के लिए
* सामाजिक प्रारूप - पाठ्यक्रम पृष्ठ पर एक मंच प्रदर्शित किया जाता है
* विषय प्रारूप - पाठ्यक्रम पृष्ठ विषय वर्गों में आयोजित किया जाता है
* साप्ताहिक प्रारूप - पाठ्यक्रम पृष्ठ साप्ताहिक अनुभागों में व्यवस्थित किया जाता है, जिसमें पहला सप्ताह पाठ्यक्रम शुरू होने की तारीख से शुरू होता है';
$string['formathtml'] = 'HTML फ़ॉर्मैट';
$string['formatmarkdown'] = 'Markdown फ़ॉर्मैट';
$string['formatplain'] = 'Plain text फ़ॉर्मैट';
$string['formattext'] = 'मूडल ऑटो-फ़ॉर्मेट';
$string['forumpreferences'] = 'मंच की प्राथमिकताएँ';
$string['framesetinfo'] = 'इस फ़्रेमसेट दस्तावेज़ में शामिल हैं:';
$string['from'] = 'से';
$string['fromdate'] = 'से';
$string['fromsender'] = 'से';
$string['frontpagecategorycombo'] = 'कॉम्बो सूची';
$string['frontpagecategorynames'] = 'श्रेणियों की सूची';
$string['frontpagecourselist'] = 'पाठ्यक्रमों की सूची';
$string['frontpagecoursesearch'] = 'पाठ्यक्रम खोज बॉक्स';
$string['frontpagedescription'] = 'फ्रंट पेज सारांश';
$string['frontpagedescriptionhelp'] = 'इस सारांश को पाठ्यक्रम / साइट सारांश ब्लॉक का उपयोग करके मुख्य पृष्ठ पर प्रदर्शित किया जा सकता है।';
$string['frontpageenrolledcourselist'] = 'पाठ्यक्रमों में दाखिला लिया';
$string['frontpageformat'] = 'सामने पृष्ठ स्वरूप';
$string['frontpageformatloggedin'] = 'लॉग इन करते समय फ्रंट पेज फॉर्मेट';
$string['frontpagenews'] = 'घोषणाएँ';
$string['frontpagesettings'] = 'सामने पृष्ठ सेटिंग्स';
$string['fulllistofcourses'] = 'सभी कोर्सस';
$string['fullname'] = 'पूरा नाम';
$string['fullnamecourse'] = 'पूरा नाम';
$string['fullnamecourse_help'] = 'पाठ्यक्रम का पूरा नाम पाठ्यक्रम में और पाठ्यक्रमों की सूची में प्रत्येक पृष्ठ के शीर्ष पर प्रदर्शित होता है।';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'पूरा नाम';
$string['fullprofile'] = 'पूरा प्रोफाइल';
$string['fullsitename'] = 'साईट का पूरा नाम';
$string['functiondisabled'] = 'वह कार्यक्षमता वर्तमान में अक्षम है';
$string['general'] = 'सामान्य';
$string['geolocation'] = 'अक्षांश देशांतर';
$string['gettheselogs'] = 'यह लोग्स लायें';
$string['go'] = 'जायें';
$string['gpl'] = 'कॉपीराइट (C) 1999 के बाद मार्टिन डगियमस (https://moodle.com)

यह कार्यक्रम मुफ्त सॉफ्टवेयर है; आप इसे फ्री सॉफ्टवेयर फाउंडेशन द्वारा प्रकाशित GNU जनरल पब्लिक लाइसेंस की शर्तों के तहत पुनर्वितरित कर सकते हैं और / या संशोधित कर सकते हैं; या तो लाइसेंस के संस्करण 2, या (आपके विकल्प पर) किसी भी बाद के संस्करण।

यह कार्यक्रम इस उम्मीद में वितरित किया जाता है कि यह उपयोगी होगा, लेकिन किसी भी वारंटी के बिना; बिना किसी पक्षपात के लिए योग्यता या योग्यता के निहित वारंटी के बिना भी।

पूर्ण विवरण के लिए Moodle लाइसेंस जानकारी पृष्ठ देखें: https://docs.moodle.org/dev/License';
$string['gpl3'] = 'कॉपीराइट (C) 1999 के बाद मार्टिन डगियमस (http://moodle.com)

यह कार्यक्रम मुफ्त सॉफ्टवेयर है: आप इसे पुनर्वितरित कर सकते हैं और / या संशोधित कर सकते हैं
यह GNU जनरल पब्लिक लाइसेंस की शर्तों के तहत प्रकाशित होता है
मुफ्त सॉफ्टवेयर फाउंडेशन, या तो लाइसेंस के संस्करण 3, या
(अपने विकल्प पर) किसी भी बाद के संस्करण।

यह कार्यक्रम इस आशा में वितरित किया जाता है कि यह उपयोगी होगा,
लेकिन किसी भी वारंटी के बिना; बिना निहित वारंटी के भी
किसी विशेष उद्देश्य के लिए अनुरूपता या फिटनेस।

पूर्ण विवरण के लिए Moodle लाइसेंस जानकारी पृष्ठ देखें:
http://docs.moodle.org/dev/License';
$string['gpllicense'] = 'GPL लाइसेंस';
$string['gradenoun'] = 'ग्रेड';
$string['grades'] = 'ग्रेड्स';
$string['gradeverb'] = 'ग्रेड';
$string['gravatarenabled'] = 'इस साइट के लिए <a href="http://www.gravatar.com/"> Gravatar </a> सक्षम किया गया है। यदि आप प्रोफ़ाइल चित्र अपलोड नहीं करते हैं तो Moodle आपके लिए ग्रेवटर से प्रोफ़ाइल चित्र लोड करने का प्रयास करेगा।';
$string['group'] = 'ग्रूप';
$string['groupadd'] = 'नया ग्रूप मिलायें';
$string['groupaddusers'] = 'समूह में चयनित जोड़ें';
$string['groupfor'] = 'ग्रूप के लिए';
$string['groupinfo'] = 'चयनित समूह के बारे में जानकारी';
$string['groupinfoedit'] = 'समूह सेटिंग्स संपादित करें';
$string['groupinfomembers'] = 'चयनित सदस्यों के बारे में जानकारी';
$string['groupinfopeople'] = 'चयनित लोगों के बारे में जानकारी';
$string['groupmembers'] = 'ग्रूप मेंबर्ज़';
$string['groupmemberssee'] = 'समूह के सदस्यों को देखें';
$string['groupmembersselected'] = 'चयनित समूह के सदस्य';
$string['groupmode'] = 'ग्रूप मोड';
$string['groupmodeforce'] = 'समूह प्रणाली सख्त करे';
$string['groupmy'] = 'मेरा ग्रूप';
$string['groupnonmembers'] = 'लोग जो एक समूह में नहीं हैं';
$string['groupnotamember'] = 'क्षमा करें, आप उस समूह के सदस्य नहीं हैं';
$string['grouprandomassign'] = 'यादृच्छिक रूप से सभी समूहों को असाइन करें';
$string['groupremove'] = 'चयनित समूह हटाए';
$string['groupremovemembers'] = 'चयनित सदस्यों को हटा दें';
$string['groups'] = 'समूह';
$string['groupsnone'] = 'कोई ग्रूप नही';
$string['groupsseparate'] = 'पृथक समूह';
$string['groupsvisible'] = 'दृष्टिगोचर समूह';
$string['guest'] = 'अतिथि';
$string['guestdescription'] = 'Guests के पास न्यूनतम विशेषाधिकार होते हैं और आमतौर पर कहीं भी टेक्स्ट दर्ज नहीं कर सकते हैं';
$string['guestskey'] = 'उन Guests को अनुमति दें जिनके पास कुंजी है';
$string['guestsno'] = 'मेहमानों को अनुमति न दें';
$string['guestsnotallowed'] = 'क्षमा करें, \'{$a}\' मेहमानों को प्रवेश करने की अनुमति नहीं देता है।';
$string['guestsyes'] = 'कुंजी के बिना मेहमानों को अनुमति दें';
$string['guestuser'] = 'अतिथि उपयेागकर्ता';
$string['guestuserinfo'] = 'यह उपयोगकर्ता एक विशेष उपयोगकर्ता है जो कुछ पाठ्यक्रमों तक केवल पढ़ने के लिए उपयोग की अनुमति देता है।';
$string['help'] = 'सहायता';
$string['helpprefix2'] = '{$a} के साथ सहायता';
$string['helpwiththis'] = 'इसके साथ मदद करें';
$string['hiddenassign'] = 'छुपा असाइनमेंट';
$string['hiddenfromstudents'] = 'छात्रों से छिपा हुआ';
$string['hiddenoncoursepage'] = 'उपलब्ध है लेकिन पाठ्यक्रम पृष्ठ पर नहीं दिखाया गया है';
$string['hiddensections'] = 'छिपे हुए खंड';
$string['hiddensections_help'] = 'यह सेटिंग निर्धारित करती है कि छिपे हुए अनुभाग छात्रों को संक्षिप्त रूप में प्रदर्शित किए जाते हैं (शायद छुट्टियों को इंगित करने के लिए साप्ताहिक प्रारूप में पाठ्यक्रम के लिए) या पूरी तरह छुपाए गए हैं।';
$string['hiddensectionscollapsed'] = 'छिपे हुए खंड संक्षिप्त रूप में दिखाए जाते हैं';
$string['hiddensectionsinvisible'] = 'छिपे हुए वर्ग पूरी तरह से अदृश्य हैं';
$string['hiddenwithbrackets'] = '(छिपा हुआ)';
$string['hide'] = 'छिपादो';
$string['hideadvancedsettings'] = 'अड्वॅन्स्ड सेट्टिंग्स छिपादो';
$string['hidechartdata'] = 'चार्ट डेटा छुपाएं';
$string['hidefromstudents'] = 'छात्रों से छुपाएं';
$string['hideoncoursepage'] = 'उपलब्ध कराएं लेकिन पाठ्यक्रम पृष्ठ पर नहीं दिखाया गया है';
$string['hidepopoverwindow'] = 'पॉपओवर विंडो छुपाएं';
$string['hidesection'] = '{$a} अनुभाग छिपादो';
$string['hidesettings'] = 'सेट्टिंग्स छिपादो';
$string['hideshowblocks'] = 'ब्लॉक छुपाएं या दिखाएं';
$string['highlight'] = 'मुख्य बातें';
$string['highlighted'] = 'हाइलाइट';
$string['highlightoff'] = 'हाइलाइट निकालें';
$string['hits'] = 'हित्स';
$string['hitsoncourse'] = '{$a->coursename} पे {$a->username} के हित्स';
$string['hitsoncoursetoday'] = '{$a->coursename} पर आज की हिट {$a->username} द्वारा';
$string['home'] = 'मुख्य पेज';
$string['homeheader'] = 'होम मेनू';
$string['hour'] = 'घंटा';
$string['hours'] = 'घंट';
$string['howtomakethemes'] = 'नई थीम कैसे बनाएं';
$string['htmleditor'] = 'HTML संपादक का प्रयोग करें';
$string['htmleditoravailable'] = 'एचटीएमएल संपादक उपलब्ध है';
$string['htmleditordisabled'] = 'आपने अपनी उपयोगकर्ता प्रोफ़ाइल में HTML संपादक को अक्षम कर दिया है';
$string['htmleditordisabledadmin'] = 'व्यवस्थापक ने इस साइट पर HTML संपादक को अक्षम कर दिया है';
$string['htmleditordisabledbrowser'] = 'HTML संपादक उपलब्ध नहीं है क्योंकि आपका वेब ब्राउज़र संयोज्य नहीं है';
$string['htmlfilesonly'] = 'सिर्फ़ HTML फाय्लेस';
$string['htmlformat'] = 'सुंदर एचटीएमएल प्रारूप';
$string['icon'] = 'चिह्न';
$string['idnumber'] = 'ID संख्या';
$string['idnumbercourse'] = 'कोर्स ID संख्या';
$string['idnumbercourse_help'] = '<p align="center"><strong>कोर्स ID नम्बर</strong></p>

<p>कोर्स का ID नम्बर केवल तभी उपयोग में लाया जाता है जब इस कोर्स को बाहरी सिस्टम्स से मिलाया जाता है - यह मूडल में कभी नहीं दिखाया जाता है। अगर आपके कोर्स का कोई औपचारिक कोड नेम है, तो आप उसका यहाँ प्रयोग कर सकते हैं … अन्यथा आप इस स्थान को खाली छोड़ सकते हैं।</p>';
$string['idnumbercoursecategory'] = 'श्रेणी आईडी संख्या';
$string['idnumbercoursecategory_help'] = 'पाठ्यक्रम श्रेणी की आईडी संख्या का उपयोग केवल बाहरी सिस्टम के खिलाफ श्रेणी से मेल खाने पर किया जाता है और साइट पर कहीं भी प्रदर्शित नहीं होता है। यदि श्रेणी का आधिकारिक कोड नाम है तो इसे दर्ज किया जा सकता है, अन्यथा फ़ील्ड को खाली छोड़ दिया जा सकता है।';
$string['idnumbergroup'] = 'समूह आईडी संख्या';
$string['idnumbergroup_help'] = 'किसी समूह की आईडी संख्या का उपयोग केवल बाहरी सिस्टम के विरुद्ध समूह से मेल खाने पर किया जाता है और साइट पर कहीं भी प्रदर्शित नहीं होता है। यदि समूह का आधिकारिक कोड नाम है तो इसे दर्ज किया जा सकता है, अन्यथा फ़ील्ड को खाली छोड़ दिया जा सकता है।';
$string['idnumbergrouping'] = 'ग्रुपिंग आईडी नंबर';
$string['idnumbergrouping_help'] = 'समूहकरण की आईडी संख्या का उपयोग केवल बाहरी सिस्टम के खिलाफ समूह मिलान करते समय किया जाता है और साइट पर कहीं भी प्रदर्शित नहीं होता है। यदि समूह के पास आधिकारिक कोड नाम है तो इसे दर्ज किया जा सकता है, अन्यथा फ़ील्ड को खाली छोड़ दिया जा सकता है।';
$string['idnumbermod'] = 'आईडी नंबर';
$string['idnumbermod_help'] = 'आईडी नंबर सेट करना ग्रेड गणना उद्देश्यों के लिए गतिविधि की पहचान करने का एक तरीका प्रदान करता है। यदि गतिविधि किसी भी ग्रेड गणना में शामिल नहीं है तो आईडी संख्या फ़ील्ड को खाली छोड़ दिया जा सकता है।

आईडी संख्या को ग्रेडबुक में भी सेट किया जा सकता है, हालांकि इसे केवल गतिविधि सेटिंग्स पृष्ठ पर संपादित किया जा सकता है।';
$string['idnumbertaken'] = 'यह आईडी नंबर पहले ही लिया जा चुका है';
$string['imagealt'] = 'चित्र वर्णन';
$string['import'] = 'इम्पोर्ट';
$string['importdata'] = 'पाठ्यक्रम डेटा आयात करें';
$string['importdataexported'] = 'सफलतापूर्वक \'से\' पाठ्यक्रम से निर्यात किया गया डेटा। <br /> अपने \'टू\' कोर्स में आयात करना जारी रखें।';
$string['importdatafinished'] = 'आयात पूर्ण करें! अपने पाठ्यक्रम के लिए जारी रखें';
$string['importdatafrom'] = 'डेटा आयात करने के लिए एक कोर्स खोजें:';
$string['inactive'] = 'निरुद्यम';
$string['include'] = 'शामिल';
$string['includeallusers'] = 'सभी उपयोगकर्ताओं को शामिल करें';
$string['includecoursefiles'] = 'पाठ्यक्रम फ़ाइलों को शामिल करें';
$string['includecourseusers'] = 'पाठ्यक्रम उपयोगकर्ताओं को शामिल करें';
$string['included'] = 'शामिल कर दिया गया';
$string['includelogentries'] = 'लॉग प्रविष्टियों को शामिल करें';
$string['includemodules'] = 'मॉड्यूल शामिल करें';
$string['includemoduleuserdata'] = 'मॉड्यूल उपयोगकर्ता दाता को शामिल करें';
$string['includeneededusers'] = 'आवश्यक उपयोगकर्ताओं को शामिल करें';
$string['includenoneusers'] = 'कोई उपयोगकर्ता शामिल न करें';
$string['includeroleassignments'] = 'भूमिका लागूओ को शामिल करें';
$string['includesitefiles'] = 'इस पाठ्यक्रम में उपयोग की जाने वाली साइट फाइलें शामिल करें';
$string['includeuserfiles'] = 'उपयोगकर्ता की फ़ाइलों को शामिल करें';
$string['increasesections'] = 'अनुभागों की संख्या बढ़ाएँ';
$string['indicator:accessesafterend'] = 'अंतिम तिथि के बाद पाठ्यक्रम का उपयोग';
$string['indicator:accessesafterend_help'] = 'यह संकेतक दर्शाता है कि छात्र ने कोर्स की अंतिम तिथि के बाद पाठ्यक्रम को एक्सेस किया है या नहीं।';
$string['indicator:accessesbeforestart'] = 'कोर्स शुरू होने से पहले उपयोग किया गया';
$string['indicator:accessesbeforestart_help'] = 'यह सूचक दर्शाता है कि पाठ्यक्रम शुरू होने की तारीख से पहले छात्र ने पाठ्यक्रम को एक्सेस किया या नहीं।';
$string['indicator:activitiesdue'] = 'नियत गतिविधियाँ';
$string['indicator:activitiesdue_help'] = 'उपयोगकर्ता की गतिविधियों नियत है।';
$string['indicator:anycourseaccess'] = 'किसी भी पाठ्यक्रम का उपयोग';
$string['indicator:anycourseaccess_help'] = 'यह संकेतक किसी भी पाठ्यक्रम तक पहुंच को दर्शाता है जिसमें उपयोगकर्ता को नामांकित किया गया है।';
$string['indicator:anywrite'] = 'कोई भी लिखने की क्रिया';
$string['indicator:anywrite_help'] = 'यह संकेतक, छात्र द्वारा की गई किसी भी लिखित (सबमिट) कार्रवाई का प्रतिनिधित्व करता है।';
$string['indicator:anywriteincourse'] = 'पाठ्यक्रम में कोई भी लिखित कार्रवाई';
$string['indicator:anywriteincourse_help'] = 'यह संकेतक किसी भी पाठ्यक्रम गतिविधि में छात्र द्वारा किए गए किसी भी लेखन (सबमिट) कार्रवाई का प्रतिनिधित्व करता है।';
$string['indicator:completeduserprofile'] = 'उपयोगकर्ता प्रोफ़ाइल पूरी हो गयी है';
$string['indicator:completeduserprofile_help'] = 'यह संकेतक दर्शाता है कि छात्र ने अपना उपयोगकर्ता प्रोफ़ाइल पूरी कर ली है।';
$string['indicator:completeduserprofiledef'] = 'उपयोगकर्ता प्रोफ़ाइल पूरी हो गयी है';
$string['indicator:completeduserprofiledef_help'] = 'साइट नीतियों के लिए सहमति दे दी गई है और उपयोगकर्ता ने निम्नलिखित विवरण दे दिया है: संस्थान, विभाग, पता, शहर, देश, URL';
$string['indicator:completionenabled'] = 'पूर्ण ट्रैकिंग सक्षम है';
$string['indicator:completionenabled_help'] = 'यह संकेतक दर्शाता है कि इस कोर्स के लिए पूर्ण ट्रैकिंग सक्षम की गई है।';
$string['indicator:nostudent'] = 'छात्र नामांकन';
$string['indicator:nostudent_help'] = 'यह संकेतक पाठ्यक्रम में छात्रों की उपलब्धता को दर्शाता है।';
$string['indicator:noteacher'] = 'शिक्षक की उपलब्धता';
$string['indicator:noteacher_help'] = 'यह संकेतक पाठ्यक्रम में शिक्षकों की उपलब्धता को दर्शाता है।';
$string['indicator:potentialcognitive'] = 'कोर्स संभावित संज्ञानात्मक गहराई';
$string['indicator:potentialcognitive_help'] = 'यह संकेतक संभावित संज्ञानात्मक गहराई पर आधारित है जो पाठ्यक्रम गतिविधियों में भाग लेने वाले छात्र द्वारा पहुंचा जा सकता है।';
$string['indicator:potentialcognitivedef'] = 'कोर्स संभावित संज्ञानात्मक गहराई';
$string['indicator:potentialcognitivedef_help'] = 'डिग्री जो "गहन" संज्ञानात्मक जुड़ाव प्रदान करती है, उदा। प्रतिक्रिया के लिए काम प्रस्तुत करना, दूसरों द्वारा काम की समीक्षा करने का अवसर, और काम को संशोधित करने और फिर से शुरू करने का अवसर।';
$string['indicator:potentialcognitivedef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:potentialsocial'] = 'कोर्स संभावित सामाजिक विस्तार';
$string['indicator:potentialsocial_help'] = 'यह संकेतक संभावित सामाजिक विस्तार पर आधारित है जो पाठ्यक्रम गतिविधियों में भाग लेने वाले छात्र द्वारा पहुंचा जा सकता है।';
$string['indicator:potentialsocialdef'] = 'कोर्स संभावित सामाजिक विस्तार';
$string['indicator:potentialsocialdef_help'] = 'डिग्री जिस पर पाठ्यक्रम "व्यापक" सामाजिक जुड़ाव प्रदान करता है, अन्य प्रतिभागियों के साथ बातचीत और वर्ग से परे अभ्यास के समुदाय के साथ।';
$string['indicator:potentialsocialdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indicator:readactions'] = 'कार्रवाई की मात्रा पढ़ें';
$string['indicator:readactions_help'] = 'यह संकेतक छात्र द्वारा लिए गए पढ़ने (देखने) की संख्या का प्रतिनिधित्व करता है।';
$string['indicator:userforumstracking'] = 'उपयोगकर्ता फोरम पर नज़र रख रहा है';
$string['indicator:userforumstracking_help'] = 'यह सूचक दर्शाता है कि छात्र ने मंचों में ट्रैकिंग चालू की है या नहीं।';
$string['info'] = 'सूचना';
$string['inprogress'] = 'कार्य प्रगति पर है';
$string['insertresourceoractivitybefore'] = '\'{$a->activityname}\' से पहले एक गतिविधि या संसाधन डालें';
$string['institution'] = 'संस्था';
$string['instudentview'] = 'in student view';
$string['interests'] = 'रुचिया';
$string['interestslist'] = 'रुचियो की सूची';
$string['interestslist_help'] = 'अपनी रुचियों को एक-एक करके दर्ज करें, जो बाद में आपके प्रोफाइल पेज पर टैग के रूप में प्रदर्शित होगी।';
$string['invalidemail'] = 'अमान्य ईमेल पता';
$string['invalidlogin'] = 'गलत लॉगिन, कृपया फिर से प्रयत्न कीजिये';
$string['invalidtaskclassname'] = 'अवैद्य कार्य श्रेणी {$a}';
$string['invalidtaskid'] = 'अवैद्य कार्य ID';
$string['invalidusername'] = 'उपयोगकर्ता नाम में केवल अल्फ़ान्यूमेरिक लोअरकेस वर्ण (अक्षर और संख्याएँ), अंडरस्कोर (_), हाइफ़न (-), अवधि (।) या प्रतीक (@) हो सकते हैं।';
$string['invalidusernameupload'] = 'अमान्य उपयोगकर्ता नाम';
$string['ip_address'] = 'आईपी पता';
$string['jump'] = 'जंप';
$string['jumpto'] = 'को जंप करें...';
$string['keep'] = 'रखे';
$string['labelvalue'] = '{$a->लेबल}: {$a->मान}';
$string['langltr'] = 'भाषा की दिशा बाएं से दाएं';
$string['langrtl'] = 'भाषा की दिशा दाएं-बाएं';
$string['language'] = 'भाषा';
$string['languagegood'] = 'यह भाषा पैक अप-टू-डेट है! :-)';
$string['languageselector'] = 'भाषा चयनकर्ता';
$string['last'] = 'अंतिम';
$string['lastaccess'] = 'पिछ्ला आगमन';
$string['lastcourseaccess'] = 'पाठ्यक्रम के लिए अंतिम पहुँच';
$string['lastedited'] = 'पिछ्ला संपादन';
$string['lastip'] = 'अंतिम आईपी एड्रेस';
$string['lastlogin'] = 'अंतिम लॉगइन';
$string['lastmodified'] = 'पिछ्ला सुधार';
$string['lastname'] = 'सरनेम';
$string['lastnamephonetic'] = 'उपनाम - ध्वन्यात्मक';
$string['lastpage'] = 'अंतिम पृष्ठ';
$string['lastsiteaccess'] = 'साइट तक अंतिम पहुंच';
$string['lastyear'] = 'पिछले साल';
$string['latestlanguagepack'] = 'moodle.org से नवीनतम भाषा पैक प्राप्त करिए';
$string['layouttable'] = 'लेआउट तालिका';
$string['leavetokeep'] = 'करंट पासवर्ड रखने के लिए खाली छोड़ दें';
$string['legacylogginginuse'] = 'इस साइट के पास वर्तमान में विरासत लॉग स्टोर सक्षम करने के लिए लेखन है। इस लॉग स्टोर पर लिखना पदावनत है। कृपया एक समर्थित लॉग स्टोर जैसे "मानक" या "बाहरी" लिखें।';
$string['legacythemeinuse'] = 'यह साइट आपको संगतता मोड में प्रदर्शित कर रही है क्योंकि आपका ब्राउज़र बहुत पुराना है।';
$string['license'] = 'लाइसेंस';
$string['licenses'] = 'लाइसेंस';
$string['liketologin'] = 'क्या आप अब पूर्ण उपयोगकर्ता खाते के साथ लॉग इन करना चाहेंगे?';
$string['list'] = 'सूची';
$string['listfiles'] = '{$a} में फाय्लेस की सूची';
$string['listofallpeople'] = 'सभी जनता की सूची';
$string['listofcourses'] = 'पाठ्यक्रमों की सूची';
$string['loading'] = 'ला रहा है';
$string['loadinghelp'] = 'Loading...';
$string['local'] = 'स्थानीय';
$string['localplugins'] = 'स्थानीय प्लगइन्स';
$string['localpluginsmanage'] = 'स्थानीय प्लगइन्स प्रबंधित करें';
$string['location'] = 'स्थान';
$string['locktimeout'] = 'ताले का इंतजार करते हुए ऑपरेशन का समय समाप्त हो गया।';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'आप {$a} हैं';
$string['loggedinasguest'] = 'आप वर्तमान में अतिथि का उपयोग कर रहे हैं';
$string['loggedinnot'] = 'आप ने लॉगिन नहीं किया है';
$string['login'] = 'लॉग इन करें';
$string['login_failure_logs'] = 'लॉग-इन भूल के लोग्स';
$string['loginactivity'] = 'गतिविधि लॉगिन करें';
$string['loginagain'] = 'फिर से लॉगिन करें';
$string['loginalready'] = 'आप पहले से लॉगिन कर रहे हैं';
$string['loginas'] = 'इससे लॉगिन करें';
$string['loginaspasswordexplain'] = '<p> आपको इस सुविधा का उपयोग करने के लिए विशेष "लॉगिन पासवर्ड" दर्ज करना होगा। <br/> यदि आप इसे नहीं जानते हैं, तो अपने सर्वर व्यवस्थापक से पूछें। </p>';
$string['loginguest'] = 'अतिथि के रूप में लॉग इन करें';
$string['loginsite'] = 'साइट पर लॉग इन करें';
$string['loginsteps'] = 'नमस्ते! पूर्ण प्रवेश के लिये आपको एक मिनट का समय निकाल कर इस सा‌इट पर अपना ऍका‌उन्ट बनना होगा। प्रत्येक कोर्स के लिये एक
"प्रवेश की" भी हो सकती है, जिसकी आवश्यकता आपको बाद में
पड़ सकती है।  कृपया निम्नलिखित निर्देशों का पालन कीजिये:

<ol>
<li><a href="{$a}">नये ऍकाउन्ट</a> का फ़ॉर्म भरिये।</li>

<li>हम आपको ई-मेल भेजेंगे।</li>

<li>आप भेजे गए ई-मेल सन्देश को पढ़ने के बाद उसमें दी गई लिंक पर क्लिक करिए।</li>

<li>आपके ऍकाउन्ट की पुष्टि होने के बाद आप लॉग-इन कर सकेंगे।</li>

<li>अब आप अपना मनपसन्द कोर्स चुन सकते हैं।</li>

<li>आगर कोर्स के लिये "प्रवेश की" की आवश्यकता है, तो अपने
टीचर द्वारा दी गयी "प्रवेश की" क उपयोग करें. आप कोर्स में प्रवेश
पा सकेंगे।</li>

<li>अब आप कोर्स में पूर्ण प्रवेश पा सकेंगे. अब से आपको अपने कोर्स में प्रवेश पाने के लिये केवल अपना यूज़रनेम और पासवर्ड देना गा।</li>

</ol>';
$string['loginstepsnone'] = '<p>नमस्ते!</p>
<p>पूर्ण प्रवेश के लिये आपको इस सा‌इट पर अपना ऍका‌उन्ट बनना होगा।</p>
<p>आपको बस एक यूज़रनेम और पास्वर्ड चुनना है और इस पेज
पर उनका उपयोग  करना है!</p>
<p>अगर किसी और ने पहले से ही आपके द्वारा चुना गया यूज़रनेम
ले लिया है, तो आपको दूसरा यूज़रनेम चुनना होगा।</p>';
$string['loginto'] = '{$a} में लॉग इन करें';
$string['logoof'] = '{$a} का लोगो';
$string['logout'] = 'लोग आउट';
$string['logoutconfirm'] = 'क्या आप वास्तव में लॉग आउट करना चाहते हैं?';
$string['logs'] = 'लॉग्स';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">और</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">और</a> ]';
$string['lookback'] = 'पिछला देखिए';
$string['mailadmins'] = 'ऍड्मिन्स को सूचित कर';
$string['mailstudents'] = 'विद्यार्थीयो को सूचित करें';
$string['mailteachers'] = 'अध्यापाको को सूचित करें';
$string['maincoursepage'] = 'मुख्य पाठ्यक्रम पृष्ठ';
$string['makeafolder'] = 'फोल्डर बनाएं';
$string['makeavailable'] = 'उपलब्ध कराएं';
$string['makeeditable'] = 'यदि आप वेब सर्वर प्रक्रिया द्वारा \'{$a}\' संपादन योग्य बनाते हैं (उदा। अपाचे) तो आप इस फ़ाइल को सीधे इस पृष्ठ से संपादित कर सकते हैं';
$string['makethismyhome'] = 'इसे मेरा मुख्य पृष्ठ बनाओ';
$string['makeunavailable'] = 'अनुपलब्ध करें';
$string['manageblocks'] = 'ब्लॉक्स';
$string['managecategories'] = 'पाठ्यक्रम श्रेणियां प्रबंधित करें';
$string['managecategorythis'] = 'इस श्रेणी का प्रबंधन करें';
$string['managecombined'] = 'पाठ्यक्रम श्रेणियों और पाठ्यक्रमों का प्रबंधन करें';
$string['managecontentbanktypes'] = 'सामग्री प्रकार प्रबंधित करें';
$string['managecourses'] = 'पाठ्यक्रम प्रबंधित करें';
$string['managedatabase'] = 'डाटाबसे';
$string['managedataformats'] = 'डेटा प्रारूप प्रबंधित करें';
$string['manageeditorfiles'] = 'संपादक द्वारा उपयोग की गई फ़ाइलें प्रबंधित करें';
$string['managefilters'] = 'फिलटर्स';
$string['managemodules'] = 'मॉड्यूल्स';
$string['manageroles'] = 'भूमिकाएं और अनुमति';
$string['markallread'] = 'सभी को पढ़ा हुआ मार्क करें';
$string['markedthistopic'] = 'इस विषय को वर्तमान विषय के रूप में रेखांकित किया गया है';
$string['markthistopic'] = 'इस विषय को वर्तमान विषय के रूप में हाइलाइट करें';
$string['match'] = 'मिलान';
$string['matchingsearchandrole'] = '\'{$a->search}\' और {$a->roles} का मिलान करना';
$string['matchofthefollowing'] = 'निम्न में से:';
$string['maxareabytesreached'] = 'फ़ाइल (या कई फ़ाइलों का कुल आकार) इस क्षेत्र में शेष स्थान से बड़ी है।';
$string['maxfilesize'] = 'नई फ़ाइलों के लिए अधिकतम आकार: {$a}';
$string['maxfilesreached'] = 'आपको इस मद में अधिकतम {$a} फ़ाइल (s) संलग्न करने की अनुमति है';
$string['maximumchars'] = 'अधिकतम {$a} अक्षर';
$string['maximumgrade'] = 'अधिकतम ग्रेड';
$string['maximumgradex'] = 'अधिकतम ग्रेड: {$a}';
$string['maximumshort'] = 'अधिकतम';
$string['maximumupload'] = 'अधिकतम उपलोआड आमाप';
$string['maximumupload_help'] = 'यह सेटिंग उस फ़ाइल का सबसे बड़ा आकार निर्धारित करती है जिसे किसी व्यवस्थापक द्वारा निर्धारित साइट-वाइड सेटिंग द्वारा सीमित करके पाठ्यक्रम में अपलोड किया जा सकता है। गतिविधि मॉड्यूल में फ़ाइल आकार को आगे प्रतिबंधित करने के लिए अधिकतम अपलोड आकार सेटिंग भी शामिल है';
$string['maxnumberweeks'] = 'वर्गों की अधिकतम संख्या';
$string['maxnumberweeks_desc'] = 'अनुभाग ड्रॉप-डाउन मेनू की संख्या में अधिकतम मूल्य (केवल कुछ पाठ्यक्रम प्रारूपों पर लागू होता है)।';
$string['maxnumcoursesincombo'] = 'ब्राउज़ करें  <a href="{$a->link}">{$a->numberofcourses} पाठ्यक्रम</a>.';
$string['maxsectionslimit'] = 'इस खंड ({$a}) के लिए अनुमत वर्गों की अधिकतम संख्या से अधिक होने पर नया अनुभाग नहीं बनाया जा सकता।';
$string['maxsize'] = 'अधिकतम आमाप: {$a}';
$string['maxsizeandareasize'] = 'नई फ़ाइलों के लिए अधिकतम आकार: {$a-> size}, समग्र सीमा: {$ a-> areasize}';
$string['maxsizeandattachments'] = 'नई फ़ाइलों के लिए अधिकतम आकार: {$ a->size}, अधिकतम संलग्नक: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'अधिकतम फ़ाइल आकार: {$a->size}, अधिकतम संलग्नक: {$a->attachments}, अधिकतम कुल आकार: {$a->areasize}';
$string['memberincourse'] = 'पाठ्यक्रम में प्रतिभागी';
$string['menu'] = 'मेन्यू';
$string['message'] = 'सन्देश';
$string['messagebody'] = 'संदेश का मुख्य हिस्सा';
$string['messagedselectedusers'] = 'चयनित उपयोगकर्ताओं को सन्देश भेज दिया गया है और प्राप्तकर्ता सूची रीसेट कर दी गई है।';
$string['messagedselectedusersfailed'] = 'चयनित उपयोगकर्ताओं को संदेश देते समय कुछ गलत हो गया। कुछ को ईमेल प्राप्त हो सकता है।';
$string['messageprovider:asyncbackupnotification'] = 'अतुल्यकालिक बैकअप / सूचनाएं बहाल करें';
$string['messageprovider:availableupdate'] = 'उपलब्ध नवीनीकरण सूचनाएं';
$string['messageprovider:backup'] = 'बैकअप सूचनाएँ';
$string['messageprovider:badgecreatornotice'] = 'बैज निर्माता की सूचनाएँ';
$string['messageprovider:badgerecipientnotice'] = 'बैज प्राप्तकर्ता की सूचनाएं';
$string['messageprovider:competencyplancomment'] = 'लर्निंग प्लान पर टिप्पणी पोस्ट की गई';
$string['messageprovider:competencyusercompcomment'] = 'टिप्पणी एक योग्यता पर पोस्ट की गई';
$string['messageprovider:coursecompleted'] = 'कोर्स पूरा किया';
$string['messageprovider:coursecontentupdated'] = 'कोर्स सामग्री में परिवर्तन';
$string['messageprovider:courserequestapproved'] = 'पाठ्यक्रम निर्माण अनुरोध अनुमोदन अधिसूचना';
$string['messageprovider:courserequested'] = 'पाठ्यक्रम निर्माण अनुरोध अधिसूचना';
$string['messageprovider:courserequestrejected'] = 'पाठ्यक्रम निर्माण अनुरोध अस्वीकृति अधिसूचना';
$string['messageprovider:errors'] = 'साइट के साथ महत्वपूर्ण त्रुटियां';
$string['messageprovider:errors_help'] = 'ये महत्वपूर्ण त्रुटियां हैं जिनके बारे में एक व्यवस्थापक को पता होना चाहिए।';
$string['messageprovider:gradenotifications'] = 'ग्रेड सूचनाएं';
$string['messageprovider:infected'] = 'एंटीवायरस विफलता सूचनाएं।';
$string['messageprovider:insights'] = 'पूर्व-सूचना मॉडल द्वारा उत्पन्न अंतर्दृष्टि';
$string['messageprovider:instantmessage'] = 'उपयोगकर्ताओं के बीच व्यक्तिगत संदेश';
$string['messageprovider:instantmessage_help'] = 'यह अनुभाग उस संदेश को कॉन्फ़िगर करता है जो उन संदेशों का होता है जो इस साइट पर अन्य उपयोगकर्ताओं से सीधे आपके पास भेजे जाते हैं।';
$string['messageprovider:messagecontactrequests'] = 'संदेश संपर्क अनुरोध सूचना';
$string['messageprovider:newlogin'] = 'नई लॉगिन सूचनाएं';
$string['messageprovider:notices'] = 'मामूली समस्याओं के बारे में समन';
$string['messageprovider:notices_help'] = 'ये समन हैं कि एक व्यवस्थापक को देखने में रुचि हो सकती है।';
$string['messageprovider:reportbuilderschedule'] = 'कस्टम रिपोर्ट बिल्डर शेड्यूल';
$string['messageselect'] = 'संदेश प्राप्तकर्ता के रूप में इस उपयोगकर्ता का चयन करें';
$string['messageselectadd'] = 'एक संदेश भेजें';
$string['middlename'] = 'मध्य नाम';
$string['migratinggrades'] = 'ग्रेड स्थानांतरित हो रहे है';
$string['min'] = 'मिनट';
$string['mins'] = 'मिनट';
$string['minute'] = 'मिनट';
$string['minutes'] = 'मिनट';
$string['miscellaneous'] = 'विविध';
$string['missingcategory'] = 'वर्ग गायब';
$string['missingdescription'] = 'विवरण गायब';
$string['missingemail'] = 'ई-मेल गायब';
$string['missingfirstname'] = 'प्रथम नाम गायब';
$string['missingfromdisk'] = 'डिस्क में अनुपस्थित है';
$string['missingfullname'] = 'पूरा नाम गायब';
$string['missinglastname'] = 'उपनाम गायब';
$string['missingname'] = 'नाम गायब';
$string['missingnewpassword'] = 'नया पासवर्ड गायब';
$string['missingpassword'] = 'पासवर्ड गायब';
$string['missingrecaptchachallengefield'] = 'विफल reCAPTCHA चुनौती, फिर से प्रयास करें।';
$string['missingreqreason'] = 'कारण गायब';
$string['missingshortname'] = 'सन्क्षिप्त नाम गायब';
$string['missingshortsitename'] = 'सन्क्षिप्त साइट नाम गायब';
$string['missingsitedescription'] = 'साइट विवरण गायब';
$string['missingsitename'] = 'साइट नाम गायब';
$string['missingstrings'] = 'अनुवाद नहीं किए गए शब्दों या वाक्यांशों के लिए जाँच करें';
$string['missingstudent'] = 'कुछ चुनिए';
$string['missingsummary'] = 'सन्क्षिप्त विवरण गायब';
$string['missingteacher'] = 'अध्यापक गायब';
$string['missingurl'] = 'URL गायब';
$string['missingusername'] = 'यूज़रनेम गायब';
$string['moddoesnotsupporttype'] = 'मॉड्यूल {$a->modname}, {$a->type} प्रकार के अपलोड का समर्थन नहीं करता है';
$string['modhide'] = 'छिपादो';
$string['modified'] = 'सुधारण';
$string['modshow'] = 'दिखाए';
$string['moduleintro'] = 'विवरण';
$string['modulesetup'] = 'मॉड्यूल तालिकाओं की स्थापना';
$string['modulesuccess'] = '{$a} तालिका सही ढंग से स्थापित कि गयी';
$string['modulesused'] = 'इस्तेमाल किये गए मॉड्यूल';
$string['modvisible'] = 'उपलब्धता';
$string['modvisible_help'] = 'यदि उपलब्धता \'कोर्स पेज पर दिखाएँ\' पर सेट है, तो गतिविधि या संसाधन छात्रों के लिए उपलब्ध है (किसी भी एक्सेस प्रतिबंध के अधीन जो सेट किया जा सकता है)।

यदि उपलब्धता \'छात्रों से छिपाएं\' के लिए सेट है, तो गतिविधि या संसाधन केवल छिपे हुए गतिविधियों को देखने की अनुमति के साथ उपयोगकर्ताओं के लिए उपलब्ध है (डिफ़ॉल्ट रूप से, शिक्षक या गैर-संपादन शिक्षक की भूमिका वाले उपयोगकर्ता)।';
$string['modvisiblehiddensection'] = 'उपलब्धता';
$string['modvisiblehiddensection_help'] = 'यदि उपलब्धता \'छात्रों से छिपाएं\' के लिए सेट है, तो गतिविधि या संसाधन केवल छिपे हुए गतिविधियों को देखने की अनुमति के साथ उपयोगकर्ताओं के लिए उपलब्ध है (डिफ़ॉल्ट रूप से, शिक्षक या गैर-संपादन शिक्षक की भूमिका वाले उपयोगकर्ता)।

यदि पाठ्यक्रम में कई गतिविधियाँ या संसाधन हैं, तो उपलब्धता पृष्ठ को \'उपलब्ध कराएँ लेकिन पाठ्यक्रम पृष्ठ पर नहीं दिखाया गया है\' को निर्धारित करके पाठ्यक्रम पृष्ठ को सरल बनाया जा सकता है। इस मामले में, गतिविधि या संसाधन का एक लिंक अन्य जगहों से प्रदान किया जाना चाहिए, जैसे पृष्ठ संसाधन से। गतिविधि अभी भी ग्रेडबुक और अन्य रिपोर्टों में सूचीबद्ध होगी।';
$string['modvisiblewithstealth'] = 'उपलब्धता';
$string['modvisiblewithstealth_help'] = 'यदि उपलब्धता \'कोर्स पेज पर दिखाएँ\' पर सेट है, तो गतिविधि या संसाधन छात्रों के लिए उपलब्ध है (किसी भी एक्सेस प्रतिबंध के अधीन जो सेट किया जा सकता है)।

यदि उपलब्धता \'छात्रों से छिपाएं\' के लिए सेट है, तो गतिविधि या संसाधन केवल छिपे हुए गतिविधियों को देखने की अनुमति के साथ उपयोगकर्ताओं के लिए उपलब्ध है (डिफ़ॉल्ट रूप से, शिक्षक या गैर-संपादन शिक्षक की भूमिका वाले उपयोगकर्ता)।

यदि पाठ्यक्रम में कई गतिविधियाँ या संसाधन हैं, तो उपलब्धता पृष्ठ को \'उपलब्ध कराएँ लेकिन पाठ्यक्रम पृष्ठ पर नहीं दिखाया गया है\' को निर्धारित करके पाठ्यक्रम पृष्ठ को सरल बनाया जा सकता है। इस मामले में, गतिविधि या संसाधन का एक लिंक अन्य जगहों से प्रदान किया जाना चाहिए, जैसे पृष्ठ संसाधन से। गतिविधि अभी भी ग्रेडबुक और अन्य रिपोर्टों में सूचीबद्ध होगी।';
$string['month'] = 'महीना';
$string['months'] = 'महीने';
$string['moodledocs'] = 'Moodle डॉक्युमेंटेशन';
$string['moodledocslink'] = 'यह पेज के लिए Moodle डॉक्युमेंटेशन';
$string['moodlelogo'] = 'Moodle लोगो';
$string['moodlenet:cannotconnecttoserver'] = 'MoodleNet सर्वर से संपर्क नहीं कर पा रहा है।';
$string['moodlenet:configoauthservice'] = 'Moodlenet OAuth 2 सेवा  को  Moodlenet साइट पर साझा करने की शुरुआत करने के लिए चयनित करें। यदि सेवा मौजूद नहीं है तो आपको इसका <a href="{$a}">निर्माण</a> करना पड़ेगा।';
$string['moodlenet:eventresourceexported'] = 'संसाधन एक्सपोर्ट किया गया';
$string['moodlenet:gotomoodlenet'] = 'MoodleNet ड्राफ्ट्स पर जाएँ';
$string['moodlenet:issuerisnotauthorized'] = 'MoodleNet जारीकर्ता अधिकृत नहीं है';
$string['moodlenet:issuerisnotenabled'] = 'MoodleNet जारीकर्ता सक्रिय नहीं है';
$string['moodlenet:issuerisnotset'] = 'MoodleNet जारीकर्ता साइट प्रशासन पर सेट नहीं है';
$string['moodlenet:outboundsettings'] = 'MoodleNet बहिर्गामी सेटिंग्स';
$string['moodlenet:packagingandsending'] = 'आपकी फाइल की पैकेजिंग करके MoodleNet को भेजा जा रहा है...';
$string['moodlenet:sharefailtext'] = 'आपके विषय को MoodleNet पर साझा करने में त्रुटि हुई है<br>कृपया पुनः प्रयास करें।';
$string['moodlenet:sharefailtextwithsitesupport'] = 'आपके विषय को MoodleNet पर साझा करने में त्रुटि हुई है<br>कृपया पुनः प्रयास करें या <a href="{$a}">सहायता के लिए साइट सपोर्ट के संपर्क करें</a>';
$string['moodlenet:sharefailtitle'] = 'कुछ गलत हो गया है';
$string['moodlenet:sharefilesizelimitexceeded'] = 'साझा किए जा रहे संसाधन की फ़ाइल का साइज़ (({$a->filesize} bytes) {$a->filesizelimit} की सीमा से अधिक है।';
$string['moodlenet:sharesuccesstext'] = 'लगभग पूरा हो गया है! अपनी सामग्री साझा करने के लिए मूडलनेट में अपने ड्राफ़्ट पर जाएँ।';
$string['moodlenet:sharesuccesstitle'] = 'MoodleNet ड्राफ्ट्स में सेव किया गया है';
$string['moodlenet:sharetomoodlenet'] = 'MoodleNet पर साझा करें';
$string['moodlenet:sharetyperesource'] = 'संसाधन';
$string['moodlenet:sharinglargefile'] = 'बड़ी फाइलों में कुछ समय लग सकता है।';
$string['moodlenet:sharingstatus'] = 'MoodleNet पर साझा कर रहा है';
$string['moodlenet:sharingto'] = ': के साथ साझा कर रहा है';
$string['moodlerelease'] = 'Moodle प्रकाशन';
$string['moodleservicesandsupport'] = 'सेवाएं और समर्थन';
$string['moodleversion'] = 'Moodle संस्करण';
$string['more'] = 'और';
$string['moreactions'] = 'अधिक क्रियाएं';
$string['morehelp'] = 'और अधिक सहायता';
$string['morehelpaboutmodule'] = '{$a} गतिविधि के बारे में अधिक सहायता';
$string['moreinfo'] = 'और जानकारी';
$string['moreinformation'] = 'इस त्रुटि के बारे में अधिक जानकारी';
$string['moremenu'] = 'और';
$string['morenavigationlinks'] = 'और...';
$string['moreprofileinfoneeded'] = 'कृपया हमें अपने बारे में और बताएं';
$string['mostrecently'] = 'अभी हाल में ही';
$string['move'] = 'हटाइए';
$string['movecategoriessuccess'] = '{$a->count} श्रेणियों को सफलतापूर्वक \'{$a->count}\' श्रेणी में स्थानांतरित किया गया';
$string['movecategoriestotopsuccess'] = '{$a->count} श्रेणियों को सफलतापूर्वक शीर्ष स्तर पर स्थानांतरित किया गया';
$string['movecategorycontentto'] = 'में स्थानांतरित';
$string['movecategorysuccess'] = 'श्रेणी \'{$a->moved}\' को श्रेणी \'{$a->to}\' में सफलतापूर्वक स्थानांतरित किया गया';
$string['movecategoryto'] = 'इस प्रवर्ग को यहा हटाइए :';
$string['movecategorytotopsuccess'] = '\'{$a->moved}\' श्रेणि को सफलतापूर्वक शीर्ष स्तर पर स्थानांतरित किया गया';
$string['movecontent'] = '{$a} ले जाएं';
$string['movecontentafter'] = '"{$a}" के बाद';
$string['movecontentstoanothercategory'] = 'सामग्री को दूसरी श्रेणी में ले जाएं';
$string['movecontenttothetop'] = 'सूची के शीर्ष पर';
$string['movecoursemodule'] = 'संसाधन ले जाएँ';
$string['movecoursesection'] = 'खंड ले जाएँ';
$string['movecourseto'] = 'इस कोर्स को यहा हटाइए :';
$string['movedown'] = 'नीचे हटाए';
$string['movefilestohere'] = 'फाय्लेस को यहा हटाए';
$string['movefull'] = '{$a} को यहा हटाए';
$string['movehere'] = 'यहा हटाए';
$string['moveleft'] = 'बायें हटाए';
$string['moveright'] = 'दायें हटाए';
$string['movesection'] = '{$a} अनुभाग को हटाए';
$string['moveselectedcategoriesto'] = 'चयनित श्रेणियों को स्थानांतरित करें';
$string['moveselectedcoursesto'] = 'चुने हुए कोर्सस को हटाए...';
$string['movetoanotherfolder'] = 'किसी अलग फोल्डर को हटाए';
$string['moveup'] = 'उपर हटाए';
$string['mustchangepassword'] = 'नया पासवर्ड वर्तमान से भिन्न होना चाहिए';
$string['mustconfirm'] = 'आपको अपने खाते की पुष्टि करने की आवश्यकता है';
$string['mycourses'] = 'मेरे पाठ्यक्रम';
$string['myfiles'] = 'मेरी निजी फाइलें';
$string['myfilesmanage'] = 'मेरी निजी फ़ाइलों को प्रबंधित करें';
$string['myhome'] = 'डैशबोर्ड';
$string['mymoodledashboard'] = 'मेरा Moodle डैशबोर्ड';
$string['myprofile'] = 'मेरी प्रोफाइल';
$string['name'] = 'नाम';
$string['namedfiletoolarge'] = 'फ़ाइल \'{$a->filename}\' बहुत बड़ी है और अपलोड नहीं की जा सकती';
$string['nameforlink'] = 'आप इस लिंक को क्या कहना चाहते हैं?';
$string['nameforpage'] = 'नाम';
$string['navigation'] = 'नेविगेशन';
$string['needed'] = 'आवश्यक';
$string['networkdropped'] = 'हमने पाया है कि आपका इंटरनेट कनेक्शन अविश्वसनीय है या बाधित हो गया है। <br />
कृपया ध्यान रखें कि आपके कनेक्शन में सुधार होने तक परिवर्तनों को ठीक से सहेजा नहीं जा सकता।';
$string['never'] = 'कभी नहीं';
$string['neverdeletelogs'] = 'लॉग्स कभी नहींं डिलीट् करें';
$string['new'] = 'नया';
$string['newaccount'] = 'नया ऍकाउन्ट';
$string['newactivityname'] = 'गतिविधि {$a} का नया नाम';
$string['newcourse'] = 'नया कोर्स';
$string['newloginnotificationbodyfull'] = '<p>नमस्ते {$a->उपयोगकर्ता नाम},</p>
<p>आपका {$a->sitename} खाता अभी एक नए डिवाइस से साइन इन किया गया था।</p>
<उल>
<li>आपका खाता: {$a->उपयोगकर्ता नाम} {$a->उपयोग करें </li>
<li>{$a->logintime}</li>
<li>डिवाइस: {$a->लॉगिनडिवाइस</li>
<li>आईपी: {$a->loginip</li>
</ul>
<p>अगर यह आप थे, तो आपको कुछ भी करने की ज़रूरत नहीं है।</p>
<p>यदि आप इस गतिविधि को नहीं पहचानते हैं, तो कृपया <a href="{$a->पासवर्डलिंक बदलें}">अपना पासवर्ड बदलें</a>।</p>';
$string['newloginnotificationbodysmall'] = 'आपके {$a} खाते में अभी-अभी एक नए डिवाइस से साइन इन किया गया था।';
$string['newloginnotificationtitle'] = 'आपके {$a} खाते में नया प्रवेश';
$string['newpassword'] = 'नया पास्वर्ड';
$string['newpassword_help'] = 'एक नया पासवर्ड दर्ज करें या वर्तमान पासवर्ड रखने के लिए खाली छोड़ दें।';
$string['newpasswordfromlost'] = '<strong> सूचना: </strong> आपका <strong> वर्तमान पासवर्ड </strong> खो पासवर्ड पुनर्प्राप्ति प्रक्रिया के भाग के रूप में भेजे गए दो ईमेल के <strong> दूसरे </strong> में आपको भेजा जाएगा। सुनिश्चित करें कि आपने इस स्क्रीन को जारी रखने से पहले अपना प्रतिस्थापन पासवर्ड प्राप्त कर लिया है।';
$string['newpasswordtext'] = 'नमस्कार {$a->firstname},

\'{$a->sitename}\' पर आपका खाता पासवर्ड रीसेट कर दिया गया है
और आपको एक नया अस्थायी पासवर्ड जारी किया गया है।

आपकी वर्तमान लॉगिन जानकारी अब है:
   उपयोगकर्ता नाम: {$a->username}
   पासवर्ड: {$a->newpassword}

कृपया अपना पासवर्ड बदलने के लिए इस पृष्ठ पर जाएं:
   {$a->link}

अधिकांश मेल कार्यक्रमों में, यह नीले लिंक के रूप में दिखाई देना चाहिए
जिस पर आप बस क्लिक कर सकते हैं। अगर वह काम नहीं करता है,
फिर पते में कट और पेस्ट करें
आपके वेब ब्राउज़र विंडो के शीर्ष पर रेखा।

\'{$a->sitename}\' व्यवस्थापक,
{$a->signoff}';
$string['newpicture'] = 'नया चित्र';
$string['newpicture_help'] = 'एक नई तस्वीर जोड़ने के लिए, ब्राउज़ करें और एक छवि चुनें (जेपीजी या पीएनजी प्रारूप में) फिर "अपडेट प्रोफाइल" पर क्लिक करें। छवि को एक वर्ग में क्रॉप किया जाएगा और 100x100 पिक्सेल का आकार दिया जाएगा।';
$string['newpictureusernotsetup'] = 'एक प्रोफ़ाइल चित्र केवल तभी जोड़ा जा सकता है जब सभी आवश्यक प्रोफ़ाइल जानकारी सहेज ली गई हों।';
$string['newsectionname'] = 'सेक्शन {$a} का नया नाम';
$string['newsitem'] = 'ख़बर विषय';
$string['newsitems'] = 'घोषणाये';
$string['newsitemsnumber'] = 'घोषणाओं की संख्या';
$string['newsitemsnumber_help'] = 'घोषणाओं का मंच एक विशेष मंच है जो पाठ्यक्रम में स्वचालित रूप से बनाया गया है, ने डिफ़ॉल्ट रूप से सदस्यता निर्धारित की है, और केवल उपयुक्त अनुमतियों (डिफ़ॉल्ट शिक्षकों द्वारा) वाले उपयोगकर्ता इसमें पोस्ट कर सकते हैं।

यह सेटिंग निर्धारित करती है कि नवीनतम घोषणाएं ब्लॉक में कितने हालिया घोषणाएं हैं।

यदि पाठ्यक्रम में घोषणा मंच की आवश्यकता नहीं है, तो यह सेटिंग शून्य पर सेट की जानी चाहिए।';
$string['newuser'] = 'नया यूज़र';
$string['newusernewpasswordsubj'] = 'नया यूज़र अकाउंट';
$string['newusernewpasswordtext'] = 'नमस्कार {$a->firstname},

आपके लिए \'{$a->sitename}\' पर एक नया खाता बनाया गया है
और आपको एक नया अस्थायी पासवर्ड जारी किया गया है।

आपकी वर्तमान लॉगिन जानकारी अब है:
   उपयोगकर्ता नाम: {$a->username}
   पासवर्ड: {$a->newpassword}
             (आपको अपना पासवर्ड बदलना होगा
              जब आप पहली बार लॉगइन करेंगे)

\'{$a->sitename}\' का उपयोग शुरू करने के लिए, लॉगिन करें
   {$a->link}

अधिकांश मेल कार्यक्रमों में, यह नीले लिंक के रूप में दिखाई देना चाहिए
जिस पर आप बस क्लिक कर सकते हैं। अगर वह काम नहीं करता है,
फिर पते में कट और पेस्ट करें
आपके वेब ब्राउज़र विंडो के शीर्ष पर रेखा।

\'{$a->sitename}\' व्यवस्थापक,
{$a->signoff}';
$string['newusers'] = 'नए यूज़र';
$string['newwindow'] = 'नई ब्राउज़र विंडो';
$string['next'] = 'अगला';
$string['nextpage'] = 'अगला पृष्ठ';
$string['nextsection'] = 'अगला अनुभाग';
$string['no'] = 'नहीं';
$string['noblockstoaddhere'] = 'ऐसे ऐसे कोई ब्लॉक नहीं हैं जिन्हें आप इस पेज पर जोड़ सकते हैं।ब्लॉक नहीं हैं जिन्हें आप इस पेज पर जोड़ सकते हैं।';
$string['nobody'] = 'कोइ नहीं';
$string['nochange'] = 'कोई परिवर्तन नहीं';
$string['nocomments'] = 'कोई टिप्पणी नहीं';
$string['nocourses'] = 'कोई पाठ्यक्रम नहीं';
$string['nocoursesfound'] = '\'{$a}\' शब्दों के साथ कोई पाठ्यक्रम नहीं पाया गया';
$string['nocoursestarttime'] = 'कोर्स की शुरुआत की तारीख नहीं है।';
$string['nocoursesyet'] = 'इस वर्ग में कोई कोर्स उपलब्ध नहीं है';
$string['nodstpresets'] = 'व्यवस्थापक ने डेलाइट सेविंग टाइम समर्थन सक्षम नहीं किया है।';
$string['nofilesselected'] = 'पुनर्स्थापित करने के लिए कोई फ़ाइल नहीं चुनी गई है';
$string['nofilesyet'] = 'आपके पाठ्यक्रम में अभी तक कोई फाइल अपलोड नहीं की गई है';
$string['nofiltersapplied'] = 'कोई फ़िल्टर लागू नहीं किया गया';
$string['nograde'] = 'कोई ग्रेड नही';
$string['nohelpforactivityorresource'] = 'वर्तमान में इस संसाधन या गतिविधि से संबंधित कोई सहायता उपलब्ध नहीं है';
$string['noimagesyet'] = 'आपके पाठ्यक्रम में अभी तक कोई चित्र अपलोड नहीं किया गया है';
$string['nologsfound'] = 'कोई लॉग नहीं मिला है';
$string['nomatchingusers'] = 'कोई उपयोगकर्ता \'{$a}\' से मेल नहीं खाता';
$string['nomorecourses'] = 'इससे मिलता-जुलता कोई कोर्स नहीं मिला';
$string['nomoreidnumber'] = 'टक्करों से बचने के लिए आईडीनंबर का उपयोग नहीं करना';
$string['none'] = 'कोई नहीं';
$string['noneditingteacher'] = 'गैर-संपादन शिक्षक';
$string['noneditingteacherdescription'] = 'गैर-संपादन शिक्षक पाठ्यक्रम और ग्रेड छात्रों को पढ़ा सकते हैं, लेकिन गतिविधियों में बदलाव नहीं कर सकते हैं।';
$string['nonstandard'] = 'गैर मानक';
$string['nopendingcourses'] = 'अनुमोदन के लिए कोई पाठ्यक्रम लंबित नहीं';
$string['nopotentialadmins'] = 'कोई संभाव्य ऍड्मिन्स नही';
$string['nopotentialcreators'] = 'कोई संभाव्य कोर्स क्रियेटर नही';
$string['nopotentialstudents'] = 'कोई संभाव्य विद्यार्थी नही';
$string['nopotentialteachers'] = 'कोई संभाव्य अध्यापक नही';
$string['norecentactivity'] = 'कोई हालिया गतिविधि नहीं';
$string['noreplybouncemessage'] = 'आपने एक नो-रिप्लाई ईमेल एड्रेस का जवाब दिया है। अगर आप फ़ोरम पोस्ट का उत्तर देने का प्रयास कर रहे थे, तो कृपया इसके बजाय {$a} फ़ोरम का उपयोग करके उत्तर दें।

आपके ईमेल की सामग्री निम्नलिखित है:';
$string['noreplybouncesubject'] = '{$a} - ईमेल बाउंस हो गया।';
$string['noreplyname'] = 'इस ईमेल का जवाब नहीं दें';
$string['noresetrecord'] = 'उस रीसेट अनुरोध का कोई रिकॉर्ड नहीं है। कृपया एक नया पासवर्ड रीसेट अनुरोध आरंभ करें।';
$string['noresults'] = 'परिणाम';
$string['normal'] = 'सामान्य';
$string['normalfilter'] = 'सामान्य सर्च';
$string['nosite'] = 'साइट-स्तरीय पाठ्यक्रम नहीं मिला';
$string['nostudentsfound'] = '{$a} नही मिला';
$string['nostudentsingroup'] = 'इस समूह में अभी तक कोई छात्र नहीं है';
$string['nostudentsyet'] = 'इस कोर्स में कोई छात्र नामांकित नहीं है।';
$string['nosuchemail'] = 'ऐसा कोई ईमेल पता नहीं है';
$string['notavailable'] = 'उपलब्ध नहीं है';
$string['notavailablecourse'] = '{$a} उपलब्ध नहीं है';
$string['noteachersyet'] = 'इस कोर्स में अभी तक कोई शिक्षक नहीं है';
$string['noteachingupcomingcourses'] = 'आगामी पाठ्यक्रमों में कोई शिक्षक या छात्र नहीं हैं';
$string['notenrolled'] = '{$a} इस पाठ्यक्रम में नामांकित नहीं है।';
$string['notenrolledprofile'] = 'यह प्रोफ़ाइल उपलब्ध नहीं है क्योंकि यह उपयोगकर्ता इस पाठ्यक्रम में नामांकित नहीं है।';
$string['noteusercannotrolldatesoncontext'] = '<strong>ध्यान दें:</strong> इस बैकअप को पुनर्स्थापित करते समय तिथियां रोल करने की क्षमता अक्षम कर दी गई है क्योंकि आपके पास आवश्यक अनुमतियां नहीं हैं।';
$string['noteuserschangednonetocourse'] = '<strong>ध्यान दें:</strong> उपयोगकर्ता डेटा (गतिविधियों, फ़ाइलों या संदेशों में) को पुनर्स्थापित करते समय पाठ्यक्रम उपयोगकर्ताओं को पुनर्स्थापित करने की आवश्यकता होती है। यह सेटिंग आपके लिए बदल दी गई है।';
$string['nothingnew'] = 'कोई नई गतिविधि नहीं है';
$string['nothingtodisplay'] = 'दिखाने के लिये कुछ नहीं';
$string['notice'] = 'सूचना';
$string['noticenewerbackup'] = 'यह बैकअप फ़ाइल Moodle {$a->backuprelease} ({$a->backupversion}) के साथ बनाई गई है और यह आपके वर्तमान में स्थापित Moodle {$a->serverrelease} ({$a->serverversion}) से नई है। यह कुछ विसंगतियों का कारण बन सकता है क्योंकि बैकअप फ़ाइलों की पश्चगामी संगतता की गारंटी नहीं दी जा सकती है।';
$string['notifications'] = 'सूचनाएं';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, यूज़र: {$a->info}';
$string['notifyloginfailuresmessageend'] = 'आप इन लॉग को {$a} पर देख सकते हैं';
$string['notifyloginfailuresmessagestart'] = 'पिछली बार सूचित किए जाने के बाद से {$a} पर विफल लॉगिन प्रयासों की सूची यहां दी गई है';
$string['notifyloginfailuressubject'] = '{$a} :: विफल लॉगिन सूचना';
$string['notincluded'] = 'शामिल नहीं';
$string['notingroup'] = 'क्षमा करें, लेकिन इस पृष्ठ को देखने के लिए आपको एक समूह का हिस्सा बनने की आवश्यकता है।';
$string['notpublic'] = 'सार्वजनिक नहीं!';
$string['nousersfound'] = 'कोई उपयोग्कर्ता नहीं मिले';
$string['nousersmatching'] = '\'{$a}\' से मेल खाने वाला कोई उपयोगकर्ता नहीं मिला';
$string['nousersyet'] = 'अभी तक कोई उपयोगकर्ता नहीं हैं';
$string['novalidcourses'] = 'दिखाने के लिए कोई वैध पाठ्यक्रम नहीं है';
$string['now'] = 'अभी';
$string['numattempts'] = '{$a} विफल लॉगिन प्रयास';
$string['numberofcourses'] = 'पाठ्यक्रमों की संख्या';
$string['numberweeks'] = 'वर्गों की संख्या';
$string['numday'] = '{$a} दिन';
$string['numdays'] = '{$a} दिन';
$string['numhours'] = '{$a} घंटे';
$string['numletters'] = '{$a} अक्षर';
$string['numminutes'] = '{$a} मिनिते';
$string['nummonth'] = '{$a} महीना';
$string['nummonths'] = '{$a} महीने';
$string['numseconds'] = '{$a} सेकेंड';
$string['numviews'] = '{$a} दृश्य';
$string['numweek'] = '{$a} सप्ताह';
$string['numweeks'] = '{$a} हफ्ते';
$string['numwords'] = '{$a} शब्द';
$string['numyear'] = '{$a} वर्ष';
$string['numyears'] = '{$a} साल';
$string['ok'] = 'ठीक है';
$string['oldpassword'] = 'वर्तमान पासवर्ड';
$string['olduserdirectory'] = 'यह पुराने उपयोगकर्ता निर्देशिका है, और अब इसकी आवश्यकता नहीं है। आप इसे सुरक्षित रूप से मिटा सकते हैं। इसमें शामिल फ़ाइलों को नई उपयोगकर्ता निर्देशिका में कॉपी किया गया है।';
$string['opendrawerblocks'] = 'ब्लॉक दराज खोलें';
$string['opendrawerindex'] = 'ओपन कोर्स इंडेक्स';
$string['opensinnewwindow'] = 'नई विंडो में खुलता है';
$string['operator_and'] = 'तथा';
$string['operator_andnot'] = 'तथा';
$string['operator_or'] = 'या';
$string['optional'] = 'वैकल्पिक';
$string['options'] = 'विकल्प';
$string['order'] = 'आदेश';
$string['originalpath'] = 'मूल पाथ';
$string['orphanedactivitiesinsectionno'] = 'अनाथ गतिविधियां (अनुभाग {$a})';
$string['other'] = 'अन्य';
$string['outline'] = 'रूपरेखा';
$string['outlinereport'] = 'रूपरेखा रिपोर्ट';
$string['page'] = 'पेज';
$string['pagea'] = 'पृष्ठ {$a}';
$string['pagedcontentnavigation'] = 'पृष्ठांकन नेविगेशन';
$string['pagedcontentnavigationactiveitem'] = 'वर्तमान पेज, पेज {$a}';
$string['pagedcontentnavigationitem'] = 'पेज {$a} पर जाएं';
$string['pagedcontentpagingbaritemsperpage'] = 'प्रति पेज {$a} आइटम दिखाएं';
$string['pageheaderconfigablock'] = '{$a->fullname} में ब्लॉक को कॉन्फ़िगर करना';
$string['pagepath'] = 'पृष्ठ पाथ';
$string['pageshouldredirect'] = 'यह पृष्ठ स्वचालित रूप से रीडायरेक्ट होना चाहिए। अगर कुछ नहीं हो रहा है तो कृपया नीचे दिए गए जारी लिंक का उपयोग करें।';
$string['parentcategory'] = 'अभिभावक श्रेणी';
$string['parentcoursenotfound'] = 'अभिभावक पाठ्यक्रम नहीं मिला!';
$string['parentfolder'] = 'मूल फोल्डर';
$string['participants'] = 'प्रतिभागियों';
$string['participantslist'] = 'प्रतिभागियों की सूची';
$string['participationratio'] = 'भागीदारी अनुपात';
$string['participationreport'] = 'भागीदारी रिपोर्ट';
$string['password'] = 'पासवर्ड';
$string['passwordchanged'] = 'पासवर्ड बदल दिया गया है';
$string['passwordconfirmchange'] = 'पासवर्ड बदल्ने की पुष्टि कीजिए';
$string['passwordextlink'] = 'आपके खोए हुए पासवर्ड को पुनर्प्राप्त करने के लिए निम्न लिंक प्रदान किया गया है। यह आपको मूडल से बाहर ले जाएगा।';
$string['passwordforgotten'] = 'पासवर्ड भूल गए';
$string['passwordforgotteninstructions'] = 'आपका विवरण पहले उपयोगकर्ता डेटाबेस में पाया जाना चाहिए। कृपया उपयुक्त बॉक्स में <strong>या तो</strong> अपना उपयोगकर्ता नाम या अपना पंजीकृत ईमेल पता दर्ज करें। दोनों में प्रवेश करने की आवश्यकता नहीं है।';
$string['passwordforgotteninstructions2'] = 'अपना पासवर्ड रीसेट करने के लिए, नीचे अपना उपयोगकर्ता नाम या अपना ईमेल पता सबमिट करें। यदि हम आपको डेटाबेस में ढूंढ सकते हैं, तो आपके ईमेल पते पर एक ईमेल भेजा जाएगा, जिसमें निर्देशों के साथ फिर से एक्सेस कैसे प्राप्त करें।';
$string['passwordnohelp'] = 'आपके खोए हुए पासवर्ड को खोजने के लिए कोई सहायता उपलब्ध नहीं है। कृपया अपने मूडल व्यवस्थापक से संपर्क करें।';
$string['passwordpolicynomatch'] = 'आपका वर्तमान पासवर्ड अब सेट पासवर्ड नीति से मेल नहीं खाता।';
$string['passwordrecovery'] = 'हां, लॉग इन करने में मेरी सहायता करें';
$string['passwordsdiffer'] = 'ये पासवर्ड मिलते नहीं हैं';
$string['passwordsent'] = 'पासवर्ड भेज दिया गया है';
$string['passwordsenttext'] = '<p>आपके पते पर {$a->ईमेल} पर एक ईमेल भेज दी गई है।</p>
   <p><b>कृपया अपने नए पासवर्ड के लिए अपना ईमेल देखें</b></p>
   <p>नया पासवर्ड अपने आप जेनरेट हो गया था, इसलिए आप चाहें तो
   <a href="{$a->लिंक}">इसे याद रखने में आसान चीज़ में बदलें</a>।</p>';
$string['passwordset'] = 'आपका पासवर्ड सेट कर दिया गया है।';
$string['path'] = 'पाथ';
$string['pathnotexists'] = 'पाथ आपके सर्वर में मौजूद नहीं है!';
$string['pathslasherror'] = 'पाथ एक स्लैश के साथ समाप्त नहीं हो सकता !!';
$string['paymentinstant'] = 'भुगतान करने के लिए नीचे दिए गए बटन का उपयोग करें और मिनटों में नामांकित हो जाएं!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> लंबित</small>)';
$string['paymentrequired'] = 'इस कोर्स में प्रवेश के लिए भुगतान की आवश्यकता है।';
$string['payments'] = 'भुगतान';
$string['paymentsorry'] = 'अपने भुगतान के लिए धन्यवाद! दुर्भाग्य से आपका भुगतान अभी तक पूरी तरह से संसाधित नहीं किया गया है, और आप अभी तक "{$a->fullname}" पाठ्यक्रम में प्रवेश करने के लिए पंजीकृत नहीं हैं। कृपया कुछ सेकंड में पाठ्यक्रम को जारी रखने का प्रयास करें, लेकिन यदि आपको समस्या बनी रहती है तो कृपया {$a->शिक्षक} या साइट व्यवस्थापक को सचेत करें';
$string['paymentthanks'] = 'अपने भुगतान के लिए धन्यवाद! अब आप अपने पाठ्यक्रम में नामांकित हैं:<br />"{$a}"';
$string['pendingrequests'] = 'अनुरोध लंबित';
$string['percents'] = '{$a}%';
$string['periodending'] = 'अवधि समाप्त ({$a})';
$string['perpage'] = 'प्रति पृष्ठ';
$string['perpagea'] = 'प्रति पृष्ठ: {$a}';
$string['personal'] = 'व्यक्तिगत';
$string['personalprofile'] = 'व्यक्तिगत प्रोफाइल';
$string['phone'] = 'टेलीफोन';
$string['phone1'] = 'टेलीफोन';
$string['phone2'] = 'मोबाइल नंबर';
$string['phpinfo'] = 'PHP इन्फो';
$string['picture'] = 'तस्वीर';
$string['pictureof'] = '{$a} की तस्वीर';
$string['pictureofuser'] = 'उपयोगकर्ता की तस्वीर';
$string['placeholdertypeorselect'] = 'टाइप करें या चुनें..';
$string['pleaseclose'] = 'कृपया इस विंडो को अब बंद कर दें।';
$string['pleasesearchmore'] = 'कृपया कुछ और खोजें';
$string['pleaseusesearch'] = 'कृपया सर्च का उपयोग करें';
$string['plugin'] = 'प्लग-इन';
$string['pluginarea'] = 'क्षेत्र';
$string['plugincheck'] = 'प्लगइन्स की जाँच करें';
$string['pluginitemid'] = 'विषय आईडी';
$string['pluginmissingfromdisk'] = '{$a->name} (डिस्क से अनुपलब्ध है)';
$string['pluginsetup'] = 'प्लगइन तालिकाओं को सेट कर रहा है';
$string['policyaccept'] = 'मैं समझता हूं और सहमत हूं';
$string['policyagree'] = 'आपको इस साइट का उपयोग करते रहने के लिए इस नीति को मान लेना होगा। क्या आप सहमत हैं?';
$string['policyagreement'] = 'साइट पॉलिसी अनुबंध';
$string['policyagreementclick'] = 'साइट पॉलिसी अनुबंध का लिंक';
$string['popup'] = 'पॉप अप';
$string['popupwindow'] = 'फ़ाइल को नई विंडो में खोलें';
$string['popupwindowname'] = 'पॉप - अप विंडो';
$string['post'] = '';
$string['potentialadmins'] = 'संभाव्य ऍड्मिन्स';
$string['potentialcreators'] = 'संभाव्य कोर्स क्रियेटर';
$string['potentialstudents'] = 'संभाव्य विद्यार्थी';
$string['potentialteachers'] = 'संभाव्य अध्यापक';
$string['poweredbymoodle'] = '<a href="https://moodle.com">मूडल</a> द्वारा संचालित';
$string['preferences'] = 'प्राथमिकताएं';
$string['preferredlanguage'] = 'पसंदीदा भाषा';
$string['preferredtheme'] = 'पसंदीदा थीम';
$string['preprocessingbackupfile'] = 'बैकअप फाइल का पूर्वप्रक्रमण कर रहा है';
$string['preview'] = 'पूर्व दर्शन';
$string['previeworchoose'] = 'थीम का पूर्वावलोकन या चुनाव करें';
$string['previous'] = 'पिछला';
$string['previouslyselectedusers'] = 'पूर्वचयनित उपयोगकर्ता \'{$a}\' से मेल नहीं खा रहे हैं';
$string['previouspage'] = 'पिछला पृष्ठ';
$string['profile'] = 'विवरण';
$string['question'] = 'सवाल';
$string['questionsinthequestionbank'] = 'प्रश्न बैंक में प्रश्न';
$string['readinginfofrombackup'] = 'बैकअप से जानकारी पढ़ना';
$string['readme'] = 'README';
$string['recentactivity'] = 'हाल की गतिविधि';
$string['recentactivityreport'] = 'हाल की गतिविधियों की पूरी रिपोर्ट...';
$string['recipientslist'] = 'प्राप्तकर्ता सूची';
$string['recreatedcategory'] = 'श्रेणी फिर से बनाई गई {$a}';
$string['redirect'] = 'पुन: निर्देशित';
$string['reducesections'] = 'वर्गों की संख्या कम करें';
$string['refresh'] = 'ताज़ा करना';
$string['refreshingevents'] = 'घटनाओं को ताज़ा करना';
$string['registration'] = 'काम का पंजीकरण';
$string['registrationcontact'] = 'जनता से संपर्क करें';
$string['registrationcontactno'] = 'नहीं, मुझे साइट लिस्टिंग में संपर्क फ़ॉर्म नहीं चाहिए';
$string['registrationcontactyes'] = 'हां, मुझे संपर्क करने के लिए भावी मूडलर के लिए एक फॉर्म प्रदान करें';
$string['registrationemail'] = 'ईमेल सूचनाएं';
$string['registrationinfo'] = '<p>This page allows you to register your Moodle site with moodle.org.  Registration is free.
The main benefit of registering is that you will be added to a low-volume mailing list
for important notifications such as security alerts and new releases of Moodle.</p>
<p>By default, your information will be kept private, and will never be sold or passed on to anyone else.  The only
   reason for collecting this information is for support purposes, and to help build up a statistical
   picture of the Moodle community as a whole.</p>
<p>If you choose, you can allow your site name, country and URL to be added to the public list of Moodle Sites.</p>
<p>All new registrations are verified manually before they are added to the list, but once you are added you can update your registration (and your entry on the public list) at any time by resubmitting this form.</p>';
$string['registrationinfotitle'] = 'रजिस्ट्रशन जानकारी';
$string['registrationsend'] = 'रजिस्ट्रेशन की जानकारी moodle.org पर भेजें';
$string['registrationyes'] = 'हां, कृपया मुझे महत्वपूर्ण मुद्दों के बारे में सूचित करें';
$string['reject'] = 'अस्वीकार';
$string['rejectdots'] = 'अस्वीकार...';
$string['reload'] = 'सीमा से अधिक लादना';
$string['remoteappuser'] = 'रिमोट {$a} उपयोगकर्ता';
$string['remove'] = 'निकले';
$string['removeadmin'] = 'ऍड्मिन को निकले';
$string['removecreator'] = 'कोर्स क्रियेटर को निकले';
$string['removestudent'] = 'विद्यार्थी को निकले';
$string['removeteacher'] = 'अध्यापक को निकले';
$string['rename'] = 'नाम बदली करें';
$string['renamefileto'] = '<b>{$a}</b> का नाम बदल कर यह करें';
$string['report'] = 'रिपोर्ट';
$string['reports'] = 'रिपोर्ट';
$string['repositories'] = 'डेटा संग्रह स्थान';
$string['requestcourse'] = 'कोर्स की माँग करें';
$string['requestedby'] = 'द्वारा अनुरोध किया गया';
$string['requestedcourses'] = 'अनुरोधित पाठ्यक्रम';
$string['requestreason'] = 'कोर्स रिक्वेस्ट का कारण';
$string['required'] = 'ज़रूरी हैं';
$string['requirespayment'] = 'इस कोर्स के लिए भुगतान की आवश्यकता है';
$string['reset'] = 'रीसेट';
$string['resetcomponent'] = 'अंग';
$string['resetcourse'] = 'Reset course';
$string['resetinfo'] = 'यह पृष्ठ गतिविधियों और अन्य सेटिंग्स को बनाए रखते हुए, आपको उपयोगकर्ता डेटा का एक कोर्स खाली करने की अनुमति देता है। कृपया सावधान रहें कि नीचे दिए गए आइटम चुनकर और इस पृष्ठ को सबमिट करके आप अपने चुने हुए उपयोगकर्ता डेटा को इस पाठ्यक्रम से हमेशा के लिए हटा देंगे!';
$string['resetnotimplemented'] = 'रीसेट नहीं किया गया';
$string['resetrecordexpired'] = 'आपके द्वारा उपयोग किया गया पासवर्ड रीसेट लिंक {$a} मिनट से अधिक पुराना है और समाप्त हो चुका है। कृपया एक नया पासवर्ड रीसेट करें।';
$string['resetstartdate'] = 'प्रारंभ दिनांक रीसेट करें';
$string['resetstatus'] = 'दर्जा';
$string['resettask'] = 'पाठ';
$string['resettodefaults'] = 'डिफ़ॉल्ट पर पुनः सेट करें';
$string['resortcourses'] = 'पाठ्यक्रम क्रमबद्ध करें';
$string['resource'] = 'संसाधन';
$string['resourcedisplayauto'] = 'स्वचालित';
$string['resourcedisplaydownload'] = 'बल डाउनलोड';
$string['resourcedisplayembed'] = 'एम्बेड';
$string['resourcedisplayframe'] = 'फ्रेम में';
$string['resources'] = 'संसाधने';
$string['restore'] = 'रिस्टोर';
$string['restorecancelled'] = 'रिस्टोर व्यर्थ कर दिया गया हैं';
$string['restoreto'] = 'को रिस्टोर करें';
$string['returningtosite'] = 'क्या आप इस साइट पे वापस आ रहें हैं??';
$string['role'] = 'भूमिका';
$string['rolemappings'] = 'भूमिका प्रतिचित्रण';
$string['roles'] = 'भूमिकाएं';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'RSS के नये लेख की गिनती';
$string['rsserror'] = 'दाता पढ़ने में गलती हो गयी';
$string['save'] = 'सहेजें';
$string['scale'] = 'परत';
$string['scale_link'] = 'grade/scale';
$string['scales'] = 'परतें';
$string['scalescustom'] = 'कस्टम परतें';
$string['scalescustomcreate'] = 'नया परत मिलायें';
$string['scalesstandard'] = 'स्टॅंडर्ड परत';
$string['scalestandard'] = 'स्टॅंडर्ड परतें';
$string['scalestandard_link'] = 'grade/scale';
$string['schedule'] = 'सूची';
$string['screenshot'] = 'स्क्रीनशॉट';
$string['search'] = 'खोज';
$string['searchagain'] = 'फिर खोज';
$string['searchcourses'] = 'पाठ्यक्रम खोजें';
$string['searchresults'] = 'खोज परिणाम';
$string['sec'] = 'सेकेंड';
$string['secondstotime172800'] = 'दो दिन';
$string['secondstotime259200'] = 'टीन दिन';
$string['secondstotime345600'] = 'चार दिन';
$string['secondstotime432000'] = 'पाँच दिन';
$string['secondstotime518400'] = 'छ दिन';
$string['secondstotime604800'] = 'एक हफ़्ता';
$string['secondstotime86400'] = 'एक दिन';
$string['secs'] = 'सेकेंड्स';
$string['section'] = 'अनुभाग';
$string['sections'] = 'अनुभाग';
$string['select'] = 'चुनिए';
$string['selectacountry'] = 'एक देश को चुनिए';
$string['selectall'] = 'सभी को चुनिए';
$string['selectfiltertype'] = 'चुनिए';
$string['selectperiod'] = 'समयावधि चुनिए';
$string['separate'] = 'अलग';
$string['settings'] = 'सेट्टिंग्स';
$string['shortname'] = 'सन्क्षिप्त नाम';
$string['shortnamecourse'] = 'पाठ्यक्रम का संक्षिप्त नाम';
$string['show'] = 'दिखाए';
$string['showactions'] = 'कार्यवाहीया दिखाए';
$string['showadvancededitor'] = 'उन्नत';
$string['showadvancedsettings'] = 'अड्वॅन्स्ड सेट्टिंग्स दिखाए';
$string['showall'] = '{$a} सभी दिखाए';
$string['showallcourses'] = 'सभी कोर्स दिखाए';
$string['showallusers'] = 'सभी यूज़र्स दिखाए';
$string['showblockcourse'] = 'कोर्स की सूची दिखाए जिसमें ब्लॉक हैं';
$string['showgrades'] = 'ग्रेड्स दिखायें';
$string['showlistofcourses'] = 'कोर्स की सूची दिखाए';
$string['showmodulecourse'] = 'कोर्स की सूची दिखाए जिसमे कार्यवाहीया हो';
$string['showonly'] = 'सिर्फ़ दिखाए';
$string['showperpage'] = 'हर पेज पर {$a} दिखाए';
$string['showrecent'] = 'रीसेंट कार्यवाही दिखाए';
$string['showreports'] = 'कार्यवाही रिपोर्ट दिखाए';
$string['showsettings'] = 'सेट्टिंग्स दिखाए';
$string['showtheselogs'] = 'यह लोग्स दिखाए';
$string['since'] = 'जबसे';
$string['site'] = 'साइट';
$string['sitedefault'] = 'साइट डिफ़ॉल्ट';
$string['siteerrors'] = 'साइट त्रुटियाँ (errors)';
$string['sitefiles'] = 'साइट फ़ाइलें';
$string['sitefilesused'] = 'साइट फ़ाइलें जो यह कोर्स में उपयोग किए गये हैं';
$string['sitelogs'] = 'साइट लॉग्स';
$string['sitenews'] = 'साइट समाचार';
$string['sites'] = 'साईट्स';
$string['sitesettings'] = 'साईट सेट्टिंग्स';
$string['siteteachers'] = 'साईट अध्यापक';
$string['size'] = 'आमाप';
$string['sizeb'] = 'बाइट्स';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['someallowguest'] = 'कुछ कोर्स अतिथियों को लॉग-इन करने देते हैं';
$string['someerrorswerefound'] = 'कुछ जानकारी गायब या गलत थी। निम्नलिखित विवरण देखिये:|';
$string['startsignup'] = 'नया ऍकाउन्ट बनाइये';
$string['state'] = 'राज्य/प्रदेश';
$string['statistics'] = 'सांख्यिकी';
$string['statisticsgraph'] = 'सांख्यिकी ग्राफ';
$string['stats'] = 'सांख्यिकी';
$string['statslogins'] = 'लोग-इन्स';
$string['statsreport1'] = 'लोग-इन्स';
$string['statsreportforuser'] = 'के लिए';
$string['statsreportlogins'] = 'लोग-इन्स';
$string['statsuserlogins'] = 'लोग-इन्स';
$string['statsuserwrites'] = 'दर्जे';
$string['statswrites'] = 'दर्जे';
$string['status'] = 'दर्जा';
$string['students'] = 'विद्यार्थिया';
$string['studentsandteachers'] = 'विद्यार्थिया और अध्यपके';
$string['subject'] = 'विषय';
$string['summary'] = 'सन्क्षिप्त विवरण';
$string['teachers'] = 'अध्यपके';
$string['thanks'] = 'धन्यवाद';
$string['theme'] = 'थीम';
$string['themes'] = 'थीम्स';
$string['time'] = 'समय';
$string['timezone'] = 'समय-अंचल';
$string['to'] = 'को';
$string['todate'] = 'को';
$string['today'] = 'आज';
$string['todaylogs'] = 'आज के लॉग्स';
$string['toeveryone'] = 'सबको';
$string['toomanybounces'] = 'उस ई-मेल पते से बहुत अधिक सन्देश बाउन्स हो चुके हैं। आपको वह ई-मेल पता <strong>बदलना होगा</strong>।';
$string['toomanytoshow'] = 'इतने अधिक यूज़र हैं कि उन्हें दिखाया नहीं जा सकता।';
$string['toonly'] = 'केवल {$a} को';
$string['top'] = 'ऊपर';
$string['topic'] = 'विषय';
$string['topichide'] = '{$a} को यह विषय न दिखायें';
$string['topicoutline'] = 'विषयवस्तु';
$string['topicshow'] = '{$a} को यह विषय दिखायें';
$string['torecipient'] = 'को';
$string['total'] = 'कुल';
$string['trackforumsyes'] = 'जी हां, मेरे लिये नई पोस्ट को हाइलाइट करें';
$string['turneditingoff'] = 'सम्पादन ऑफ़';
$string['turneditingon'] = 'सम्पादन ऑन';
$string['unfinished'] = 'अपूर्ण';
$string['unknowncategory'] = 'अन्जान वर्ग';
$string['unlimited'] = 'असीमित';
$string['unpacking'] = '{$a} को अन्पैक किया जा रहा है';
$string['unsafepassword'] = 'असुरक्शित पास्वर्ड - कुछ और ट्राय करें';
$string['unzip'] = 'अनज़िप';
$string['unzippingbackup'] = 'बॅकप अनज़िप किया जा रहा है';
$string['up'] = 'उपरे';
$string['update'] = 'सुधार';
$string['updated'] = '{$a} सुधार दिया गया है';
$string['upload'] = 'अपलोड';
$string['uploadafile'] = 'फ़ाइल अपलोड करें';
$string['uploadedfile'] = 'फ़ाइल सफलतापूर्वक अपलोड की गई';
$string['uploadedfileto'] = '{$a} को {$a} में अपलोड किया गया';
$string['uploadfilelog'] = '{$a} फ़ाइल के लिए अपलोड लॉग';
$string['uploadformlimit'] = 'अपलोड की गई फ़ाइल फ़ॉर्म में दी गयी सीमा से अधिक है';
$string['uploadlabel'] = 'शीर्षक:';
$string['uploadnotallowed'] = 'अपलोड की अनुमति नहीं है';
$string['uploadpartialfile'] = 'फ़ाइल का कुछ भाग ही अपलोड किया गया';
$string['uploadserverlimit'] = 'अपलोड की गई फ़ाइल सर्वर द्वारा सॅट की गयी सीमा से अधिक है';
$string['uploadthisfile'] = 'इस फ़ाइल को अपलोड करें';
$string['url'] = 'URL';
$string['used'] = 'प्रयुक्त';
$string['usedinnplaces'] = '{$a} स्थानों पर उपयोग किया गया';
$string['user'] = 'उपयोगकर्ता';
$string['useraccount'] = 'यूजर अकाउंट';
$string['useractivity'] = 'गतिविधि';
$string['userconfirmed'] = 'पुष्टि की गई {$a}';
$string['userdata'] = 'उपयोगकर्ता डेटा';
$string['userdeleted'] = 'यह यूज़र ऍकाउन्ट डिलीट कर दिया गया है';
$string['userdescription'] = 'विवरण';
$string['userdescription_help'] = 'यह बॉक्स आपको अपने बारे में कुछ दर्ज करने में सक्षम बनाता है जिसे बाद में दूसरों के देखने के लिए आपके प्रोफ़ाइल पृष्ठ पर प्रदर्शित किया जाएगा।';
$string['userdetails'] = 'उपयोगकर्ता का विवरण';
$string['userfiles'] = 'उपयोगकर्ता फ़ाइलें';
$string['userlist'] = 'उपयोगकर्ता सूची';
$string['usermenu'] = 'उपयोगकर्ता विकल्प सूची';
$string['username'] = 'यूज़रनेम';
$string['usernameemail'] = 'यूज़रनेम / ईमेल';
$string['usernameemailmatch'] = 'यूज़रनेम / ईमेल एक ही उपयोगकर्ता से संबंधित नहीं है';
$string['usernameexists'] = 'यह यूज़रनेम पहले से मौजूद है, दूसरा चुनें';
$string['usernamelowercase'] = 'केवल छोटे अक्षर ही मान्य';
$string['usernamenotfound'] = 'डेटाबेस में यूज़रनेम नहीं मिला';
$string['usernameoremail'] = 'यूज़रनेम या ईमेल दर्ज करें';
$string['usernotconfirmed'] = '{$a} की पुष्टि नहीं कर सका';
$string['userpic'] = 'यूज़र चित्र';
$string['userpreferences'] = 'उपयोगकर्ता वरीयताएं';
$string['users'] = 'उपयोगकर्ता';
$string['userselectorautoselectunique'] = 'यदि केवल एक ही उपयोगकर्ता खोज से मेल खाता है, तो उसे स्वचालित रूप से चुनें';
$string['userselectorpreserveselected'] = 'चयनित उपयोगकर्ता रखें, भले ही वे अब खोज से मेल न खाते हों';
$string['userselectorsearchanywhere'] = 'प्रदर्शित फ़ील्ड में कहीं भी खोज पाठ से मिलान करें';
$string['usersnew'] = 'नए उपयोगकर्ता';
$string['usersnoaccesssince'] = 'से अधिक के लिए निष्क्रिय';
$string['userswithfiles'] = 'फ़ाइलों के साथ उपयोगकर्ता';
$string['useruploadtype'] = 'उपयोगकर्ता अपलोड प्रकार: {$a}';
$string['userzones'] = 'उपयोगकर्ता क्षेत्र';
$string['usetheme'] = 'लेआउट का उपयोग करें';
$string['usingexistingcourse'] = 'मौजूदा पाठ्यक्रम का उपयोग करके';
$string['valuealreadyused'] = 'इस मान का पहले ही उपयोग किया जा चुका है।';
$string['version'] = 'संस्करण';
$string['view'] = 'देखें';
$string['viewallcourses'] = 'सभी पाठ्यक्रम देखें';
$string['viewallcoursescategories'] = 'सभी पाठ्यक्रम और श्रेणियां देखें';
$string['viewallsubcategories'] = 'सभी उपश्रेणियाँ देखें';
$string['viewfileinpopup'] = 'फाइल को एक पॉप अप विंडो में देखें';
$string['viewing'] = 'देख रहे है:';
$string['viewmore'] = 'और देखें';
$string['viewprofile'] = 'प्रोफ़ाइल देखें';
$string['views'] = 'दृश्य';
$string['viewsolution'] = 'दृश्य उपाय';
$string['visible'] = 'dikhaye';
$string['visible_help'] = 'यह सेटिंग निर्धारित करता है कि पाठ्यक्रम पाठ्यक्रमों की सूची में प्रकट होगा अथवा नहीं| शिक्षकों और प्रशासकों के अलावा, उपयोगकर्ताओं को पाठ्यक्रम में प्रवेश की अनुमति नहीं होगी |';
$string['visibletostudents'] = '{$a} को दिखाए';
$string['warning'] = 'चेतावनी';
$string['warningdeleteresource'] = '';
$string['webpage'] = 'वेब पेज';
$string['week'] = 'सप्ताह';
$string['weekhide'] = 'यह हफ़्ता {$a} से छिपाए';
$string['weeklyoutline'] = 'साप्ताहिक नक्षा';
$string['weeks'] = 'सप्ताह';
$string['weekshow'] = 'यह हफ़्ता {$a} को दिखाए';
$string['welcometocourse'] = '{$a} में आपका स्वागत है!';
$string['welcometocoursetext'] = '{$a->coursename} में आपका स्वागत है!

अगर आपने अभी तक अपना प्रोफ़ाइल पेज सम्पादित नहीं किया है, तो उसे सम्पादित कीजिए ताकि हम आपके बारे में अधिक जान सकें:

{$a->profileurl}';
$string['whatforlink'] = 'आप इस लिंक के साथ क्या करना चाहते हैं?';
$string['whatforpage'] = 'आप पाठ के साथ क्या करना चाहते हैं ?';
$string['whattocallzip'] = 'आप ज़िप फ़ाइल का नाम क्या रखना चाहते हैं?';
$string['whattodo'] = 'क्या करें';
$string['windowclosing'] = 'इस विंडो को स्वचालित रूप से बंद हो जाना चाहिए । यदि नहीं, तो अब इसे बंद कर दीजिये।';
$string['withchosenfiles'] = 'चुनी गई फ़ाइलों के साथ';
$string['withdisablednote'] = '{$a} (निष्क्रिय)';
$string['withoutuserdata'] = 'यूज़र डेटा के बिना';
$string['withselectedusers'] = 'चुनिंदा उपयोगकर्ता के साथ...';
$string['withuserdata'] = 'यूज़र डेटा के साथ';
$string['wordforstudent'] = 'विद्यार्थी के लिए आपका शब्द';
$string['wordforstudenteg'] = 'उदाहरण के लिए: विद्यार्थी, छात्र, स्टुडॅन्ट, सदस्य, प्रतिभागी
आदि';
$string['wordforstudents'] = 'विद्यार्थियों के लिए आपका शब्द';
$string['wordforstudentseg'] = 'विद्यार्थी, छात्र, स्टुडॅन्ट्स, सदस्य, प्रतिभागी आदि';
$string['wordforteacher'] = 'टीचर के लिए आपका शब्द';
$string['wordforteachereg'] = 'उदाहरण के लिए: टीचर, गुरु, आचार्य, शिक्षक, शिक्षिका, अध्यापक,
अध्यापिका, प्रोफ़ेसर आदि';
$string['wordforteachers'] = 'टीचर्स के लिए आपका शब्द';
$string['wordforteacherseg'] = 'उदाहरण के लिए: टीचर्स, गुरु, आचार्यगण, शिक्षकगण, अध्यापकगण, प्रोफ़ेसर्स आदि';
$string['writingblogsinfo'] = 'ब्लॉगों की जानकारी लिखी जा रही है';
$string['writingcategoriesandquestions'] = 'वर्ग व प्रश्न';
$string['writingcoursedata'] = 'कोर्स डेटा लिखा जा रहा है';
$string['writingeventsinfo'] = 'ईवॅन्ट्स जानकारी लिखी जा रही है';
$string['writinggeneralinfo'] = 'आम जानकारी लिखी जा रही है';
$string['writinggradebookinfo'] = 'ग्रेड-बुक जानकारी लिखी जा रही है';
$string['writinggroupingsgroupsinfo'] = 'ग्रूप और ग्रूपिंग की जानकारी लिखी जा रही है';
$string['writinggroupingsinfo'] = 'ग्रूपिंग्स जानकारी लिखी जा रही है';
$string['writinggroupsinfo'] = 'ग्रुप जानकारी लिखी जा रही है';
$string['writingheader'] = 'header लिखा जा रहा है';
$string['writingloginfo'] = 'लॉग जानकारी लिखी जा रही है';
$string['writingmessagesinfo'] = 'सन्देश जानकारी लिखी जा रही है';
$string['writingmoduleinfo'] = 'मॉड्यूल जानकारी लिखी जा रही है';
$string['writingscalesinfo'] = 'scales जानकारी लिखी जा रही है';
$string['writinguserinfo'] = 'यूज़र जानकारी लिखी जा रही है';
$string['wrongpassword'] = 'इस यूज़रनेम के लिये गलत पासवर्ड';
$string['year'] = 'साल';
$string['years'] = 'सालो';
$string['yes'] = 'हाँ';
$string['youareabouttocreatezip'] = 'आप एक ज़िप फ़ाइल बनाने जा रहें हैं, जिसके अन्दर यह सब
होगा:';
$string['youaregoingtorestorefrom'] = 'इस के लिए आप restore प्रक्रिया शुरु करने जा रहें हैं:';
$string['youneedtoenrol'] = 'यह कार्यवाही करने के लिए आप को एन्रॉल करना होगा';
$string['yourlastlogin'] = 'आपकी पिछली लॉगिन थी';
$string['yourself'] = 'आप';
$string['yourteacher'] = 'आपका {$a}';
$string['yourwordforx'] = '\'{$a}\' के लिए आपका शब्द';
$string['zippingbackup'] = 'बैक-अप को ज़िप किया जा रहा है';
