<?php

class block_jeet_image_cards_edit_form extends block_edit_form {

    protected function specific_definition($mform) {

        global $CFG;

        $cardsnumber = 4;
        if(isset($this->block->config->cards_number)){
            $cardsnumber = $this->block->config->cards_number;
        }

        // Section header title according to language file.
        $mform->addElement('header', 'config_header', get_string('blocksettings', 'block'));

        // Title
        $mform->addElement('text', 'config_title', get_string('config_title', 'theme_edash'));
        $mform->setDefault('config_title', 'Card section Title');
        $mform->setType('config_title', PARAM_RAW);

        // Top Discription
        $mform->addElement('text', 'config_topdiscription', get_string('topdiscription', 'block_jeet_image_cards'));
        $mform->setDefault('config_topdiscription', 'Top discription');
        $mform->setType('config_topdiscription', PARAM_TEXT);

        // Bottom Discription
        $mform->addElement('text', 'config_bottomdiscription', get_string('bottomdiscription', 'block_jeet_image_cards'));
        $mform->setDefault('config_bottomdiscription', 'Bottom discription');
        $mform->setType('config_bottomdiscription', PARAM_TEXT);

        $cardsrange = array(
            1 => '1',
            2 => '2',
            3 => '3',
            4 => '4',
            5 => '5',
            6 => '6',
            7 => '7',
            8 => '8',
            9 => '9',
            10 => '10',
            11 => '11',
            12 => '12',
            13 => '13',
            14 => '14',
            15 => '15',
            16 => '16',
            17 => '17',
            18 => '18',
            19 => '19',
            20 => '20',
            21 => '21',
            22 => '22',
            23 => '23',
            24 => '24',
            25 => '25',
            26 => '26',
            27 => '27',
            28 => '28',
            29 => '29',
            30 => '30',
        );

        $mform->addElement('select', 'config_cards_number', get_string('config_items', 'theme_edash'), $cardsrange);
        $mform->setDefault('config_cards_number', 4);

        for($i = 1; $i <= $cardsnumber; $i++) {
            $mform->addElement('header', 'config_edash_item' . $i , get_string('config_item', 'theme_edash') . $i);

            // Image URL
            $mform->addElement('static', 'config_image_doc' . $i, '<b><a style="color: var(--primaryColor)" href="https://docs.envytheme.com/docs/edash-moodle-theme-documentation/faqs/how-to-get-the-image-url/" target="_blank">Doc link: How to make Image URL?</a></b>');

            $mform->addElement('text', 'config_img' . $i, 'Icon Image' . $i);
            $mform->setType('config_img' . $i, PARAM_TEXT);

            // Title
            $mform->addElement('text', 'config_cards_title' . $i, get_string('config_title', 'theme_edash', $i));
            $mform->setDefault('config_cards_title' . $i, 'Card Title');
            $mform->setType('config_cards_title' . $i, PARAM_TEXT);

            // Sub Title
            $mform->addElement('text', 'config_cards_subtitle' . $i, get_string('config_subtitle', 'theme_edash', $i));
            $mform->setDefault('config_cards_subtitle' . $i, 'Card subtitle');
            $mform->setType('config_cards_subtitle' . $i, PARAM_TEXT);

            // Card Content
            $mform->addElement('textarea', 'config_cards_content' . $i, get_string('config_content', 'theme_edash', $i));
            $mform->setDefault('config_cards_content' . $i, 'Card Discription');
            $mform->setType('config_cards_content' . $i, PARAM_RAW);

        }
    }
}
