<?php

require_once '../../config.php';
require_once $CFG->libdir . '/tablelib.php';

require_login();
$context = context_system::instance();
require_capability( 'local/schoolinfo:manageschoolinfos', $context );

global $DB, $PAGE, $OUTPUT;

// Page setup.
$PAGE->set_url( new moodle_url( '/local/schoolinfo/view.php' ) );
$PAGE->set_context( context_system::instance() );
$PAGE->set_title( get_string( 'manage_schoolinfos', 'local_schoolinfo' ) );
$PAGE->set_heading( get_string( 'manage_schoolinfos', 'local_schoolinfo' ) );
$PAGE->requires->js_call_amd( 'local_schoolinfo/confirm' );


// Capture the search query.
$query = optional_param( 'query', '', PARAM_RAW_TRIMMED );

// Render the search form.
$PAGE->add_header_action(
	$OUTPUT->render_from_template(
		'core_admin/header_search_input',
		array(
			'action' => new moodle_url( '/local/schoolinfo/view.php' ),
			'query'  => $query,
		)
	)
);

echo $OUTPUT->header();

$editurl = new moodle_url( '/local/schoolinfo/edit.php' ); // Assign your edit URL
echo '<input type="button" class="btn btn-primary mb-4 udise-btn" value="Add UDISE Code" onclick="location.href=\'' . $editurl . '\'">';

// Initialize the table.
$table = new flexible_table( 'unique_table_id' );
$table->define_columns( array( 'udisecode_column', 'schoolname_column', 'schoolname_board', 'schoolname_district', 'schoolpincode_column', 'edit_column', 'delete_column' ) );
$table->define_headers( array( get_string( 'udisecode_column', 'local_schoolinfo' ), get_string( 'schoolname_column', 'local_schoolinfo' ), get_string( 'schoolboard_column', 'local_schoolinfo' ), get_string( 'schooldistrict_column', 'local_schoolinfo' ), get_string( 'schoolpincode_column', 'local_schoolinfo' ), get_string( 'edit_column', 'local_schoolinfo' ), get_string( 'delete_column', 'local_schoolinfo' ) ) );
$table->define_baseurl( $PAGE->url );
// $table->sortable(true, 'udisecode_column');
// $table->no_sorting( 'schoolpincode_column' );
$table->pageable( true );
$table->set_attribute( 'cellspacing', '0' );
$table->set_attribute( 'id', 'unique_table_id' );
$table->set_attribute( 'class', 'generaltable generalbox' );
$table->setup();

$perpage = 25;
$page    = optional_param( 'page', 0, PARAM_INT );
$start   = $page * $perpage;

// Modify the SQL query based on the search query.
$conditions = array();
$params     = array();

if ( ! empty( $query ) ) {
	$conditions[]     = $DB->sql_like( 'schooludise', ':query', false );
	$conditions[]     = $DB->sql_like( 'schoolname', ':query2', false );
	$conditions[]     = $DB->sql_like( 'schoolpincode', ':query3', false );
	$params['query']  = "%$query%";
	$params['query2'] = "%$query%";
	$params['query3'] = "%$query%";
}
$where = ( ! empty( $conditions ) ) ? 'WHERE (' . implode( ' OR ', $conditions ) . ')' : '';

// Count the total records.
$totalcount = $DB->count_records_sql( 'SELECT COUNT(*) FROM {local_schoolinfo} ' . $where, $params );

// Fetch the records.
$sql     = 'SELECT * FROM {local_schoolinfo} ' . $where . ' ORDER BY schooludise ASC';
$records = $DB->get_records_sql( $sql, $params, $start, $perpage );

foreach ( $records as $record ) {
	$data   = array();
	$data[] = $record->schooludise;
	$data[] = $record->schoolname;
	$data[] = $record->schoolboard;
	$data[] = $record->schooldistrict;
	$data[] = $record->schoolpincode;
	$data[] = '<input type="button" class="btn btn-primary" value="Edit" onclick="location.href=\'' . $editurl . '?schoolinfoid=' . $record->id . '\'">';
	$data[] = '<input type="button" class="local_schoolinfoid' . $record->id . ' btn btn-danger local_schoolinfo_delete_button" value="Delete">';
	$table->add_data( $data );
}

$table->print_html();

echo $OUTPUT->paging_bar( $totalcount, $page, $perpage, $PAGE->url );

echo $OUTPUT->footer();
