<?php

$functions = array(
	'local_signupvalidations_get_districts'  => array(
		'classname'     => 'local_signupvalidations_external',
		'methodname'    => 'get_districts',
		'classpath'     => 'local/signupvalidations/externallib.php',
		'description'   => 'Returns the list of districts based on the state board.',
		'type'          => 'read',
		'ajax'          => true, // Important for AJAX calls
		'loginrequired' => false, // Allow access without login.
		'services'      => array( MOODLE_OFFICIAL_MOBILE_SERVICE ), // Or any custom service
	),
	'local_signupvalidations_get_schools'    => array(
		'classname'     => 'local_signupvalidations_schools_external',
		'methodname'    => 'get_schools',
		'classpath'     => 'local/signupvalidations/externallib.php',
		'description'   => 'Get schools by pincode',
		'type'          => 'read',
		'loginrequired' => false, // Allow access without login.
		'ajax'          => true,
		'services'      => array( MOODLE_OFFICIAL_MOBILE_SERVICE ), // Or any custom service
	),
	'local_signupvalidations_search_records' => array(
		'classname'     => 'local_signupvalidations_search_records_external',
		'methodname'    => 'search_records',
		'classpath'     => 'local/signupvalidations/externallib.php',
		'description'   => 'Search records based on pincode, school, or UDISE code',
		'type'          => 'read',
		'services'      => array( MOODLE_OFFICIAL_MOBILE_SERVICE ), // Or any custom service
		'ajax'          => true,  // Make this available via AJAX
		'loginrequired' => false, // Allow access without login.
	),
);

$services = array(
	'Moodle Mobile web service' => array(
		'functions'          => array( 'local_signupvalidations_get_districts', 'local_signupvalidations_get_schools', 'local_signupvalidations_search_records' ),
		'requiredcapability' => '',
		'restrictedusers'    => 0,
		'enabled'            => 1,
	),
);
