jQuery(document).ready(function () {

    jQuery('#syllabusboard').change(function() {
        jQuery('.dynamic-div').hide();
        var selectedValue = jQuery(this).val();
        jQuery('#' + selectedValue).show();
    });

   jQuery(".footer-area .single-footer-widget h3 a.autolink").each(function() {
        let text = jQuery(this).text().trim();
        if (text === "About Us") {
            jQuery(this).replaceWith('About Us');
        } else if (text === "Contact Us") {
            jQuery(this).replaceWith('Contact Us');
        }
    });
  
// Add password show/hide button for pages like Login & Forgot Password
    if ($('#page-login-signup').length || $('#page-login-forgot_password').length) {
        // Create the HTML structure for the toggle button
        const toggleButtonHtml = `
        <div class="input-group-append togglePassword-wrapper">
            <button class="toggle-sensitive-btn btn btn-secondary" type="button" aria-label="Toggle sensitive">
                <i class="icon fa fa-eye fa-fw" aria-hidden="true"></i>
            </button>
        </div>
        `;


        const passwordFields = ['#id_password', '#id_password2']; // List of password field IDs

        passwordFields.forEach(function (fieldId) {
            const passwordField = $(fieldId);

            // Insert the HTML after each password field
            if (passwordField.length) {
                passwordField.after(toggleButtonHtml);

                // Attach the toggle functionality to the button
                passwordField.next('.togglePassword-wrapper').find('.toggle-sensitive-btn').on('click', function () {
                    // Toggle the type attribute
                    const type = passwordField.attr('type') === 'password' ? 'text' : 'password';
                    passwordField.attr('type', type);

                    // Toggle the eye icon
                    $(this).find('i').toggleClass('fa-eye fa-eye-slash');
                });
            }
        });
    }



	/*  
    // Add password show/hode btn for Login & Forgot password page.
    if (jQuery('#page-login-signup').length || jQuery('#page-login-forgot_password').length) {
       
	    let togglePasswordCallback = () => {
       
	// Create the HTML structure for the toggle button
    const toggleButtonHtml = `
<div class="input-group-append" id="togglePassword-wrapper">
    <button class="toggle-sensitive-btn btn btn-secondary" type="button" aria-label="Toggle sensitive" id="togglePassword">
        <i class="icon fa fa-eye fa-fw" aria-hidden="true"></i>
    </button>
</div>
`;

		    // Insert the HTML after the password field
            jQuery('body#page-login-signup #id_password, body#page-login-forgot_password #id_password').after(toggleButtonHtml);

            const togglePassword = document.querySelector('#togglePassword');
            const passwordField = document.querySelector('#id_password');

            togglePassword.addEventListener('click', function (e) {
                // Toggle the type attribute
                const type = passwordField.getAttribute('type') === 'password' ? 'text' : 'password';
                passwordField.setAttribute('type', type);

                // Toggle the eye icon
                this.querySelector('i').classList.toggle('fa-eye');
                this.querySelector('i').classList.toggle('fa-eye-slash');
            });
        }

        togglePasswordCallback();
    }

*/
    // Adding "*" for Search school.
    var requiredFieldHtml = '<span class="req" style=""><i class="icon fa fa-circle-exclamation text-danger fa-fw" title="Required field" role="img" aria-label="Required field"></i></span>';

    // Append the HTML to the target element
    jQuery('#fitem_id_schoolslist .col-form-label .form-label-addon').append(requiredFieldHtml);
    

    // user edit page.
    if (jQuery("body#page-user-edit").length) {
        // jQuery("fieldset#id_moodle_additional_names").remove();

        let roleSelection = jQuery("div#fitem_id_profile_field_RoleSelection")
        let role = roleSelection.find("div.felement").text().trim();

        if ("Student" === role) {
            jQuery("div#fitem_id_profile_field_employeecode").remove();
        } else if ("Teacher" === role) {
            jQuery("div#fitem_id_profile_field_guardiansname").remove();
            jQuery("div#fitem_id_profile_field_guardiansemailid").remove();
        }
    }

    // Set text field value when option changes
    jQuery('.signupform input#id_submitbutton').on('click', function () {
        var id_schoolslist = jQuery("select#id_schoolslist").val(); // Get selected value
        jQuery('[name="schoolrecordid"]').val(id_schoolslist);
    });
    // User-profile page.
    if (jQuery("body#page-user-profile").length) {

        let isStudent, isTeacher = false
        jQuery("#page-user-profile .node_category li").each(function (idx, li) {
            let nodeCategoryLI = jQuery(li).find("dl dt").text().trim();
            if ("Role" === nodeCategoryLI) {
                let profileRole = jQuery(li).find("dl dd").text().trim();
                if ("Student" === profileRole) {
                    isStudent = true;
                } else if ("Teacher" === profileRole) {
                    isTeacher = true;
                }
            }

            if (true === isStudent) {
                if ("Employee Code" === nodeCategoryLI) {
                    jQuery(this).remove();
                }
            } else if (true === isTeacher) {
                if (("Guardian's Name" === nodeCategoryLI) || ("Guardian's Email Id" === nodeCategoryLI)) {
                    jQuery(this).remove();
                }
            }
        });
    }

  // Add the +91 prefix input field before the mobile number field
    jQuery('<input type="text" class="mobileno-prefix" value="+91" readonly>').insertBefore('input#id_profile_field_mobilenumber');
    // Set the max length of the mobile number input field to 10 characters
    jQuery('#id_profile_field_mobilenumber').attr('maxlength', '10');

	// Mobile number validation.
jQuery('input#id_profile_field_mobilenumber, input#id_profile_field_pincode').on('input', function () {
    var value = jQuery(this).val();

    if (value == '') {
        jQuery(this).removeClass('is-invalid');
    } else if (!/^\d+$/.test(value)) {
        // Remove any non-numeric characters
        this.value = this.value.replace(/[^0-9]/g, '');
        jQuery(this).addClass('is-invalid');
        jQuery(this).siblings().text('error');
        jQuery(this).siblings().text('- Only numbers are allowed');
        return false;
    } else if (value.charAt(0) === '0') {
        // If the first digit is 0, clear the input and show an error
        this.value = ''; // Clear the input field
        jQuery(this).addClass('is-invalid');
        jQuery(this).siblings().text('error');
        jQuery(this).siblings().text('- Mobile number should not start with 0');
        return false;
    } else {
        jQuery(this).removeClass('is-invalid');
        jQuery(this).siblings().text(''); // Clear any error message
    }
});

    jQuery('input#id_profile_field_employee_id').on('input', function () {
        var value = jQuery(this).val();

        if (value === '') {
            jQuery(this).removeClass('is-invalid');
        } else if (!/^\d+$/.test(value)) {
            // Remove any non-numeric characters
            this.value = this.value.replace(/[^0-9]/g, '');
            jQuery(this).addClass('is-invalid');
            jQuery(this).siblings().text('error');
            jQuery(this).siblings().text('- Only numbers are allowed');
            return false;
        } else {
            jQuery(this).removeClass('is-invalid');
            jQuery(this).siblings().text(''); // Clear any error message
        }
    });

/*
    jQuery('input#id_profile_field_mobilenumber, input#id_profile_field_pincode').on('input', function () {
        var value = jQuery(this).val();
        if (!/^\d+$/.test(value)) {
            // Remove any non-numeric characters
            this.value = this.value.replace(/[^0-9]/g, '');
            jQuery(this).addClass('error');
            jQuery(this).siblings('.error-message').remove();
            jQuery(this).after('<span style="font-size: 0.875em;color: #ca3120;" class="error-message">- Only numbers are allowed.</span>');
            return false;
        } else {
            jQuery(this).removeClass('error');
            jQuery(this).siblings('.error-message').remove();
        }
    });
*/

/*
    if (jQuery("#id_profile_field_RoleSelection").length) {

        // to change role based fields.
        var roleSelection = document.querySelector('#id_profile_field_RoleSelection'),
            studentInput = document.querySelector('.student-button');
        teacherInput = document.querySelector('.teacher-button');
        parentInput = document.querySelector('.parent-button');
        roleSelection.addEventListener('change', function () {
            // alert('changed');
        });
        studentInput.addEventListener('click', function () {
            roleSelection.value = "Student";
            roleSelection.dispatchEvent(new Event('change'));
            jQuery('input#id_profile_field_dob_enabled').prop('checked', true);
        });
        teacherInput.addEventListener('click', function () {
            roleSelection.value = "Teacher";
            roleSelection.dispatchEvent(new Event('change'));
        });
        parentInput.addEventListener('click', function () {
            roleSelection.value = "Parent";
            roleSelection.dispatchEvent(new Event('change'));
        });


        // to change role based fields.
        var dob_checkbox = document.querySelector('input#id_profile_field_dob_enabled');
        studentInput.addEventListener('click', function () {
            dob_checkbox.checked = true;
            dob_checkbox.dispatchEvent(new Event('change'));
        });
    }
    // to add the active class to the clicked button for role buttons.
    jQuery(".role-button").on("click", function () {
        // Remove the active class from all buttons
        jQuery(".role-button").removeClass("active");

        // Add the active class to the clicked button
        jQuery(this).addClass("active");
    });
	*/
});

/*
jQuery(document).on("input", "div#fitem_id_schoolslist .form-autocomplete-input>input", function () {
    let query = jQuery(this).val();
    if (query.length >= 2) {

        $.ajax({
            url: M.cfg.wwwroot + '/webservice/rest/server.php',
            type: 'GET',
            data: {
                // wstoken: M.cfg.ws_token, // Your web service token
                wstoken: "697b9191da002c8575b6ae740f381cf2", // Your web service token
                wsfunction: 'local_signupvalidations_search_records',
                moodlewsrestformat: 'json',
                query: query
            },
            success: function (response) {

                jQuery('#id_schoolslist').empty();
                jQuery('div#fitem_id_schoolslist ul.form-autocomplete-suggestions').empty();
                if (response.length) {
                    $.each(response, function (index, option) {
                        jQuery('#id_schoolslist').append(jQuery('<option>', {
                            value: option.id,
                            text: option.schooludise + " - " + option.schoolname + " - " + option.schoolpincode
                        }));
                    });
                    // Append the new suggestions to the suggestions list
                    response.forEach(function (option) {
                        jQuery('div#fitem_id_schoolslist ul.form-autocomplete-suggestions').append('<li role="option" data-value="' + option.id + '" class="">' + option.schooludise + " - " + option.schoolname + " - " + option.schoolpincode + '</li>');
                    });
                } else {
                    jQuery('div#fitem_id_schoolslist ul.form-autocomplete-suggestions').append('No School Record found');
                }
                jQuery('#id_schoolslist').change();

            },
            error: function (error) {
                alert("AJAX error:", error);
            }
        });
    }
});

*/

function areAllFieldsEmpty(fieldsArray) {
    let allFieldsEmpty = true; // Assume all fields are empty

    // Loop through each field ID in the array
    $.each(fieldsArray, function (index, fieldId) {
        // Get the value of the field by its ID
        let fieldValue = $.trim($('#' + fieldId).val());

        // If any field is not empty, set flag to false and break the loop
        if (fieldValue !== "") {
            allFieldsEmpty = false;
            return false; // Break out of the loop
        }
    });

    // Return true if all fields are empty, otherwise false
    return allFieldsEmpty;
}
let checkAllFieldsEmpty = () => {
    const signupFormFieldsId = [
        "id_username", "id_password", "id_email", "id_email2",
        "id_firstname", "id_lastname", "id_profile_field_mobilenumber",
        "id_profile_field_guardiansemailid", "id_profile_field_staticboard",
        "id_profile_field_medium", "id_profile_field_standard"
    ];

    // Usage example
    if (areAllFieldsEmpty(signupFormFieldsId)) {

        // Handle case where all fields are empty
        sessionStorage.removeItem("schoolslistsearchquery");
        sessionStorage.removeItem("selectedSchoolId");

    }
}


let getschoollists = (query) => {
  
    let stateboard = $('#id_profile_field_staticboard').val();
    let roleSelected = $("#id_profile_field_RoleSelection").val();

    if ('Teacher' == roleSelected) {
        stateboard = '';
    }
    if (('Student' == roleSelected) && ('' == stateboard)) {
        alert("Please select current education board");
        document.getElementById('id_profile_field_staticboard').focus();
        return;
    }

    if (query.length) {
        $.ajax({
            url: M.cfg.wwwroot + '/webservice/rest/server.php',
            type: 'GET',
            data: {
                // wstoken: M.cfg.ws_token, // Your web service token
                wstoken: "697b9191da002c8575b6ae740f381cf2", // Your web service token
                wsfunction: 'local_signupvalidations_search_records',
                moodlewsrestformat: 'json',
                query: query,
                stateboard: stateboard
            },
            success: function (response) {
                jQuery('#id_schoolslist').empty();
                jQuery('div#fitem_id_schoolslist ul.form-autocomplete-suggestions').empty();
                if (response.length) {
                    let selectedSchoolId = sessionStorage.getItem("selectedSchoolId");
                    $.each(response, function (index, option) {
                        let is_selected = false;
                        if (selectedSchoolId == option.id) {
                            is_selected = true;
                        }
                        jQuery('#id_schoolslist').append(jQuery('<option>', {
                            value: option.id,
                            text: option.schooludise + " - " + option.schoolname + " - " + option.schoolpincode,
                            selected: is_selected,
                        }));
                    });
                    // Append the new suggestions to the suggestions list
                    response.forEach(function (option) {
                        let is_selected = false;
                        if (selectedSchoolId == option.id) {
                            is_selected = true;
                        }
                        jQuery('div#fitem_id_schoolslist ul.form-autocomplete-suggestions').append('<li role="option" data-value="' + option.id + '" class="" aria-selected="' + is_selected + '">' + option.schooludise + " - " + option.schoolname + " - " + option.schoolpincode + '</li>');
                    });
                } else {
                    jQuery('div#fitem_id_schoolslist ul.form-autocomplete-suggestions').append('No School Record found');
                }
                jQuery('#id_schoolslist').change();

            },
            error: function (error) {
                alert("AJAX error:", error);
            }
        });
    }else{
	jQuery('div#fitem_id_schoolslist ul.form-autocomplete-suggestions').empty();
    }
};


jQuery(document).on("input", "div#fitem_id_schoolslist .form-autocomplete-input>input", function () {
    let query = jQuery(this).val();
    sessionStorage.setItem('schoolslistsearchquery', query);
    getschoollists(query);
});


let setselectedschoollists = () => {
    // Check if there's a saved School Query String in local storage
    let selectedschoolquery = sessionStorage.getItem('schoolslistsearchquery');

    if (null != selectedschoolquery) {
        getschoollists(selectedschoolquery);
    }
}
// Check if an element with id="page-login-signup" exists
if ($('#page-login-signup').length) {

    checkAllFieldsEmpty(); // Call this function initially to remove sessionStorage, If all field values are empty.
    setselectedschoollists();

    //Convert uppercase letters to lower case in the username input field on registration form
    $('#id_username').on('input', function() {
       // Get the current value, convert it to lowercase, and set it back to the input field
      $(this).val($(this).val().toLowerCase());
    });

  jQuery(document).on("click", "div#fitem_id_schoolslist .form-autocomplete-selection [data-active-selection=true]", function () {
    sessionStorage.removeItem("schoolslistsearchquery");
    sessionStorage.removeItem("selectedSchoolId");
  });	
}
jQuery('select#id_schoolslist').on('change', function () {
    let schoolselectedid = jQuery(this).val(); // Get selected value
    let selectedschoolquery = sessionStorage.getItem('schoolslistsearchquery');
    if (null != selectedschoolquery) {
        sessionStorage.setItem("selectedSchoolId", schoolselectedid);
    }
    jQuery('[name="schoolrecordid"]').val(schoolselectedid); // Update the hidden input field
});





document.addEventListener('DOMContentLoaded', function () {


// Check if elements with the class '.pagelayout-frontpage .single-features-item .default-btn' exist
if (document.querySelector('.pagelayout-frontpage .single-features-item .default-btn')) {
    // Target the buttons and add event listeners
    document.querySelectorAll('.pagelayout-frontpage .single-features-item .default-btn').forEach((button, index) => {
        button.addEventListener('click', () => {
            if (index === 0) {
                localStorage.setItem('selectedRole', 'Student');
            } else if (index === 1) {
                localStorage.setItem('selectedRole', 'Teacher');
            }
        });
    });
}



	// Check if elements with the class '.role-button' exist
    if (document.querySelector('.role-button')) {

        // Get all role buttons
        const roleButtons = document.querySelectorAll('.role-button');
        const roleSelection = document.querySelector('#id_profile_field_RoleSelection');
        const studentInput = document.querySelector('.student-button');
        const teacherInput = document.querySelector('.teacher-button');
        const parentInput = document.querySelector('.parent-button');
        const dobCheckbox = document.querySelector('input#id_profile_field_dob_enabled');
        const googleLoginContainer = document.querySelector('.google-login-container');

        // Function to handle role change
        function handleRoleChange(role) {
            roleSelection.value = role;
            roleSelection.dispatchEvent(new Event('change'));


/*
            // Show/Hide Google Login based on role
            if (role === 'Teacher' || role === 'Parent') {
                googleLoginContainer.style.display = 'block';
            } else {
                googleLoginContainer.style.display = 'none';
            }

*/
            // Specific actions based on role
            if (role === 'Student') {
                dobCheckbox.checked = true;
                dobCheckbox.dispatchEvent(new Event('change'));
            }
        }

        // Add click event listener to each button
        roleButtons.forEach(button => {
            button.addEventListener('click', function () {
                const role = this.getAttribute('data-role');

                // Save the data-role value to local storage
                localStorage.setItem('selectedRole', role);

                // Remove the active class from all buttons
                roleButtons.forEach(btn => btn.classList.remove('active'));

                // Add the active class to the clicked button
                this.classList.add('active');

                // Trigger role change logic
                handleRoleChange(role);
            });
        });

        // Check if there's a saved role in local storage
        const savedRole = localStorage.getItem('selectedRole');

        if (savedRole) {
            // Find the button with the matching data-role value
            const targetButton = document.querySelector(`.role-button[data-role="${savedRole}"]`);

            if (targetButton) {
                // Trigger the click event for the stored value
                targetButton.click();
            }
        } else {
            // Default to "Student" role if no role is saved
            const defaultButton = document.querySelector('.role-button.student-button');
            if (defaultButton) {
                defaultButton.click();
            }
        }
    }
});

// Header Sticky
$(window).on('scroll',function() {
    if ($(this).scrollTop() > 225){
        $('body#page-course-index-category .tertiary-navigation').addClass("bms-sticky");
    }
    else{
        $('body#page-course-index-category .tertiary-navigation').removeClass("bms-sticky");
    }
});

