<?php
defined( 'MOODLE_INTERNAL' ) || die();


require_once $CFG->libdir . '/formslib.php';


// To load JS.
function local_signupvalidations_extend_navigation( global_navigation $navigation ) {
	global $PAGE;
	$PAGE->requires->jquery();
	$PAGE->requires->js( '/local/signupvalidations/js/custom.js' );
	// $PAGE->requires->js_call_amd( 'local_signupvalidations/district', 'init' );
}
// To retrieve all options from a custom user profile field.
function get_user_profile_fields_select_options( $fieldname ) {
    global $DB;
    // Query to get the profile field information from the user_info_field table.
    $field   = $DB->get_record( 'user_info_field', array( 'shortname' => $fieldname ) );
    $options = array();
    // Check if the field exists and is of the type 'menu' (select).
    if ( $field && $field->datatype == 'menu' ) {
        // The options are stored in the param1 column as a newline-separated string.
        $options = explode( "\n", trim( $field->param1 ) );
    }
    return $options;
}

function local_signupvalidations_extend_signup_form( MoodleQuickForm $mform ) {
    global $DB, $PAGE;

    // Remove unnecessary fields.
    $mform->removeElement( 'city' );
    $mform->removeElement( 'country' );

    // Board options (dynamic).
    $boptions = get_user_profile_fields_select_options( 'staticboard' );
    $board_options = array( '' => get_string( 'selectboard', 'local_signupvalidations' ) );
    foreach ( $boptions as $option ) {
        $board_options[ htmlspecialchars( $option ) ] = htmlspecialchars( $option );
    }
    $mform->addElement( 'select', 'profile_field_staticboard', get_string( 'boardselection', 'local_signupvalidations' ), $board_options );
    $mform->setDefault( 'profile_field_staticboard', '' );

    // Medium options (dynamic).
    $moptions = get_user_profile_fields_select_options( 'medium' );
    $medium_options = array( '' => get_string( 'selectmedium', 'local_signupvalidations' ) );
    foreach ( $moptions as $option ) {
        $medium_options[ htmlspecialchars( $option ) ] = htmlspecialchars( $option );
    }
    $mform->addElement( 'select', 'profile_field_medium', get_string( 'mediumselection', 'local_signupvalidations' ), $medium_options );
    $mform->setDefault( 'profile_field_medium', '' );

    // Standard options (dynamic).
    $soptions = get_user_profile_fields_select_options( 'standard' );
    $standard_options = array( '' => get_string( 'selectstandard', 'local_signupvalidations' ) );
    foreach ( $soptions as $option ) {
        $standard_options[ htmlspecialchars( $option ) ] = htmlspecialchars( $option );
    }
    $mform->addElement( 'select', 'profile_field_standard', get_string( 'standardselection', 'local_signupvalidations' ), $standard_options );
    $mform->setDefault( 'profile_field_standard', '' );

    // Additional elements as per requirements.
    $schooloptions = array( 'multiple' => false );
    $mform->addElement( 'autocomplete', 'schoolslist', get_string( 'schoolsearch', 'local_signupvalidations' ), array(), $schooloptions );

    // Hidden field for school record ID.
    $mform->addElement( 'hidden', 'schoolrecordid' );
    $mform->setType( 'schoolrecordid', PARAM_INT );

    // To hide autocomplete.
    $mform->hideIf( 'schoolslist', 'profile_field_RoleSelection', 'eq', 'Parent' );

    // Validation rules (unchanged).
    $mform->addRule( 'email', null, 'email', '', 'client' );
    $mform->addRule( 'email2', null, 'email', '', 'client' );
    $mform->addRule( 'profile_field_mobilenumber', get_string( 'minimumdigits', 'local_signupvalidations', 10 ), 'minlength', 10, 'client' );
    $mform->addRule( 'profile_field_mobilenumber', get_string( 'maximumchars', '', 10 ), 'maxlength', 10, 'client' );
    $mform->addRule( 'profile_field_guardiansemailid', null, 'email', '', 'client' );
    $mform->addRule( 'username', get_string( 'minimumlength', 'local_schoolinfo', 6 ), 'minlength', 6, 'client' );
    $mform->addRule( 'firstname', get_string( 'minimumlength', 'local_schoolinfo', 2 ), 'minlength', 2, 'client' );
    $mform->addRule( 'lastname', get_string( 'minimumlength', 'local_schoolinfo', 2 ), 'minlength', 2, 'client' );
    $mform->addRule( 'profile_field_mobilenumber', get_string( 'missingmobileno', 'local_signupvalidations' ), 'required', null, 'client' );
    $mform->addRule( 'profile_field_employee_id', null, 'numeric', null, 'client' );
    $mform->addRule( 'profile_field_employee_id', get_string( 'minimumdigits', 'local_signupvalidations', 3 ), 'minlength', 3, 'client' );
    $mform->addElement( 'checkbox', 'jeetacceptance', get_string( 'jeetacceptancelabel', 'local_signupvalidations' ), '' );
    $mform->addRule( 'jeetacceptance', get_string( 'missingjeetacceptance', 'local_signupvalidations' ), 'required', null, 'client' );
}

function local_signupvalidations_validate_extend_signup_form( $data ) {
	// Extra Validations on self-registration form elements.
	$errors = array();
	if ( ! empty( $data['profile_field_RoleSelection'] ) ) {
		?>
			<script>
			localStorage.setItem('selectedRole', '<?php echo $data['profile_field_RoleSelection']; ?>');
			</script>
		<?php
	}
	
	if ( ( $data['profile_field_RoleSelection'] !== 'Parent' ) && empty( $data['schoolrecordid'] ) ) {
		$errors['schoolslist'] = get_string( 'schoolsearcherror', 'local_signupvalidations' );
	}
	if ( ! empty( $data['email'] ) && ! empty( $data['email2'] ) ) {
		if ( $data['email'] != $data['email2'] ) {
			$errors['email2'] = get_string( 'confirmemailerror', 'local_signupvalidations' );
		}
	}

	if ( $data['profile_field_RoleSelection'] == 'Student' ) {
		if ( empty( $data['profile_field_guardiansemailid'] ) ) {
			$errors['profile_field_guardiansemailid'] = get_string( 'guardiansemailiderror', 'local_signupvalidations' );
		}
		if ( ! empty( $data['profile_field_guardiansemailid'] ) && ! empty( $data['email'] ) ) {
			if ( ( $data['profile_field_guardiansemailid'] ) == $data['email'] ) {
				$errors['profile_field_guardiansemailid'] = get_string( 'guardianssameerror', 'local_signupvalidations' );
			}
		}
		if ( empty( $data['profile_field_staticboard'] ) ) {
			$errors['profile_field_staticboard'] = get_string( 'boarderror', 'local_signupvalidations' );
		}
		if ( empty( $data['profile_field_medium'] ) ) {
			$errors['profile_field_medium'] = get_string( 'mediumerror', 'local_signupvalidations' );
		}
		if ( empty( $data['profile_field_standard'] ) ) {
			$errors['profile_field_standard'] = get_string( 'standarderror', 'local_signupvalidations' );
		}
	}
	if ( $data['profile_field_RoleSelection'] == 'Teacher' ) {
		if ( empty( $data['profile_field_employee_id'] ) ) {
			$errors['profile_field_employee_id'] = get_string( 'employeeiderror', 'local_signupvalidations' );
		}
	}
	return $errors;
}

function local_signupvalidations_post_signup_requests( $data ) {

	global $DB; // Ensure the global $DB variable is available

	if ( ! empty( $data->profile_field_mobilenumber ) ) {
		$data->profile_field_mobilenumber = $data->profile_field_mobilenumber;
	}
	if ( 'Parent' !== $data->profile_field_RoleSelection ) {

		// Fetch all records from the local_schoolinfo table where the 'id' matches
		$records = $DB->get_records( 'local_schoolinfo', array( 'id' => $data->schoolrecordid ) );

		foreach ( $records as $record ) {
			// Output each record (example)
			$data->profile_field_udisecode = $record->schooludise;
			$data->profile_field_board     = $record->schoolboard;
			$data->profile_field_district  = $record->schooldistrict;
			$data->profile_field_school    = $record->schoolname;
			$data->profile_field_pincode   = $record->schoolpincode;
		}
	}
}
