<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Syllabus Page.
 *
 * @package    local
 * @copyright  2024 Your Name
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once(__DIR__ . '/../config.php');
require_once($CFG->dirroot . '/course/lib.php');

// Set up page settings.
$PAGE->set_url(new moodle_url('/syllabus/index.php'));
$PAGE->set_pagelayout('standard'); // Use a layout that supports blocks.
$PAGE->set_title('Syllabus');
$PAGE->set_context(context_system::instance());
$PAGE->add_body_class('syllabus-page');

// Add editing capabilities for site admins.
$PAGE->set_other_editing_capability('moodle/course:update');
$PAGE->set_other_editing_capability('moodle/course:manageactivities');
$PAGE->set_other_editing_capability('moodle/course:activityvisibility');

// Ensure users are logged in.
require_login();

// Prevent caching for dynamic content.
$PAGE->set_cacheable(false);

// Check if the user has permissions to manage blocks.
$hassiteconfig = has_capability('moodle/site:config', context_system::instance());

// Trigger a course view event.
course_view(context_course::instance(SITEID));

// Enable the editing button for site admins.
if ($hassiteconfig) {
    $editurl = new moodle_url('/syllabus/index.php', ['sesskey' => sesskey(), 'edit' => 1]);
    $PAGE->set_button($OUTPUT->edit_button($editurl));
}

// Check editing status.
$editing = $PAGE->user_is_editing();

// Output the page header.
echo $OUTPUT->header();

// Display a section for adding block content.
if ($editing) {
    echo $OUTPUT->blocks('below-content');
}

// Output the footer.
echo $OUTPUT->footer();
