<?php
/*
@edashRef: @theme_edash/layout
 */

defined('MOODLE_INTERNAL') || die();

$templatecontext = [
    'sitename'                  => format_string($SITE->shortname, true, ['context' => context_course::instance(SITEID), "escape" => false]),
    'output'                    => $OUTPUT,
    'pageheading'               => $pageheading,
    'leftblocks'                => $leftblocks,
    'usernamestring'            => $USER->username, // custom user name fetch for display on profile
    // 'user_profile_picture'      => new moodle_url('/user/pix.php/'.$USER->id.'/f1.jpg'),
   // 'user_profile_picture'      => new moodle_url('/pluginfile.php/52/block_html/content/profile-img.png'),
    'usernameinitialstring'     => strtoupper( \core_user::get_initials( $USER ) ),
    'user_profile_picture'      => $USER->picture ? new moodle_url( '/user/pix.php/' . $USER->id . '/f1.jpg' ) : '',
    'profile_icon_username'     => $edashProfileIconUsername,
    'login_url'                 => $login_url,
    'edu_explorer'              => $EduExplorer,
    'isloggedin'                => $isloggedin,
    'sidepreblocks'             => $blockshtml,
    'hasblocks'                 => $hasblocks,
    'bodyattributes'            => $bodyattributes,
    'primarymoremenu'           => $primarymenu['moremenu'],
    'secondarymoremenu'         => $secondarynavigation ?: false,
    'mobileprimarynav'          => $primarymenu['mobileprimarynav'],
    'usermenu'                  => $primarymenu['user'],
    'langmenu'                  => $primarymenu['lang'],
    'headercontent'             => $headercontent,
    'overflow'                  => $overflow,
    'addblockbutton'            => $addblockbutton,
    'blocks_fullwidth_top'      => $blocks_fullwidth_top,
    'blocks_fullwidth_bottom'   => $blocks_fullwidth_bottom,
    'blocks_above_content'      => $blocks_above_content,
    'has_blocks_above_content'  => !empty($blocks_above_content),
    'blocks_below_content'      => $blocks_below_content,
    'has_blocks_below_content'  => !empty($blocks_below_content),
    'has_blocks_fullwidth_top'  => !empty($blocks_fullwidth_top),
    'regionmainsettingsmenu'    => $regionmainsettingsmenu,
    'hasregionmainsettingsmenu' => !empty($regionmainsettingsmenu),
    'edash_globalsearch_navbar' => $edash_globalsearch_navbar,
    'logo_visibility'           => $logo_visibility,
    'favicon'                   => $favicon,
    'main_logo'                 => $main_logo,
    'logo_styles'               => $logo_styles,
    'mobile_logo'               => $mobile_logo,
    'mobile_logo_styles'        => $mobile_logo_styles,
    'header_search_bar'         => $header_search,
    'header_btn_text'           => format_text($header_btn_text, FORMAT_HTML, array('filter' => true)),
    'header_btn_url'            => $header_btn_url,
    'header_btn_icon'           => $header_btn_icon,

    'footer_logo_visibility'    => $footer_logo_visibility,
    'main_footer_logo'          => $main_footer_logo,
    'footer_logo_styles'        => $footer_logo_styles,

    'social_target_href' => $social_target_href,
    'edash_facebook_url' => get_config('theme_edash', 'edash_facebook_url'),
    'edash_twitter_url' => get_config('theme_edash', 'edash_twitter_url'),
    'edash_instagram_url' => get_config('theme_edash', 'edash_instagram_url'),
    'edash_pinterest_url' => get_config('theme_edash', 'edash_pinterest_url'),
    'edash_dribbble_url' => get_config('theme_edash', 'edash_dribbble_url'),
    'edash_google_url' => get_config('theme_edash', 'edash_google_url'),
    'edash_youtube_url' => get_config('theme_edash', 'edash_youtube_url'),
    'edash_vk_url' => get_config('theme_edash', 'edash_vk_url'),
    'edash_500px_url' => get_config('theme_edash', 'edash_500px_url'),
    'edash_behance_url' => get_config('theme_edash', 'edash_behance_url'),
    'edash_digg_url' => get_config('theme_edash', 'edash_digg_url'),
    'edash_flickr_url' => get_config('theme_edash', 'edash_flickr_url'),
    'edash_foursquare_url' => get_config('theme_edash', 'edash_foursquare_url'),
    'edash_linkedin_url' => get_config('theme_edash', 'edash_linkedin_url'),
    'edash_medium_url' => get_config('theme_edash', 'edash_medium_url'),
    'edash_meetup_url' => get_config('theme_edash', 'edash_meetup_url'),
    'edash_snapchat_url' => get_config('theme_edash', 'edash_snapchat_url'),
    'edash_tumblr_url' => get_config('theme_edash', 'edash_tumblr_url'),
    'edash_vimeo_url' => get_config('theme_edash', 'edash_vimeo_url'),
    'edash_wechat_url' => get_config('theme_edash', 'edash_wechat_url'),
    'edash_whatsapp_url' => get_config('theme_edash', 'edash_whatsapp_url'),
    'edash_wordpress_url' => get_config('theme_edash', 'edash_wordpress_url'),
    'edash_weibo_url' => get_config('theme_edash', 'edash_weibo_url'),
    'edash_telegram_url' => get_config('theme_edash', 'edash_telegram_url'),
    'edash_moodle_url' => get_config('theme_edash', 'edash_moodle_url'),
    'edash_amazon_url' => get_config('theme_edash', 'edash_amazon_url'),
    'edash_slideshare_url' => get_config('theme_edash', 'edash_slideshare_url'),
    'edash_soundcloud_url' => get_config('theme_edash', 'edash_soundcloud_url'),
    'edash_leanpub_url' => get_config('theme_edash', 'edash_leanpub_url'),
    'edash_xing_url' => get_config('theme_edash', 'edash_xing_url'),
    'edash_bitcoin_url' => get_config('theme_edash', 'edash_bitcoin_url'),
    'edash_twitch_url' => get_config('theme_edash', 'edash_twitch_url'),
    'edash_github_url' => get_config('theme_edash', 'edash_github_url'),
    'edash_gitlab_url' => get_config('theme_edash', 'edash_gitlab_url'),
    'edash_forumbee_url' => get_config('theme_edash', 'edash_forumbee_url'),
    'edash_trello_url' => get_config('theme_edash', 'edash_trello_url'),
    'edash_weixin_url' => get_config('theme_edash', 'edash_weixin_url'),
    'edash_slack_url' => get_config('theme_edash', 'edash_slack_url'),

    'footer_copyright' => format_text($footer_copyright, FORMAT_HTML, array('filter' => true)),
    'footer_shape_image'               => $footer_shape_image,
    'back_to_top' => $back_to_top == 0,
    'hide_global_banner'     => $hide_global_banner == 0,

    'footer_column_1' => $footer_column_1,
    'footer_column_2' => $footer_column_2,
    'footer_column_3' => $footer_column_3,
    'footer_column_4' => $footer_column_4,
    'footer_column_5' => $footer_column_5,
    'footer_col_1_class' => $footer_col_1_class,
    'footer_col_2_class' => $footer_col_2_class,
    'footer_col_3_class' => $footer_col_3_class,
    'footer_col_4_class' => $footer_col_4_class,
    'footer_col_5_class' => $footer_col_5_class,
    'footer_col_1_title' => format_text(get_config('theme_edash', 'footer_col_1_title'), FORMAT_HTML, array('filter' => true)),
    'footer_col_1_body' => format_text(get_config('theme_edash', 'footer_col_1_body'), FORMAT_HTML, array('filter' => true)),
    'footer_col_2_title' => format_text(get_config('theme_edash', 'footer_col_2_title'), FORMAT_HTML, array('filter' => true)),
    'footer_col_2_body' => format_text(get_config('theme_edash', 'footer_col_2_body'), FORMAT_HTML, array('filter' => true)),
    'footer_col_3_title' => format_text(get_config('theme_edash', 'footer_col_3_title'), FORMAT_HTML, array('filter' => true)),
    'footer_col_3_body' => format_text(get_config('theme_edash', 'footer_col_3_body'), FORMAT_HTML, array('filter' => true)),
    'footer_col_4_title' => format_text(get_config('theme_edash', 'footer_col_4_title'), FORMAT_HTML, array('filter' => true)),
    'footer_col_4_body' => format_text(get_config('theme_edash', 'footer_col_4_body'), FORMAT_HTML, array('filter' => true)),
    'footer_col_5_title' => format_text(get_config('theme_edash', 'footer_col_5_title'), FORMAT_HTML, array('filter' => true)),
    'footer_col_5_body' => format_text(get_config('theme_edash', 'footer_col_5_body'), FORMAT_HTML, array('filter' => true)),
    
    'loginsignupdiscription_h1' => get_string('loginsignupdiscription_h1', 'theme_edash'),
    'loginsignupdiscription_h2' => get_string('loginsignupdiscription_h2', 'theme_edash'),
    'loginsignupdiscription_content' => get_string('loginsignupdiscription_content', 'theme_edash'),

];
$PAGE->requires->jquery();
