<?php

require_once('../../config.php');
require_once($CFG->libdir.'/tablelib.php');

global $DB, $PAGE, $OUTPUT;

// Page setup.
$PAGE->set_url(new moodle_url('/local/schoolinfo/view.php'));
$PAGE->set_context(context_system::instance());
$PAGE->set_title(get_string('manage_schoolinfos', 'local_schoolinfo'));
$PAGE->set_heading(get_string('manage_schoolinfos', 'local_schoolinfo'));

echo $OUTPUT->header();

// Initialize the table.
$table = new flexible_table('unique_table_id');
$table->define_columns(array('udisecode_column', 'schoolname_column', 'schoolpincode_column', 'edit_column'));
$table->define_headers(array(get_string('udisecode_column', 'local_schoolinfo'), get_string('schoolname_column', 'local_schoolinfo'), get_string('schoolpincode_column', 'local_schoolinfo'), get_string('edit_column', 'local_schoolinfo')));
$table->define_baseurl($PAGE->url);
// $table->sortable(true, 'udisecode_column');
$table->no_sorting('schoolpincode_column');
$table->pageable(true);
$table->set_attribute('cellspacing', '0');
$table->set_attribute('id', 'unique_table_id');
$table->set_attribute('class', 'generaltable generalbox');
$table->setup();

$perpage = 1;
$page = optional_param('page', 0, PARAM_INT);
$start = $page * $perpage;

$totalcount = $DB->count_records('local_schoolinfo');
// print_r($totalcount);
$records = $DB->get_records('local_schoolinfo', null, 'id ASC', '*', $start, $perpage);
$editurl = new moodle_url('/local/schoolinfo/edit.php'); // Assign your edit URL

foreach ($records as $record) {
    $data = array();
    $data[] = $record->schooludise;
    $data[] = $record->schoolname;
    $data[] = $record->schoolpincode;
    $data[] = '<input type="button" class="btn btn-primary" value="Edit" onclick="location.href=\'' . $editurl . '?schoolinfoid=' . $record->id . '\'">';
    $data[] = '<input type="button" class="local_schoolinfoid' . $record->id . ' btn btn-danger local_schoolinfo_delete_button" value="Delete">';
    $table->add_data($data);
}

$table->print_html();
echo $OUTPUT->paging_bar($totalcount, $page, $perpage, $PAGE->url);

echo $OUTPUT->footer();
